/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium;

import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.selenium.QAFCommandProcessor;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandListener;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandTracker;
import com.qmetry.qaf.automation.ui.selenium.WaitService;
import com.qmetry.qaf.automation.util.StackTraceUtils;
import com.qmetry.qaf.automation.util.StringUtil;
import com.thoughtworks.selenium.Wait;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class AutoWaitInjector
implements SeleniumCommandListener {
    private final Log logger = LogFactoryImpl.getLog(AutoWaitInjector.class);
    private String excommannds = String.valueOf(this.excommannds) + "," + ApplicationProperties.AUTO_WAIT_EXCLUDE_CMD.getStringVal(new String[0]);
    private String commands = String.valueOf(this.commands) + "," + ApplicationProperties.AUTO_WAIT_INCLUDE_CMD.getStringVal(new String[0]);

    @Override
    public void afterCommand(QAFCommandProcessor proc, SeleniumCommandTracker sc) {
    }

    @Override
    public void beforeCommand(final QAFCommandProcessor proc, SeleniumCommandTracker commandTracker) {
        boolean isWaitInvolved = StackTraceUtils.isWaitInvolved();
        if (!ApplicationProperties.SKIP_AUTO_WAIT.getBoolenVal(false) && commandTracker.getArgs() != null && commandTracker.getArgs().length > 0 && StringUtil.isNotBlank((String)commandTracker.getArgs()[0]) && !this.exclude(commandTracker.getCommand()) && this.include(commandTracker.getCommand()) && !isWaitInvolved) {
            final String loc = commandTracker.getArgs()[0];
            try {
                new Wait(){

                    public boolean until() {
                        return proc.getBoolean("isElementPresent", new String[]{loc});
                    }
                }.wait("Wait time out before command" + commandTracker.getCommand(), WaitService.getDefaultPageWaitTimeNum());
            }
            catch (Throwable e) {
                this.logger.debug((Object)("AutoWait beforeCommand" + e));
            }
            if (commandTracker.getCommand().equalsIgnoreCase("select")) {
                try {
                    new Wait(){

                        public boolean until() {
                            return StringUtil.isNotBlank((String)proc.getString("getSelectedIndex", new String[]{loc}));
                        }
                    }.wait("Wait time out before Select" + commandTracker.getCommand(), WaitService.getDefaultPageWaitTimeNum());
                }
                catch (Throwable e) {
                    this.logger.debug((Object)e);
                }
            }
        }
    }

    private boolean skip(String commandName) {
        this.excommannds = String.valueOf(this.excommannds) + "isTextPresent,isElementPresent,getExpression,getXpathCount," + "getEval,allowNativeXpath,ignoreAttributesWithoutValue,runScript,open";
        return commandName.contains("Cookie") || commandName.contains("Window") || commandName.contains("Prompt") || commandName.contains("Location") || commandName.contains("Browser") || commandName.contains("capture") || commandName.contains("Native") || this.excommannds.toUpperCase().contains(commandName.toUpperCase()) || commandName.startsWith("wait") || commandName.toLowerCase().contains("flex") || commandName.toLowerCase().startsWith("add") || commandName.toLowerCase().startsWith("set");
    }

    private boolean include(String command) {
        String[] cmds;
        boolean retVal = false;
        String[] stringArray = cmds = this.commands.split(",");
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (cmd.trim().length() > 0 && command.trim().toUpperCase().contains(cmd.trim().toUpperCase())) {
                return true;
            }
            ++n2;
        }
        return retVal;
    }

    private boolean exclude(String command) {
        String[] cmds;
        boolean retVal = false;
        String[] stringArray = cmds = this.excommannds.split(",");
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (cmd.trim().length() > 0 && command.trim().toUpperCase().contains(cmd.trim().toUpperCase())) {
                return true;
            }
            ++n2;
        }
        return retVal;
    }

    private boolean excludeInerval(String command) {
        String[] cmds;
        boolean retVal = false;
        String[] stringArray = cmds = new String[]{"window", "wait", "set", "open", "stop", "capture", "focus"};
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            String cmd = stringArray[n2];
            if (cmd.trim().length() > 0 && command.trim().toUpperCase().contains(cmd.trim().toUpperCase())) {
                return true;
            }
            ++n2;
        }
        return retVal;
    }
}

