/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium.webdriver;

import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.util.StringUtil;
import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import org.openqa.selenium.WebDriver;

public class SetAttributeCommand
extends SeleneseCommand<Void> {
    private final ElementFinder finder;
    private final JavascriptLibrary js;

    public SetAttributeCommand(JavascriptLibrary js, ElementFinder finder) {
        this.js = js;
        this.finder = finder;
    }

    protected Void handleSeleneseCommand(WebDriver driver, String attributeLocator, String value) {
        int atSign = attributeLocator.lastIndexOf("@");
        String elementLocator = attributeLocator.substring(0, atSign);
        String attributeName = attributeLocator.substring(atSign + 1);
        if (!(StringUtil.isNumeric((String)value) || "true".equals(value) || "false".equals(value) || value.startsWith("'") || value.startsWith("\""))) {
            value = "\"" + value + "\"";
        }
        try {
            ((QAFExtendedWebDriver)driver).findElement(elementLocator).executeScript("setAttribute('" + attributeName + "'," + value + ")");
        }
        catch (Exception exception) {
            if (attributeName.equalsIgnoreCase("style")) {
                ((QAFExtendedWebDriver)driver).findElement(elementLocator).executeScript("style.setAttribute('cssText'," + value + ")");
            }
            if (attributeName.equalsIgnoreCase("class")) {
                ((QAFExtendedWebDriver)driver).findElement(elementLocator).executeScript("className=" + value);
            }
            this.js.executeScript(driver, "arguments[0]." + attributeName + " = arguments[1]", new Object[]{this.finder.findElement(driver, elementLocator), value});
        }
        return null;
    }
}

