/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Constructor;
import java.util.Collection;
import org.openqa.selenium.remote.RemoteWebElement;

public class QAFElementConverter
implements Function<Object, Object> {
    private final QAFExtendedWebDriver driver;

    public QAFElementConverter(QAFExtendedWebDriver driver) {
        this.driver = driver;
    }

    public Object apply(Object result) {
        if (result instanceof Collection) {
            Collection results = (Collection)result;
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)results, (Function)this));
        }
        if (result instanceof RemoteWebElement && !(result instanceof QAFExtendedWebElement)) {
            QAFExtendedWebElement ele = this.newRemoteWebElement();
            ele.setId(((RemoteWebElement)result).getId());
            return ele;
        }
        return result;
    }

    private QAFExtendedWebElement newRemoteWebElement() {
        String elemImpl = ConfigurationManager.getBundle().getString("default.element.impl");
        if (StringUtil.isBlank((String)elemImpl)) {
            QAFExtendedWebElement toReturn = new QAFExtendedWebElement(this.driver);
            return toReturn;
        }
        try {
            Class<?> cls = Class.forName(ConfigurationManager.getBundle().getString("default.element.impl", QAFExtendedWebElement.class.getCanonicalName()));
            Constructor<?> con = cls.getDeclaredConstructor(QAFExtendedWebDriver.class);
            con.setAccessible(true);
            Object toReturn = con.newInstance(this.driver);
            return (QAFExtendedWebElement)toReturn;
        }
        catch (ClassNotFoundException e) {
            throw new AutomationError("Unable to find class " + elemImpl + " to create element. ", e);
        }
        catch (Exception e) {
            throw new AutomationError("Unable to create element using " + elemImpl + ". Make sure it is subclass of QAFExtendedWebElement and has consrtuctor excepting QAFExtendedWebDriver argument", e);
        }
    }
}

