/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.List;

public class ReportUtils {
    private ReportUtils() {
    }

    public static String getFailureMessage(Throwable t) {
        if (t == null) {
            return "";
        }
        String msg = t.getMessage();
        if (StringUtil.isNotBlank((String)msg)) {
            return msg;
        }
        return t.toString();
    }

    public static void setScreenshot(Throwable t) {
        String failiremsg = ReportUtils.getFailureMessage(t);
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        CheckpointResultBean lastFailedChkPoint = ReportUtils.getLastFailedCheckpointResultBean(stb.getCheckPointResults());
        if (lastFailedChkPoint != null) {
            if (StringUtil.isBlank((String)lastFailedChkPoint.getScreenshot())) {
                CheckpointResultBean lastFailedSubChkPoint = ReportUtils.getLastFailedCheckpointResultBean(lastFailedChkPoint.getSubCheckPoints());
                if (lastFailedSubChkPoint != null && StringUtil.isNotBlank((String)lastFailedSubChkPoint.getScreenshot())) {
                    lastFailedChkPoint.setScreenshot(lastFailedSubChkPoint.getScreenshot());
                } else {
                    stb.takeScreenShot();
                    lastFailedChkPoint.setScreenshot(stb.getLastCapturedScreenShot());
                }
            }
        } else if (StringUtil.isNotBlank((String)failiremsg)) {
            stb.takeScreenShot();
            CheckpointResultBean stepResultBean = new CheckpointResultBean();
            stepResultBean.setMessage(failiremsg);
            stepResultBean.setType(MessageTypes.Fail);
            stepResultBean.setScreenshot(stb.getLastCapturedScreenShot());
            stb.getCheckPointResults().add(stepResultBean);
        }
    }

    public static CheckpointResultBean getLastFailedCheckpointResultBean(List<CheckpointResultBean> checkPointResults) {
        if (checkPointResults == null || checkPointResults.isEmpty()) {
            return null;
        }
        int index = checkPointResults.size() - 1;
        while (index >= 0) {
            CheckpointResultBean checkpointResultBean = checkPointResults.get(index);
            MessageTypes type = MessageTypes.valueOf(checkpointResultBean.getType());
            if (type.isFailure()) {
                return checkpointResultBean;
            }
            --index;
        }
        return null;
    }
}

