/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.qmetry.qaf.automation.keys.ApplicationProperties;

public enum MessageTypes {
    Info,
    Pass,
    Warn,
    Fail,
    TestStep,
    TestStepPass,
    TestStepFail;

    private static final boolean REPORT_SUCCESS;
    private static final MessageTypes REPORT_LOG_LEVEL;
    private Boolean shouldReport = null;
    private static final String MSG_FORMAT = "<div  class=\"%s\"><span class=\"%s-label\">%s </span>%s</div>";

    static {
        REPORT_SUCCESS = !ApplicationProperties.REPORT_SKIP_SUCCESS.getBoolenVal(false);
        REPORT_LOG_LEVEL = MessageTypes.getLogLevel();
    }

    public String formatMessage(String message) {
        return String.format(MSG_FORMAT, this.name().toLowerCase(), this.name().toLowerCase(), Character.valueOf(this.name().charAt(0)), message);
    }

    public String formatText(String message) {
        return String.format("%s: %s", this.name(), message);
    }

    public boolean isFailure() {
        return this.name().toUpperCase().contains("FAIL");
    }

    public boolean shouldReport() {
        if (this.shouldReport == null) {
            this.shouldReport = this.isFailure() || this.ordinal() >= REPORT_LOG_LEVEL.ordinal() && (!this.equals((Object)Pass) || REPORT_SUCCESS);
        }
        return this.shouldReport;
    }

    private static MessageTypes getLogLevel() {
        try {
            return MessageTypes.valueOf(ApplicationProperties.REPORT_LOG_LEVEL.getStringVal("Info"));
        }
        catch (Exception exception) {
            System.err.println("Invalid log level value for report.log.level. It can be one of \"Info\", \"Pass\", \"Fail\".\nUsing default \"Info\".");
            return Info;
        }
    }
}

