/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.qmetry.qaf.automation.gson.ObjectWrapper;
import com.qmetry.qaf.automation.util.ClassUtil;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GsonDeserializerObjectWrapper
implements JsonDeserializer<ObjectWrapper> {
    JsonDeserializationContext context;
    private Type type;

    public GsonDeserializerObjectWrapper(Type type) {
        this.type = type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ObjectWrapper deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        this.context = context;
        return new ObjectWrapper(this.read(json, this.type));
    }

    private Object read(JsonElement in, Type typeOfT) {
        if (in.isJsonArray()) {
            Class<?> cls = ClassUtil.getClass(typeOfT).getComponentType();
            if (cls != null && cls.isPrimitive()) {
                return this.context.deserialize(in, typeOfT);
            }
            JsonArray arr = in.getAsJsonArray();
            boolean isArray = this.isArray(typeOfT);
            ArrayList<Object> list = isArray ? new ArrayList<Object>() : (Collection)this.context.deserialize((JsonElement)new JsonArray(0), typeOfT);
            for (JsonElement anArr : arr) {
                list.add(this.read(anArr, this.getTypeArguments(typeOfT, 0)));
            }
            if (isArray) {
                return this.toArray((List)list, cls);
            }
            try {
                return ClassUtil.getClass(typeOfT).cast(list);
            }
            catch (Exception exception) {
                return this.context.deserialize(in, typeOfT);
            }
        }
        if (in.isJsonObject() && (ClassUtil.isAssignableFrom(typeOfT, Map.class) || ClassUtil.getClass(typeOfT).equals(Object.class))) {
            Map map = (Map)this.context.deserialize((JsonElement)new JsonObject(), typeOfT);
            JsonObject obj = in.getAsJsonObject();
            Set entitySet = obj.entrySet();
            for (Map.Entry entry : entitySet) {
                map.put(entry.getKey(), this.read((JsonElement)entry.getValue(), this.getTypeArguments(typeOfT, 1)));
            }
            return map;
        }
        if (in.isJsonPrimitive() && ClassUtil.getClass(typeOfT).equals(Object.class)) {
            JsonPrimitive prim = in.getAsJsonPrimitive();
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            if (prim.isString()) {
                return prim.getAsString();
            }
            if (prim.isNumber()) {
                if (prim.getAsString().contains(".")) {
                    return prim.getAsDouble();
                }
                return prim.getAsLong();
            }
        }
        return this.context.deserialize(in, typeOfT);
    }

    private Type getTypeArguments(Type typeOfT, int index) {
        try {
            return ((ParameterizedType)typeOfT).getActualTypeArguments()[index];
        }
        catch (Exception exception) {
            try {
                Class<?> ctype = ClassUtil.getClass(typeOfT).getComponentType();
                if (ctype != null) {
                    return ctype;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return Object.class;
        }
    }

    private <T> T[] toArray(List<T> list, Class<?> t) {
        if (list == null) {
            return null;
        }
        try {
            Object[] objArray = (Object[])Array.newInstance(t, list.size());
            return list.toArray(objArray);
        }
        catch (ClassCastException classCastException) {
            try {
                Class<?> clazz = list.get(0).getClass();
                Object[] array = (Object[])Array.newInstance(clazz, list.size());
                return list.toArray(array);
            }
            catch (ArrayStoreException | IndexOutOfBoundsException runtimeException) {
                Object[] objArray = (Object[])Array.newInstance(Object.class, list.size());
                return list.toArray(objArray);
            }
        }
    }

    private boolean isArray(Type typeOfT) {
        return ClassUtil.getClass(typeOfT).isArray();
    }
}

