/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.http;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class UriProxySelector
extends ProxySelector {
    private static final Log logger = LogFactoryImpl.getLog(UriProxySelector.class);
    private static final String PROXY_SERVER_KEY = "proxy.server";
    private static final String PROXY_PORT_KEY = "proxy.port";
    private static final String PROXY_HOSTS_KEY = "host.to.proxy";
    private static final UriProxySelector INSTANCE = new UriProxySelector();
    private ProxySelector defaultSelector = ProxySelector.getDefault();
    private List<String> hostsToProxy = null;
    private List<Proxy> proxies = null;

    private UriProxySelector() {
        logger.info((Object)"Registed UriProxySelector");
    }

    public static UriProxySelector getInstance() {
        return INSTANCE;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (this.proxies == null) {
            this.intiProxySettings();
        }
        if (this.proxies != null && !this.proxies.isEmpty() && this.hostsToProxy != null) {
            for (String host : this.hostsToProxy) {
                if (!uri.getHost().toUpperCase().contains(host.toUpperCase())) continue;
                return this.proxies;
            }
        }
        return this.defaultSelector.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.defaultSelector.connectFailed(uri, sa, ioe);
    }

    private void intiProxySettings() {
        try {
            this.hostsToProxy = ConfigurationManager.getBundle().getList(PROXY_HOSTS_KEY);
            String proxyServer = ConfigurationManager.getBundle().getString(PROXY_SERVER_KEY, "");
            int proxyPort = ConfigurationManager.getBundle().getInt(PROXY_PORT_KEY, 80);
            if (StringUtil.isNotBlank((String)proxyServer)) {
                InetSocketAddress sa = new InetSocketAddress(proxyServer, proxyPort);
                this.proxies = Arrays.asList(new Proxy(Proxy.Type.HTTP, sa), new Proxy(Proxy.Type.SOCKS, sa));
                logger.info((Object)("proxy settings done using proxy server " + this.proxies + " for " + this.hostsToProxy));
            } else {
                logger.warn((Object)"proxy ignored as missing proxyServer. To enable proxy make sure you have non blank value of property 'proxy.server'");
                this.proxies = new ArrayList<Proxy>();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to init proxy settings", (Throwable)e);
        }
    }
}

