/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.integration;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TestCaseRunResult {
    private Collection<CheckpointResultBean> checkPoints;
    private Collection<LoggingBean> commandLogs;
    private Status status;
    private Map<String, Object> metaData;
    private Collection<Object> testData;
    private Collection<String> steps;
    private long starttime;
    private long endtime = System.currentTimeMillis();
    private Map<String, Object> executionInfo;
    private String className;
    private boolean willRetry;
    private boolean isTest;
    private Throwable throwable;

    public TestCaseRunResult(Status status, Map<String, Object> metaData, Object[] testData, Map<String, Object> executionInfo, Collection<String> steps, long starttime, boolean willRetry, boolean isTest) {
        Map<String, String> cap;
        this.starttime = starttime;
        QAFTestBase testBase = (QAFTestBase)TestBaseProvider.instance().get();
        this.checkPoints = new ArrayList<CheckpointResultBean>(testBase.getCheckPointResults());
        this.commandLogs = new ArrayList<LoggingBean>(testBase.getLog());
        this.status = status;
        this.willRetry = willRetry;
        this.isTest = isTest;
        this.metaData = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        try {
            metaData.values().removeAll(Collections.singleton(null));
            metaData.remove(QAFDataProvider.params.JSON_DATA_TABLE.name());
        }
        catch (Throwable throwable) {}
        if (metaData != null) {
            this.metaData.putAll(metaData);
        }
        this.testData = new ArrayList<Object>();
        if (testData != null && testData.length > 0) {
            this.testData.addAll(Arrays.asList(testData));
        }
        this.executionInfo = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (executionInfo != null) {
            this.executionInfo.putAll(executionInfo);
        }
        if (!(cap = TestCaseRunResult.getActualCapabilities()).isEmpty()) {
            this.executionInfo.put("driverCapabilities", cap);
        }
        this.steps = new ArrayList<String>(steps);
    }

    public Collection<CheckpointResultBean> getCheckPoints() {
        return this.checkPoints;
    }

    public void setCheckPoints(Collection<CheckpointResultBean> checkPoints) {
        this.checkPoints = checkPoints;
    }

    public Collection<LoggingBean> getCommandLogs() {
        return this.commandLogs;
    }

    public void setCommandLogs(Collection<LoggingBean> commandLogs) {
        this.commandLogs = commandLogs;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData.clear();
        this.metaData.putAll(metaData);
    }

    public Collection<Object> getTestData() {
        return this.testData;
    }

    public void setTestData(Object[] testData) {
        this.testData.clear();
        if (testData != null && testData.length > 0) {
            this.testData.addAll(Arrays.asList(testData));
        }
    }

    public Collection<String> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<String> steps) {
        this.steps.clear();
        this.steps.addAll(steps);
    }

    public long getStarttime() {
        return this.starttime;
    }

    public void setStarttime(long starttime) {
        this.starttime = starttime;
    }

    public long getEndtime() {
        return this.endtime;
    }

    public void setEndtime(long endtime) {
        this.endtime = endtime;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return (String)this.getMetaData().get("name");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Map<String, Object> getExecutionInfo() {
        return this.executionInfo;
    }

    public void setExecutionInfo(Map<String, Object> executionInfo) {
        this.executionInfo.clear();
        this.executionInfo.putAll(executionInfo);
    }

    public boolean willRetry() {
        return this.willRetry;
    }

    public boolean isTest() {
        return this.isTest;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    private static Map<String, String> getActualCapabilities() {
        Map map = (Map)ConfigurationManager.getBundle().getObject("driver.actualCapabilities");
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (map != null) {
            for (String key : map.keySet()) {
                try {
                    newMap.put(key, String.valueOf(map.get(key)));
                }
                catch (Exception exception) {}
            }
        }
        return newMap;
    }

    public static enum Status {
        PASS("Pass", "pass", "Passed", "Passed", "pass"),
        FAIL("Fail", "fail", "Failed", "Failed", "fail"),
        SKIPPED("Not Testable", "notrun", "No Run", "Not Run", "skip");

        private String rally;
        private String qmetry;
        private String qc;
        private String qmetry6;
        private String qaf;

        private Status(String toRally, String toQmetry, String toQC, String toQmetry6, String toQAF) {
            this.rally = toRally;
            this.qmetry = toQmetry;
            this.qmetry6 = toQmetry6;
            this.qc = toQC;
            this.qaf = toQAF;
        }

        public String toRally() {
            return this.rally;
        }

        public String toQmetry() {
            return this.qmetry;
        }

        public String toQC() {
            return this.qc;
        }

        public String toQmetry6() {
            return this.qmetry6;
        }

        public String toQAF() {
            return this.qaf;
        }
    }
}

