/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client;

import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.TestStepCompositer;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.TestNGMethod;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestNGScenario
extends TestNGMethod {
    private static final long serialVersionUID = 6225163528424712337L;
    private TestStepCompositer testStepCompositer;
    private Map<String, Object> metadata;
    private String qualifiledName;

    public TestNGScenario(TestNGMethod testNGMethod) {
        this(testNGMethod.getConstructorOrMethod().getMethod(), (IAnnotationFinder)ClassUtil.getField("m_annotationFinder", testNGMethod), testNGMethod.getXmlTest(), testNGMethod.getInstance());
        if (testNGMethod.getTestClass() != null) {
            this.setTestClass(testNGMethod.getTestClass());
        }
    }

    public TestNGScenario(Method method, IAnnotationFinder finder, XmlTest xmlTest, Object instance) {
        super(method, finder, xmlTest, instance);
        this.init(instance);
    }

    private void init(Object instance) {
        if (Scenario.class.isAssignableFrom(this.getRealClass())) {
            Scenario scenario = (Scenario)instance;
            this.testStepCompositer = scenario;
            if (scenario.getPriority() < 1000 || !this.getXmlTest().getParallel().isParallel() || this.getXmlTest().getParallel().equals((Object)XmlSuite.ParallelMode.TESTS)) {
                this.setPriority(scenario.getPriority());
            }
            this.setGroups(scenario.getM_groups());
            this.setGroupsDependedUpon(scenario.getM_groupsDependedUpon(), new ArrayList());
            this.setMethodsDependedUpon(scenario.getM_methodsDependedUpon());
            this.setDescription(scenario.getDescription());
            this.setEnabled(scenario.isM_enabled());
            this.setAlwaysRun(scenario.isM_isAlwaysRun());
            this.setIgnoreMissingDependencies(scenario.getIgnoreMissingDependencies());
            this.metadata = scenario.getMetadata();
            this.qualifiledName = scenario.getTestName();
            this.setTimeOut(scenario.getTimeOut());
        } else {
            this.metadata = MetaDataScanner.getMetadata(this.getConstructorOrMethod().getMethod(), true);
            this.qualifiledName = String.valueOf(this.getRealClass().getName()) + "." + this.getMethodName();
        }
        if (!this.metadata.containsKey("name")) {
            this.metadata.put("name", this.getMethodName());
        }
        this.metadata.put("sign", this.getSignature());
    }

    void setTestStepCompositer(TestStepCompositer testStepCompositer) {
        this.testStepCompositer = testStepCompositer;
    }

    private Scenario getScenario() {
        if (Scenario.class.isAssignableFrom(this.getRealClass())) {
            return (Scenario)this.testStepCompositer;
        }
        return null;
    }

    public String getMethodName() {
        return this.getScenario() != null ? this.getScenario().getTestName() : super.getMethodName();
    }

    public String getSignature() {
        return this.getScenario() != null ? this.computeSign() : super.getSignature();
    }

    private String computeSign() {
        StringBuilder result = new StringBuilder(this.getScenario().getSignature());
        result.append("[pri:").append(this.getPriority()).append(", instance:").append(this.getInstance()).append("]");
        return result.toString();
    }

    public Map<String, Object> getMetaData() {
        return this.metadata;
    }

    public int decAndgetCurrentInvocationCount() {
        this.m_currentInvocationCount = new AtomicInteger(this.getCurrentInvocationCount() - 1);
        return super.getCurrentInvocationCount();
    }

    public String getQualifiedName() {
        return this.qualifiledName;
    }

    public Collection<String> getSteps() {
        if (this.testStepCompositer != null) {
            ArrayList<String> steps = new ArrayList<String>();
            for (TestStep step : this.testStepCompositer.getSteps()) {
                steps.add(step.getDescription());
            }
            return steps;
        }
        return Collections.emptyList();
    }

    public String getClassOrFileName() {
        if (this.getScenario() != null && StringUtil.isNotBlank((String)this.getScenario().getFileName())) {
            return this.getScenario().getFileName();
        }
        return this.getRealClass().getName();
    }

    public BaseTestMethod clone() {
        TestNGScenario clone = new TestNGScenario(this.getConstructorOrMethod().getMethod(), this.getAnnotationFinder(), this.getXmlTest(), this.getInstance());
        ITestClass tc = this.getTestClass();
        NoOpTestClass testClass = new NoOpTestClass(tc);
        testClass.setBeforeTestMethods(this.clone(tc.getBeforeTestMethods()));
        testClass.setAfterTestMethod(this.clone(tc.getAfterTestMethods()));
        clone.m_testClass = testClass;
        return clone;
    }

    private ITestNGMethod[] clone(ITestNGMethod[] sources) {
        ITestNGMethod[] clones = new ITestNGMethod[sources.length];
        int i = 0;
        while (i < sources.length) {
            clones[i] = sources[i].clone();
            ++i;
        }
        return clones;
    }
}

