/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client.text;

import com.google.gson.Gson;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.step.client.AbstractScenarioFileParser;
import com.qmetry.qaf.automation.step.client.text.BehaviorScanner;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BDDFileParser
extends AbstractScenarioFileParser {
    private static final Log logger = LogFactory.getLog(BehaviorScanner.class);
    private static final String LINE_BREAK = "_&";
    private static final String COMMENT_CHARS = "#!";
    private static final String BACKGROUND = "Background";
    private static final String MULTI_LINE_COMMENT = "\"\"\"";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Collection<Object[]> parseFile(String strFile) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ArrayList<Object[]> background = new ArrayList<Object[]>();
        int lineNo = 0;
        int lastScenarioIndex = -1;
        BufferedReader br = null;
        try {
            try {
                logger.info((Object)("loading BDD file: " + strFile));
                File textFile = new File(strFile);
                br = new BufferedReader(new FileReader(textFile));
                String strLine = "";
                boolean bIsBackground = false;
                StringBuffer currLineBuffer = new StringBuffer();
                while (true) {
                    Object[] cols;
                    block24: {
                        if ((strLine = br.readLine()) == null) {
                            return rows;
                        }
                        ++lineNo;
                        if ("".equalsIgnoreCase(strLine.trim()) || COMMENT_CHARS.contains("" + strLine.trim().charAt(0))) continue;
                        currLineBuffer.append(strLine.trim());
                        if (strLine.endsWith(LINE_BREAK)) {
                            currLineBuffer.delete(currLineBuffer.length() - LINE_BREAK.length(), currLineBuffer.length());
                            continue;
                        }
                        cols = new Object[]{"", "", "", lineNo};
                        String currLine = currLineBuffer.toString();
                        if (StringUtil.indexOfIgnoreCase((String)currLine, (String)"SCENARIO") == 0 || StringUtil.indexOfIgnoreCase((String)currLine, (String)BACKGROUND) == 0 || StringUtil.indexOfIgnoreCase((String)currLine, (String)"STEP-DEF") == 0 || StringUtil.indexOfIgnoreCase((String)currLine, (String)"META") == 0) {
                            System.arraycopy(currLine.split(":", 2), 0, cols, 0, 2);
                            if (StringUtil.indexOfIgnoreCase((String)((String)cols[0]).trim(), (String)"META") == 0) {
                                Object[] prevRow = rows.get(lastScenarioIndex);
                                prevRow[2] = ((String)cols[1]).trim();
                                currLineBuffer = new StringBuffer();
                                continue;
                            }
                            if (StringUtil.indexOfIgnoreCase((String)currLine, (String)BACKGROUND) == 0) {
                                bIsBackground = true;
                                currLineBuffer = new StringBuffer();
                                continue;
                            }
                            lastScenarioIndex = rows.size();
                            bIsBackground = false;
                        } else {
                            if (currLineBuffer.toString().startsWith(MULTI_LINE_COMMENT)) {
                                if (StringUtil.indexOfIgnoreCase((String)currLine, (String)MULTI_LINE_COMMENT, (int)3) > 0) {
                                    cols[1] = new Gson().toJson((Object)new String[]{currLine.replace(MULTI_LINE_COMMENT, "")});
                                    break block24;
                                } else {
                                    currLineBuffer.append("\n");
                                    continue;
                                }
                            }
                            cols[0] = currLine;
                        }
                    }
                    if (bIsBackground) {
                        background.add(cols);
                    } else {
                        if (lastScenarioIndex >= 0) {
                            rows.add(cols);
                        }
                        if (StringUtil.indexOfIgnoreCase((String)((String)cols[0]), (String)"SCENARIO") == 0) {
                            rows.addAll(background);
                        }
                    }
                    currLineBuffer = new StringBuffer();
                }
            }
            catch (Exception e) {
                String strMsg = "Exception while reading BDD file: " + strFile + "#" + lineNo;
                logger.error((Object)(String.valueOf(strMsg) + e));
                throw new AutomationError(strMsg, e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

