/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.StepInvocationException;
import com.qmetry.qaf.automation.step.client.TestNGScenario;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.List;
import org.testng.IRetryAnalyzer;
import org.testng.ITestResult;

public class RetryAnalyzer
implements IRetryAnalyzer {
    public static String RETRY_INVOCATION_COUNT = "retry.invocation.count";
    public static String WILL_RETRY = "retry.invocation.willretry";

    public boolean retry(ITestResult result) {
        boolean shouldRetry = this.shouldRetry(result);
        if (shouldRetry) {
            try {
                if (result.getMethod() instanceof TestNGScenario) {
                    ((TestNGScenario)result.getMethod()).decAndgetCurrentInvocationCount();
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
            int retryInvocationCount = this.getRetryCount() + 1;
            System.err.println("Retrying [" + result.getName() + "]" + StringUtil.toStringWithSufix(retryInvocationCount) + " time.");
            ConfigurationManager.getBundle().addProperty(RETRY_INVOCATION_COUNT, retryInvocationCount);
            ConfigurationManager.getBundle().addProperty(WILL_RETRY, true);
            List failedInvocations = result.getMethod().getFailedInvocationNumbers();
            if (failedInvocations != null && !failedInvocations.isEmpty()) {
                int lastFailedIndex = failedInvocations.size() - 1;
                failedInvocations.remove(lastFailedIndex);
            }
        } else {
            ConfigurationManager.getBundle().clearProperty(RETRY_INVOCATION_COUNT);
            ConfigurationManager.getBundle().clearProperty(WILL_RETRY);
        }
        return shouldRetry;
    }

    public boolean shouldRetry(ITestResult result) {
        Throwable reason = result.getThrowable();
        int retryCount = this.getRetryCount();
        boolean shouldRetry = result.getStatus() == 2 && reason != null && !(reason instanceof AutomationError) && !(reason instanceof StepInvocationException) && !(reason instanceof AssertionError) && ApplicationProperties.RETRY_CNT.getIntVal(0) > retryCount;
        return shouldRetry;
    }

    protected int getRetryCount() {
        return ConfigurationManager.getBundle().getInt(RETRY_INVOCATION_COUNT, 0);
    }
}

