/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.tools;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.report.BDDGenerator;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.AbstractScenarioFileParser;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.text.BDDFileParser;
import com.qmetry.qaf.automation.step.client.text.BDDFileParser2;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class Bdd2Generator {
    public static void main(String[] args) {
        File file = new File(ConfigurationManager.getBundle().getString("scenario.file.loc", "scenarios"));
        if (file.isDirectory()) {
            FileUtil.getFiles(file, "feature", true).forEach(f -> Bdd2Generator.createBDD2Files(f));
            FileUtil.getFiles(file, "bdd", true).forEach(f -> Bdd2Generator.createBDD2Files(f));
        } else {
            Bdd2Generator.createBDD2Files(file);
        }
    }

    public static void createBDD2Files(File bddFile) {
        String type = FileUtil.getExtention(bddFile.getName());
        AbstractScenarioFileParser bddParser = type.equalsIgnoreCase("feature") ? new BDDFileParser2() : new BDDFileParser();
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        bddParser.parse(bddFile.getPath(), scenarios);
        HashMap<String, Object> classMetaData = new HashMap<String, Object>();
        if (scenarios.size() > 1) {
            Iterator iter = scenarios.iterator();
            classMetaData.putAll(((Scenario)iter.next()).getMetadata());
            while (iter.hasNext()) {
                classMetaData.entrySet().retainAll(((Scenario)iter.next()).getMetadata().entrySet());
            }
        }
        Object featureName = classMetaData.remove("Feature");
        ArrayList<String> statements = new ArrayList<String>();
        StringBuffer featureMetaData = new StringBuffer();
        BDDGenerator.addMetadata(featureMetaData, classMetaData, Arrays.asList("reference", "package"));
        statements.addAll(Arrays.asList(featureMetaData.toString().split("\n")));
        statements.add("Feature: " + featureName);
        if (StringUtil.isBlank((String)((String)statements.get(0)))) {
            statements.remove(0);
        }
        statements.add("");
        for (Scenario scenario : scenarios) {
            String lastStatement = (String)statements.get(statements.size() - 1);
            if (StringUtil.isNotBlank((String)lastStatement)) {
                statements.add("");
            }
            String JSON_DATA_TABLE = null;
            if (scenario.getMetadata() != null && !scenario.getMetadata().isEmpty()) {
                scenario.getMetadata().entrySet().removeAll(classMetaData.entrySet());
                scenario.getMetadata().remove("lineno");
                scenario.getMetadata().remove("reference");
                scenario.getMetadata().remove("resultFileName");
                JSON_DATA_TABLE = (String)scenario.getMetadata().remove("JSON_DATA_TABLE");
                StringBuffer scenarioMetaData = new StringBuffer();
                BDDGenerator.addMetadata(scenarioMetaData, scenario.getMetadata(), Arrays.asList("lineno", "resultFileName", "Feature"));
                statements.addAll(Arrays.asList(scenarioMetaData.toString().split("\n")));
            }
            statements.add("Scenario: " + scenario.getTestName());
            for (TestStep step : scenario.getSteps()) {
                statements.add("\t" + step.getDescription());
            }
            if (JSON_DATA_TABLE == null) continue;
            statements.addAll(Bdd2Generator.generateExamples(JSON_DATA_TABLE));
        }
        try {
            FileUtil.writeLines((File)new File(bddFile.getParentFile(), bddFile.getName().replace(".bdd", ".feature")), statements);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Collection<String> generateExamples(String JSON_DATA_TABLE) {
        Object[][] dataset;
        ArrayList<String> examples = new ArrayList<String>();
        Object[][] objectArray = dataset = JSONUtil.getJsonArrayOfMaps(JSON_DATA_TABLE);
        int n = dataset.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] record = objectArray[n2];
            Map datamap = (Map)record[0];
            if (examples.isEmpty()) {
                examples.add("Examples:");
                examples.add("\t| " + String.join((CharSequence)" |", datamap.keySet()) + " |");
            }
            examples.add("\t| " + datamap.values().stream().map(Object::toString).collect(Collectors.joining(" |")) + " |");
            ++n2;
        }
        return examples;
    }
}

