/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.tools;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.DataDrivenScenario;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.text.BDDDefinitionHelper;
import com.qmetry.qaf.automation.step.client.text.BDDFileParser2;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuntimeScenarioGenerator {
    private static final Log logger = LogFactory.getLog(RuntimeScenarioGenerator.class);

    public static void main(String[] args) {
        String source = ConfigurationManager.getBundle().getString("scenario.file.loc", "scenarios");
        RuntimeScenarioGenerator runtimeScenarioGenerator = new RuntimeScenarioGenerator();
        runtimeScenarioGenerator.generateRuntimeScenarios(source);
    }

    public void generateRuntimeScenarios(String source) {
        File file = new File(source);
        if (file.isDirectory()) {
            FileUtil.getFiles(file, "feature", true).forEach(f -> this.createTestClass((File)f));
        } else {
            this.createTestClass(file);
        }
    }

    protected void createTestClass(File bddFile) {
        BDDFileParser2 bddParser = new BDDFileParser2();
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        bddParser.parse(bddFile.getPath(), scenarios);
        String className = StringUtil.toTitleCaseIdentifier(bddFile.getName().replace(".feature", ""));
        HashMap<String, Object> classMetaData = new HashMap<String, Object>();
        if (scenarios.size() > 1) {
            Iterator iter = scenarios.iterator();
            classMetaData.putAll(((Scenario)iter.next()).getMetadata());
            while (iter.hasNext()) {
                classMetaData.entrySet().retainAll(((Scenario)iter.next()).getMetadata().entrySet());
            }
        }
        String pkg = this.generatePkgName(classMetaData, bddFile);
        String dest = "auto_generated/" + pkg.replace('.', '/');
        classMetaData.remove("reference");
        classMetaData.remove("package");
        ArrayList<String> statements = new ArrayList<String>();
        statements.add("package " + pkg + ";");
        statements.add("import static com.qmetry.qaf.automation.step.client.RuntimeScenarioFactory.scenario;");
        statements.add("import java.util.Map;");
        statements.add("import org.testng.annotations.Test;");
        statements.add("import com.qmetry.qaf.automation.step.NotYetImplementedException;");
        statements.add("import com.qmetry.qaf.automation.data.MetaData;");
        statements.add("import com.qmetry.qaf.automation.ui.WebDriverTestCase");
        statements.add("");
        statements.add("");
        if (!classMetaData.isEmpty()) {
            statements.add(String.format("@MetaData(\"%s\")", JSONUtil.toString(classMetaData).replace('\"', '\'')));
        }
        this.addClassName(className, statements);
        for (Scenario scenario : scenarios) {
            this.addScenario(scenario, statements, classMetaData, dest);
        }
        statements.add("}");
        try {
            FileUtil.checkCreateDir(dest);
            File outPutFile = new File(dest, String.valueOf(className) + ".java");
            FileUtil.writeLines((File)outPutFile, statements);
            logger.info((Object)("Generated file: " + outPutFile + " from " + bddFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String generatePkgName(Map<String, Object> classMetaData, File bddFile) {
        return (String)classMetaData.getOrDefault("package", bddFile.getParent().replace('/', '.'));
    }

    protected void addClassName(String className, List<String> statements) {
        statements.add(String.format("public class %s extends WebDriverTestCase {", className));
    }

    protected void addScenario(Scenario scenario, List<String> statements, Map<String, Object> classMetaData, String dest) {
        if (scenario.getMetadata() != null && !scenario.getMetadata().isEmpty()) {
            scenario.getMetadata().entrySet().removeAll(classMetaData.entrySet());
            scenario.getMetadata().remove("lineno");
            scenario.getMetadata().remove("reference");
            scenario.getMetadata().remove("resultFileName");
            Object JSON_DATA_TABLE = scenario.getMetadata().remove("JSON_DATA_TABLE");
            if (JSON_DATA_TABLE != null) {
                scenario.getMetadata().put("dataFile", this.generateDataFile(dest, StringUtil.toTitleCaseIdentifier(scenario.getTestName()), (String)JSON_DATA_TABLE));
            }
            statements.add(String.format("@MetaData(\"%s\")", JSONUtil.toString(scenario.getMetadata()).replace('\"', '\'')));
        }
        statements.add("@Test");
        statements.add(String.format("public void %s(%s){", scenario.getTestName().replace(' ', '_'), scenario instanceof DataDrivenScenario ? "Map<String, Object> data" : ""));
        statements.add("\tscenario().");
        for (TestStep step : scenario.getSteps()) {
            String desc = step.getDescription().replace('\"', '\'');
            String keyword = BDDDefinitionHelper.BDDKeyword.getKeywordFrom(step.getDescription());
            if (StringUtils.isBlank((String)keyword)) {
                keyword = "step";
            } else {
                desc = desc.substring(keyword.length()).trim();
            }
            statements.add(String.format("\t\t%s (\"%s\",()->{\n\t\t\tthrow new NotYetImplementedException();\n\t\t}).", keyword.toLowerCase(), desc));
        }
        statements.add("\t\texecute();");
        statements.add("\t}");
    }

    private static Collection<String> jsonArrayToCSV(String json) {
        Object[][] dataset;
        ArrayList<String> csvdata = new ArrayList<String>();
        Object[][] objectArray = dataset = JSONUtil.getJsonArrayOfMaps(json);
        int n = dataset.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] record = objectArray[n2];
            Map datamap = (Map)record[0];
            if (csvdata.isEmpty()) {
                csvdata.add(String.join((CharSequence)",", datamap.keySet()));
            }
            csvdata.add(datamap.values().stream().map(Object::toString).collect(Collectors.joining(",")));
            ++n2;
        }
        return csvdata;
    }

    protected String generateDataFile(String dest, String name, String JSON_DATA_TABLE) {
        String type = ConfigurationManager.getBundle().getString("runtimescenario.datafile.type", "json");
        switch (type.toLowerCase()) {
            case "csv": 
            case "txt": {
                File dataFile = new File(dest, String.valueOf(name) + "." + type);
                try {
                    FileUtil.writeLines((File)dataFile, RuntimeScenarioGenerator.jsonArrayToCSV(JSON_DATA_TABLE));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return dataFile.getPath();
            }
        }
        if (!type.equalsIgnoreCase("json")) {
            System.err.println("Only json or csv or txt supported for exmples to data file conversion.");
        }
        File jsonFile = new File(dest, String.valueOf(name) + ".json");
        try {
            FileUtil.write((File)jsonFile, (CharSequence)JSON_DATA_TABLE, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonFile.getPath();
    }
}

