/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.webdriver.CommandTracker;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebDriverCommandListener;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElementCommandListener;
import com.qmetry.qaf.automation.util.StackTraceUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.openqa.selenium.Capabilities;

public class WebDriverCommandLogger
implements QAFWebDriverCommandListener,
QAFWebElementCommandListener {
    private ArrayList<LoggingBean> commandLog;
    private final Log logger = LogFactory.getLog(this.getClass());
    private Set<String> excludeCommandsFromLogging;
    private static String notOpPassFormat = "Expected {0} not {op} : Actual {0} not {op}";
    private static String notOpFailFormat = "Expected {0} not {op} : Actual {0} {op}";
    private static String opPassFormat = "Expected {0} {op} : Actual {0} {op}";
    private static String opFailFormat = "Expected {0} {op} : Actual {0} not {op}";
    private static String notOpValFormat = "Expected {0} {op} should not be {1} : Actual {0} {op} is {2}";
    private static String opValFormat = "Expected {0} {op} should be {1} : Actual {0} {op} is {2}";
    private static String notOpPassFormatWindow = "Expected window not {op} : Actual window not {op}";
    private static String notOpFailFormatWindow = "Expected window not {op} : Actual window {op}";
    private static String opPassFormatWindow = "Expected window {op} : Actual window {op}";
    private static String opFailFormatWindow = "Expected window {op} : Actual window not {op}";
    private static String notOpValFormatWindow = "Expected window {op} should not be {0} : Actual window {op} is {1}";
    private static String opValFormatWindow = "Expected window {op} should be {0} : Actual window {op} is {1}";

    public WebDriverCommandLogger(ArrayList<LoggingBean> commandLog) {
        this.commandLog = commandLog;
        this.excludeCommandsFromLogging = new HashSet<String>(Arrays.asList("getHtmlSource", "captureEntirePageScreenshotToString", "executeScript", "screenshot"));
        this.excludeCommandsFromLogging.addAll(Arrays.asList(ApplicationProperties.REPORTER_LOG_EXCLUDE_CMD.getStringVal("").split(",")));
        this.excludeCommandsFromLogging = new HashSet<String>(Arrays.asList("getHtmlSource", "captureEntirePageScreenshotToString", "executeScript", "screenshot"));
        this.excludeCommandsFromLogging.addAll(Arrays.asList(ApplicationProperties.REPORTER_LOG_EXCLUDE_CMD.getStringVal("").split(",")));
    }

    public WebDriverCommandLogger() {
        this(new ArrayList<LoggingBean>());
    }

    @Override
    public void afterCommand(QAFExtendedWebDriver driver, CommandTracker commandTracker) {
        if (!StackTraceUtils.isWaitInvolved() && !this.isCommandExcludedFromLogging(commandTracker.getCommand())) {
            LoggingBean bean;
            try {
                bean = new LoggingBean(commandTracker.getCommand(), new String[]{String.format("%s", commandTracker.getParameters())}, commandTracker.getResponce() == null ? "OK" : "" + commandTracker.getResponce().getValue());
            }
            catch (Exception exception) {
                bean = new LoggingBean(commandTracker.getCommand(), new String[0], "");
            }
            WebDriverCommandLogger.logDuration(commandTracker, bean);
            this.commandLog.add(bean);
            this.logger.info((Object)bean.toString());
        }
    }

    @Override
    public void beforeCommand(QAFExtendedWebDriver driver, CommandTracker commandTracker) {
        String url;
        if (commandTracker.getCommand().equalsIgnoreCase("get") && !(url = commandTracker.getParameters().get("url").toString()).startsWith("http")) {
            String baseUrl = new WebDriverTestBase().getBaseUrl();
            if (!baseUrl.endsWith("/") && !url.startsWith("/")) {
                baseUrl = String.valueOf(baseUrl) + "/";
            } else if (url.startsWith("/")) {
                url = url.substring(1, url.length());
            }
            commandTracker.getParameters().put("url", String.valueOf(baseUrl) + url);
        }
        try {
            this.logger.info((Object)("Executing " + commandTracker.getCommand() + " parameters: " + new JSONObject(commandTracker.getParameters()).toString()));
        }
        catch (Exception exception) {
            this.logger.info((Object)("executing " + commandTracker.getCommand()));
        }
    }

    @Override
    public void onFailure(QAFExtendedWebDriver driver, CommandTracker commandTracker) {
        LoggingBean bean;
        try {
            bean = new LoggingBean(commandTracker.getCommand(), new String[]{String.format("%s", commandTracker.getParameters())}, commandTracker.getMessage());
        }
        catch (Exception exception) {
            bean = new LoggingBean(commandTracker.getCommand(), new String[0], commandTracker.getMessage());
        }
        if (!this.isCommandExcludedFromLogging(commandTracker.getCommand())) {
            WebDriverCommandLogger.logDuration(commandTracker, bean);
            this.commandLog.add(bean);
        }
        this.logger.error((Object)bean.toString());
    }

    @Override
    public void afterCommand(QAFExtendedWebElement element, CommandTracker commandTracker) {
        if (!StackTraceUtils.isWaitInvolved() && !this.isCommandExcludedFromLogging(commandTracker.getCommand())) {
            LoggingBean bean;
            try {
                bean = new LoggingBean(commandTracker.getCommand(), new String[]{element.toString(), new JSONObject(commandTracker.getParameters()).toString()}, commandTracker.getResponce() == null ? "OK" : String.valueOf(commandTracker.getCommand()) + ":" + commandTracker.getResponce().getValue());
            }
            catch (Exception exception) {
                bean = new LoggingBean(commandTracker.getCommand(), new String[0], "");
            }
            WebDriverCommandLogger.logDuration(commandTracker, bean);
            this.commandLog.add(bean);
            this.logger.info((Object)bean.toString());
        }
    }

    @Override
    public void beforeCommand(QAFExtendedWebElement element, CommandTracker commandTracker) {
        try {
            this.logger.info((Object)("Executing " + commandTracker.getCommand() + " element: " + element.toString() + " parameters: " + new JSONObject(commandTracker.getParameters()).toString()));
        }
        catch (Exception exception) {
            this.logger.info((Object)("executing " + commandTracker.getCommand()));
        }
    }

    @Override
    public void onFailure(QAFExtendedWebElement element, CommandTracker commandTracker) {
        LoggingBean bean;
        try {
            bean = new LoggingBean(commandTracker.getCommand(), new String[]{element.toString(), new JSONObject(commandTracker.getParameters()).toString()}, commandTracker.getMessage());
        }
        catch (Exception exception) {
            bean = new LoggingBean(commandTracker.getCommand(), new String[0], commandTracker.getMessage());
        }
        if (!this.isCommandExcludedFromLogging(commandTracker.getCommand())) {
            WebDriverCommandLogger.logDuration(commandTracker, bean);
            this.commandLog.add(bean);
        }
        this.logger.info((Object)bean.toString());
    }

    private static void logDuration(CommandTracker commandTracker, LoggingBean bean) {
        if (commandTracker.getEndTime() > 0L) {
            Long duration = commandTracker.getEndTime() - commandTracker.getStartTime();
            bean.setDuration(((Number)duration).intValue());
        }
    }

    public void addMessage(String msg, MessageTypes type, Object ... objects) {
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        stb.addAssertionLog(msg, type);
    }

    public static String getMsgForElementOp(String operation, boolean success, Object ... args) {
        String key = "element." + operation + "." + (success ? "pass" : "fail");
        String format = ConfigurationManager.getBundle().getString(key);
        if (format == null) {
            format = (operation.startsWith("not") ? (args != null && args.length > 2 ? notOpValFormat : (success ? notOpPassFormat : notOpFailFormat)) : (args != null && args.length > 2 ? opValFormat : (success ? opPassFormat : opFailFormat))).replace("{op}", operation.replace("not", ""));
            ConfigurationManager.getBundle().setProperty(key, format);
        }
        return MessageFormat.format(format, args);
    }

    public static String getMsgForDriverOp(String operation, boolean success, Object ... args) {
        String key = "window." + operation + "." + (success ? "pass" : "fail");
        String format = ConfigurationManager.getBundle().getString(key);
        if (format == null) {
            format = (operation.startsWith("not") ? (args != null && args.length > 2 ? notOpValFormatWindow : (success ? notOpPassFormatWindow : notOpFailFormatWindow)) : (args != null && args.length > 2 ? opValFormatWindow : (success ? opPassFormatWindow : opFailFormatWindow))).replace("{op}", operation.replace("not", ""));
            ConfigurationManager.getBundle().setProperty(key, format);
        }
        return MessageFormat.format(format, args);
    }

    @Override
    public void onInitialize(QAFExtendedWebDriver driver) {
    }

    @Override
    public void beforeInitialize(Capabilities desiredCapabilities) {
    }

    @Override
    public void onInitializationFailure(Capabilities desiredCapabilities, Throwable t) {
    }

    public List<LoggingBean> getLog() {
        return this.commandLog;
    }

    protected boolean isCommandExcludedFromLogging(String commandName) {
        return this.excludeCommandsFromLogging.contains(commandName);
    }
}

