/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium;

import com.qmetry.qaf.automation.ui.selenium.QAFCommandProcessor;
import com.qmetry.qaf.automation.ui.selenium.QAFCustomCommand;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandListener;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandTracker;
import com.qmetry.qaf.automation.ui.selenium.customcommands.GetCssPropertyCommand;
import com.qmetry.qaf.automation.ui.selenium.customcommands.SetAttributeCommand;
import com.qmetry.qaf.automation.util.StringUtil;
import com.thoughtworks.selenium.HttpCommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeleniumCommandProcessor
extends HttpCommandProcessor
implements QAFCommandProcessor {
    private transient List<SeleniumCommandListener> commandListeners = new ArrayList<SeleniumCommandListener>();
    private boolean invokingListener;
    private final Map<String, QAFCustomCommand> QAFCustomCommands = new HashMap<String, QAFCustomCommand>();

    public SeleniumCommandProcessor(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        this("http://" + serverHost + ":" + Integer.toString(serverPort) + "/selenium-server/driver/", browserStartCommand, browserURL);
    }

    public SeleniumCommandProcessor(String serverHost, String browserStartCommand, String browserURL) {
        super(serverHost, browserStartCommand, browserURL);
        this.initCustomCommands();
    }

    private void initCustomCommands() {
        this.QAFCustomCommands.put("getCssProperty", new GetCssPropertyCommand());
        this.QAFCustomCommands.put("setAttribute", new SetAttributeCommand());
    }

    public String doDefaultDoCommand(String commandName, String[] args) {
        return super.doCommand(commandName, args);
    }

    public String doCommand(String commandName, String[] args) {
        SeleniumCommandTracker commandTracker = new SeleniumCommandTracker(commandName, args);
        this.invokeBeforeCommand(commandTracker);
        if (commandTracker.getResult() == null) {
            String res = null;
            try {
                if (this.QAFCustomCommands.containsKey(commandName)) {
                    QAFCustomCommand cmd = this.QAFCustomCommands.get(commandName);
                    res = cmd.doCommand(this, commandTracker.getArgs());
                } else {
                    res = super.doCommand(commandName, commandTracker.getArgs());
                }
                commandTracker.setResult(res);
            }
            catch (SeleniumException e) {
                System.out.println("Error caught in doCommand!....." + commandName);
                commandTracker.setException((RuntimeException)((Object)e));
            }
        }
        this.invokeAfterCommand(commandTracker);
        if (commandTracker.hasException()) {
            throw commandTracker.getException();
        }
        return commandTracker.getResult();
    }

    private void invokeBeforeCommand(SeleniumCommandTracker commandTracker) {
        if (!this.invokingListener) {
            this.invokingListener = true;
            for (SeleniumCommandListener listener : this.commandListeners) {
                try {
                    listener.beforeCommand(this, commandTracker);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            this.invokingListener = false;
        }
    }

    private void invokeAfterCommand(SeleniumCommandTracker commandTracker) {
        if (!this.invokingListener) {
            this.invokingListener = true;
            for (SeleniumCommandListener listener : this.commandListeners) {
                try {
                    listener.afterCommand(this, commandTracker);
                }
                catch (SeleniumException ex) {
                    ex.printStackTrace();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            this.invokingListener = false;
        }
    }

    @Override
    public void addListener(String ... listenerClasses) {
        if (listenerClasses != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            String[] stringArray = listenerClasses;
            int n = listenerClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String listenerClass = stringArray[n2];
                try {
                    if (!StringUtil.isEmpty((String)listenerClass)) {
                        Class<?> cls = loader.loadClass(listenerClass);
                        SeleniumCommandListener listener = (SeleniumCommandListener)cls.newInstance();
                        this.commandListeners.add(listener);
                    }
                }
                catch (Throwable e) {
                    System.err.println("unable to register" + listenerClass + " as SeleniumCommandListener: " + e.getMessage());
                }
                ++n2;
            }
        }
    }

    @Override
    public void addListener(SeleniumCommandListener listener) {
        if (listener != null) {
            this.commandListeners.add(listener);
        }
    }

    public QAFCustomCommand getMethod(String methodName) {
        return this.QAFCustomCommands.get(methodName);
    }
}

