/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium.webdriver;

import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.SeleniumCommandLogger;
import com.qmetry.qaf.automation.ui.UiDriver;
import com.qmetry.qaf.automation.ui.WebDriverCommandLogger;
import com.qmetry.qaf.automation.ui.selenium.AutoWaitInjector;
import com.qmetry.qaf.automation.ui.selenium.IEScreenCaptureListener;
import com.qmetry.qaf.automation.ui.selenium.SeleniumCommandProcessor;
import com.qmetry.qaf.automation.ui.selenium.SubmitCommandListener;
import com.qmetry.qaf.automation.ui.selenium.webdriver.QAFWebDriverBackedSelenium;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SeleniumDriverFactory {
    public UiDriver getDriver(WebDriverCommandLogger cmdLogger, String[] stb) {
        String listners;
        String browser = QAFTestBase.STBArgs.browser_str.getFrom(stb);
        String baseUrl = QAFTestBase.STBArgs.base_url.getFrom(stb);
        SeleniumCommandProcessor commandProcessor = new SeleniumCommandProcessor(QAFTestBase.STBArgs.sel_server.getFrom(stb), Integer.parseInt(QAFTestBase.STBArgs.port.getFrom(stb)), browser.split("_")[0], baseUrl);
        CommandExecutor executor = this.getObject(commandProcessor);
        QAFExtendedWebDriver driver = new QAFExtendedWebDriver(executor, (Capabilities)new DesiredCapabilities(), cmdLogger);
        QAFWebDriverBackedSelenium selenium = new QAFWebDriverBackedSelenium(commandProcessor, driver);
        commandProcessor.addListener(new SubmitCommandListener());
        commandProcessor.addListener(new SeleniumCommandLogger(new ArrayList<LoggingBean>()));
        commandProcessor.addListener(new AutoWaitInjector());
        if (browser.contains("iexproper") || browser.contains("iehta")) {
            commandProcessor.addListener(new IEScreenCaptureListener());
        }
        if (!(listners = ApplicationProperties.SELENIUM_CMD_LISTENERS.getStringVal("")).equalsIgnoreCase("")) {
            commandProcessor.addListener(listners.split(","));
        }
        return selenium;
    }

    private CommandExecutor getObject(Object commandProcessor) {
        try {
            Class<?> clazz = Class.forName("org.openqa.selenium.SeleneseCommandExecutor");
            Class<?> commandProcessorclazz = Class.forName("com.thoughtworks.selenium.CommandProcessor");
            Constructor<?> ctor = clazz.getConstructor(commandProcessorclazz);
            return (CommandExecutor)ctor.newInstance(commandProcessor);
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(e.getMessage()) + "SeleneseCommandExecutor is not available. Please try with selenium 2.32 or older.");
        }
    }
}

