/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.util;

import com.qmetry.qaf.automation.ui.util.ExpectedCondition;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.List;
import org.openqa.selenium.support.Color;

public class QAFWebElementExpectedConditions {
    private QAFWebElementExpectedConditions() {
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementVisible() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (element.isPresent() && element.isDisplayed()) {
                    return true;
                }
                return false;
            }
        };
    }

    public static ExpectedCondition<List<QAFWebElement>, Boolean> anyElementVisible() {
        return new ExpectedCondition<List<QAFWebElement>, Boolean>(){
            String msg = "any of elements to be visible";

            public Boolean apply(List<QAFWebElement> elements) {
                this.msg = "any of elements to be visible";
                for (QAFWebElement element : elements) {
                    if (element.isPresent() && element.isDisplayed()) {
                        return true;
                    }
                    this.msg = String.valueOf(this.msg) + " " + ((QAFExtendedWebElement)element).getDescription(new String[0]);
                }
                return false;
            }

            public String toString() {
                return this.msg;
            }
        };
    }

    public static ExpectedCondition<List<QAFWebElement>, Boolean> allElementVisible() {
        return new ExpectedCondition<List<QAFWebElement>, Boolean>(){
            String msg = "elements to be visible";

            public Boolean apply(List<QAFWebElement> elements) {
                for (QAFWebElement element : elements) {
                    if (element.isPresent() && element.isDisplayed()) continue;
                    this.msg = "elements to be visible " + ((QAFExtendedWebElement)element).getDescription(new String[0]);
                    return false;
                }
                return true;
            }

            public String toString() {
                return this.msg;
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementPresent() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return element.isPresent();
            }
        };
    }

    public static ExpectedCondition<List<QAFWebElement>, Boolean> anyElementPresent() {
        return new ExpectedCondition<List<QAFWebElement>, Boolean>(){
            String msg = "any of elements to be present";

            public Boolean apply(List<QAFWebElement> elements) {
                this.msg = "any of elements to be present";
                for (QAFWebElement element : elements) {
                    if (element.isPresent()) {
                        return true;
                    }
                    this.msg = " " + ((QAFExtendedWebElement)element).getDescription(new String[0]);
                }
                return false;
            }

            public String toString() {
                return this.msg;
            }
        };
    }

    public static ExpectedCondition<List<QAFWebElement>, Boolean> allElementPresent() {
        return new ExpectedCondition<List<QAFWebElement>, Boolean>(){
            String msg = "all of elements to be present";

            public Boolean apply(List<QAFWebElement> elements) {
                for (QAFWebElement element : elements) {
                    if (element.isPresent()) continue;
                    this.msg = "elements to be present " + ((QAFExtendedWebElement)element).getDescription(new String[0]);
                    return false;
                }
                return true;
            }

            public String toString() {
                return this.msg;
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementNotPresent() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return !element.isPresent();
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementNotVisible() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (element.isPresent() && element.isDisplayed()) {
                    return false;
                }
                return true;
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementEnabled() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return element.isEnabled();
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementDisabled() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return !element.isEnabled();
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementAttributeValueEq(final String attributeName, final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (val instanceof StringMatcher) {
                    return ((StringMatcher)val).match(element.getAttribute(attributeName));
                }
                return StringUtil.seleniumEquals(element.getAttribute(attributeName), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementAttributeValueNotEq(final String attributeName, final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (val instanceof StringMatcher) {
                    return !((StringMatcher)val).match(element.getAttribute(attributeName));
                }
                return !StringUtil.seleniumEquals(element.getAttribute(attributeName), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementCssPropertyValueEq(final String propertyName, final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return StringUtil.seleniumEquals(element.getCssValue(propertyName), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementCssPropertyValueNotEq(final String propertyName, final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return !StringUtil.seleniumEquals(element.getCssValue(propertyName), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementCssColorPropertyValueEq(final String propertyName, final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return Color.fromString((String)element.getCssValue(propertyName)).asRgba().equals(Color.fromString((String)String.valueOf(val)).asRgba());
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementCssColorPropertyValueNotEq(final String propertyName, final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return !Color.fromString((String)element.getCssValue(propertyName)).asRgba().equals(Color.fromString((String)String.valueOf(val)).asRgba());
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementTextEq(final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (val instanceof StringMatcher) {
                    return ((StringMatcher)val).match(element.getText());
                }
                return StringUtil.seleniumEquals(element.getText(), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementTextNotEq(final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (val instanceof StringMatcher) {
                    return !((StringMatcher)val).match(element.getText());
                }
                return !StringUtil.seleniumEquals(element.getText(), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementValueEq(final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (val instanceof StringMatcher) {
                    return ((StringMatcher)val).match(element.getAttribute("value"));
                }
                return StringUtil.seleniumEquals(element.getAttribute("value"), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementValueNotEq(final Object val) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                if (val instanceof StringMatcher) {
                    return !((StringMatcher)val).match(element.getAttribute("value"));
                }
                return !StringUtil.seleniumEquals(element.getAttribute("value"), String.valueOf(val));
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementSelected() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return element.isSelected();
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementNotSelected() {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return !element.isSelected();
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementHasCssClass(final String className) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return element.getAttribute("class").contains(className);
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebElement, Boolean> elementHasNotCssClass(final String className) {
        return new ExpectedCondition<QAFExtendedWebElement, Boolean>(){

            public Boolean apply(QAFExtendedWebElement element) {
                return !element.getAttribute("class").contains(className);
            }
        };
    }
}

