/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ui.webdriver.CommandTracker;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElementCommandAdapter;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;

public class ElementMetaDataListener
extends QAFWebElementCommandAdapter {
    public static final String SCROLL = "scroll";
    public static final String SCROLL_OPTIONS = "scroll-options";
    public static final String SENDKEYS_OPTIONS = "sendkeys-options";
    public static final String TYPE = "type";
    public static final List<String> COMMANDS_REQUIRES_SCROLL = Arrays.asList("clickElement", "sendKeysToElement", "elementScreenshot");

    @Override
    public void beforeCommand(QAFExtendedWebElement element, CommandTracker commandTracker) {
        boolean isScrollRequired;
        boolean bl = isScrollRequired = this.getScrollBehavoir(element).startsWith("A") || this.getScrollBehavoir(element).startsWith("T");
        if (isScrollRequired && COMMANDS_REQUIRES_SCROLL.contains(commandTracker.getCommand())) {
            this.scrollToElement(element);
        }
        this.processSendKeys(element, commandTracker);
    }

    private void processSendKeys(QAFExtendedWebElement element, CommandTracker commandTracker) {
        if ("sendKeysToElement".equalsIgnoreCase(commandTracker.getCommand())) {
            CharSequence[] values = (CharSequence[])commandTracker.getParameters().get("value");
            String sendkeysOpts = this.getSendkeysOptions(element);
            if (sendkeysOpts.indexOf("CLICK") >= 0) {
                element.click();
            }
            if (sendkeysOpts.indexOf("CLEAR") >= 0) {
                element.clear();
                if (values[0] == null || values[0].length() == 0) {
                    commandTracker.setResponce(new Response());
                    return;
                }
            }
            if (this.isEncrypted(element)) {
                String encriptedPassword = values[0].toString();
                values[0] = ConfigurationManager.getBundle().getPasswordDecryptor().getDecryptedPassword(encriptedPassword);
                Response response = element.executeWitoutLog(commandTracker.getCommand(), commandTracker.getParameters());
                commandTracker.setResponce(response);
                values[0] = encriptedPassword;
            } else if (this.isSelect(element)) {
                String locateOptionBy = "byText";
                List<WebElement> options = element.findElements(By.tagName((String)"option"));
                CharSequence[] charSequenceArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    CharSequence value = charSequenceArray[n2];
                    String str = value.toString();
                    if (str.equalsIgnoreCase("byValue") || str.equalsIgnoreCase("byText") || str.equalsIgnoreCase("byIndex")) {
                        locateOptionBy = str;
                    } else {
                        int i = 0;
                        while (i < options.size()) {
                            WebElement option = options.get(i);
                            if (locateOptionBy.equalsIgnoreCase("byIndex") && String.valueOf(i).equalsIgnoreCase(value.toString())) {
                                element.executeScript("selectedIndex=" + i);
                            } else if (locateOptionBy.equalsIgnoreCase("byValue") && String.valueOf(str).equalsIgnoreCase(option.getAttribute("value"))) {
                                element.executeScript("selectedIndex=" + i);
                            } else if (locateOptionBy.equalsIgnoreCase("byValue") && String.valueOf(str).equalsIgnoreCase(option.getText())) {
                                element.executeScript("selectedIndex=" + i);
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
                commandTracker.setResponce(new Response());
            }
        }
    }

    @Override
    public void onFailure(QAFExtendedWebElement element, CommandTracker commandTracker) {
        boolean isScrollRequired = this.getScrollBehavoir(element).startsWith("O");
        if (isScrollRequired && COMMANDS_REQUIRES_SCROLL.contains(commandTracker.getCommand()) && element.isPresent()) {
            this.scrollToElement(element);
            commandTracker.setRetry(true);
        }
    }

    private void scrollToElement(QAFExtendedWebElement element) {
        element.executeScript("scrollIntoView(" + this.getScrollOptions(element) + ");");
    }

    private String getScrollBehavoir(QAFExtendedWebElement element) {
        return element.getMetaData().containsKey(SCROLL) ? element.getMetaData().get(SCROLL).toString().toUpperCase() : "";
    }

    private String getScrollOptions(QAFExtendedWebElement element) {
        return element.getMetaData().containsKey(SCROLL_OPTIONS) ? element.getMetaData().get(SCROLL_OPTIONS).toString() : "";
    }

    private String getSendkeysOptions(QAFExtendedWebElement element) {
        return element.getMetaData().containsKey(SENDKEYS_OPTIONS) ? element.getMetaData().get(SENDKEYS_OPTIONS).toString().toUpperCase() : "";
    }

    private boolean isEncrypted(QAFExtendedWebElement element) {
        return element.getMetaData().containsKey(TYPE) && (element.getMetaData().get(TYPE).toString().toUpperCase().startsWith("P") || element.getMetaData().get(TYPE).toString().toUpperCase().startsWith("E"));
    }

    private boolean isSelect(QAFExtendedWebElement element) {
        return element.getMetaData().containsKey(TYPE) && element.getMetaData().get(TYPE).toString().toUpperCase().startsWith("S");
    }
}

