/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.google.common.collect.ImmutableMap;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFListener;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.JsToolkit;
import com.qmetry.qaf.automation.ui.WebDriverCommandLogger;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.util.DynamicWait;
import com.qmetry.qaf.automation.ui.util.QAFWebDriverExpectedConditions;
import com.qmetry.qaf.automation.ui.util.QAFWebDriverWait;
import com.qmetry.qaf.automation.ui.util.QAFWebElementExpectedConditions;
import com.qmetry.qaf.automation.ui.webdriver.CommandTracker;
import com.qmetry.qaf.automation.ui.webdriver.ElementFactory;
import com.qmetry.qaf.automation.ui.webdriver.QAFElementConverter;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElementListHandler;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebDriverCommandListener;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.util.LocatorUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ScreenshotException;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class QAFExtendedWebDriver
extends RemoteWebDriver
implements QAFWebDriver,
QAFWebDriverCommandListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private WebDriverCommandLogger commandLogger;
    private Set<QAFWebDriverCommandListener> listners;
    private WebDriver underLayingDriver;
    private Capabilities capabilities;
    private QAFElementConverter qafElementConverter;

    public QAFExtendedWebDriver(URL url, Capabilities capabilities) {
        this(url, capabilities, null);
    }

    public QAFExtendedWebDriver(WebDriver driver) {
        this(driver, null);
    }

    public QAFExtendedWebDriver(URL url, Capabilities capabilities, WebDriverCommandLogger reporter) {
        super(url, capabilities);
        this.init(reporter);
    }

    public QAFExtendedWebDriver(CommandExecutor cmdExecutor, Capabilities capabilities, WebDriverCommandLogger reporter) {
        super(cmdExecutor, capabilities);
        this.init(reporter);
    }

    public QAFExtendedWebDriver() {
        this.init(null);
    }

    public QAFExtendedWebDriver(WebDriver driver, WebDriverCommandLogger reporter) {
        this.underLayingDriver = driver;
        this.setCommandExecutor(((RemoteWebDriver)driver).getCommandExecutor());
        this.setSessionId(((RemoteWebDriver)driver).getSessionId().toString());
        this.capabilities = ((RemoteWebDriver)driver).getCapabilities();
        this.init(reporter);
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = super.getCapabilities();
        }
        return this.capabilities;
    }

    public WebDriver getUnderLayingDriver() {
        if (this.underLayingDriver == null) {
            this.underLayingDriver = this;
        }
        return this.underLayingDriver;
    }

    private void init(WebDriverCommandLogger reporter) {
        this.qafElementConverter = new QAFElementConverter(this);
        try {
            String[] listners;
            this.listners = new LinkedHashSet<QAFWebDriverCommandListener>();
            this.commandLogger = reporter == null ? new WebDriverCommandLogger() : reporter;
            this.listners.add(this.commandLogger);
            String[] stringArray = listners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.WEBDRIVER_COMMAND_LISTENERS.key);
            int n = listners.length;
            int n2 = 0;
            while (n2 < n) {
                String listenr = stringArray[n2];
                this.registerListeners(listenr);
                ++n2;
            }
            stringArray = listners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.QAF_LISTENERS.key);
            n = listners.length;
            n2 = 0;
            while (n2 < n) {
                String listener = stringArray[n2];
                try {
                    QAFListener cls = (QAFListener)Class.forName(listener).newInstance();
                    if (QAFWebDriverCommandListener.class.isAssignableFrom(cls.getClass())) {
                        this.listners.add((QAFWebDriverCommandListener)cls);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Unable to register class as driver listener:  " + listener), (Throwable)e);
                }
                ++n2;
            }
            this.onInitialize(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected WebDriverCommandLogger getReporter() {
        return this.commandLogger;
    }

    public void setReporter(WebDriverCommandLogger reporter) {
        this.commandLogger = reporter;
    }

    @Override
    public QAFExtendedWebElement findElement(By by) {
        QAFExtendedWebElement element = (QAFExtendedWebElement)super.findElement(by);
        element.setBy(by);
        element.cacheable = true;
        return element;
    }

    @Override
    public QAFWebElement findElement(String locator) {
        return ElementFactory.$(locator);
    }

    @Override
    public List<QAFWebElement> findElements(String loc) {
        return this.findElements(LocatorUtil.getBy(loc));
    }

    public QAFExtendedWebElement createElement(By by) {
        return new QAFExtendedWebElement(this, by);
    }

    public QAFExtendedWebElement createElement(String locator) {
        return new QAFExtendedWebElement(locator);
    }

    @Override
    public List<QAFWebElement> getElements(By by) {
        List proxy = (List)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{List.class}, (InvocationHandler)new QAFExtendedWebElementListHandler((SearchContext)this, by));
        return proxy;
    }

    public void load(QAFExtendedWebElement ... elements) {
        if (elements != null) {
            QAFExtendedWebElement[] qAFExtendedWebElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                QAFExtendedWebElement element = qAFExtendedWebElementArray[n2];
                By by = element.getBy();
                element.setId(((QAFExtendedWebElement)new QAFWebDriverWait(this, new long[0]).ignoring(NoSuchElementException.class, StaleElementReferenceException.class, RuntimeException.class).until(ExpectedConditions.presenceOfElementLocated((By)by))).getId());
                ++n2;
            }
        }
    }

    protected Response execute(CommandPayload payload) {
        return this.execute(payload.getName(), payload.getParameters());
    }

    private Response executeSuper(CommandPayload payload) {
        try {
            MethodHandle h1 = MethodHandles.lookup().findSpecial(this.getClass().getSuperclass(), "execute", MethodType.methodType(Response.class, CommandPayload.class), this.getClass());
            return h1.invoke(this, payload);
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
            return super.execute(payload.getName(), payload.getParameters());
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private Response executeWithoutLog(CommandPayload payload) {
        Response response = this.executeSuper(payload);
        if (response == null) {
            return null;
        }
        Object value = this.getQafElementConverter().apply(response.getValue());
        response.setValue(value);
        return response;
    }

    private QAFElementConverter getQafElementConverter() {
        if (this.qafElementConverter == null) {
            this.qafElementConverter = new QAFElementConverter(this);
        }
        return this.qafElementConverter;
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        CommandTracker commandTracker = new CommandTracker(driverCommand, parameters);
        try {
            this.beforeCommand(this, commandTracker);
            if (commandTracker.getResponce() == null) {
                commandTracker.setStartTime(System.currentTimeMillis());
                commandTracker.setResponce(this.executeWitoutLog(commandTracker.getCommand(), commandTracker.getParameters()));
                commandTracker.setEndTime(System.currentTimeMillis());
            }
            this.afterCommand(this, commandTracker);
        }
        catch (RuntimeException wde) {
            commandTracker.setException(wde);
            this.onFailure(this, commandTracker);
        }
        if (commandTracker.hasException()) {
            if (commandTracker.retry) {
                commandTracker.setResponce(this.executeWitoutLog(commandTracker.getCommand(), commandTracker.getParameters()));
                commandTracker.setException(null);
                commandTracker.setEndTime(System.currentTimeMillis());
            } else {
                throw commandTracker.getException();
            }
        }
        return commandTracker.getResponce();
    }

    protected Response executeWitoutLog(String driverCommand, Map<String, ?> parameters) {
        return this.executeWithoutLog(new CommandPayload(driverCommand, parameters));
    }

    public <T> T extractScreenShot(WebDriverException e, OutputType<T> target) {
        if (e.getCause() instanceof ScreenshotException) {
            String base64Str = ((ScreenshotException)e.getCause()).getBase64EncodedScreenshot();
            return (T)target.convertFromBase64Png(base64Str);
        }
        return null;
    }

    public Alert getAlert() {
        return new QAFWebDriverWait(this, new long[0]).until(QAFWebDriverExpectedConditions.alertPresent());
    }

    @Override
    public void afterCommand(QAFExtendedWebDriver driver, CommandTracker commandTracker) {
        commandTracker.setStage(CommandTracker.Stage.executingAfterMethod);
        if (this.listners != null && !this.listners.isEmpty()) {
            for (QAFWebDriverCommandListener listener : this.listners) {
                listener.afterCommand(driver, commandTracker);
            }
        }
    }

    public void updateSessionId() {
        String sessionId = new WebDriverTestBase().getDriver().getSessionId().toString();
        this.setSessionId(sessionId);
        System.out.println("Current session: " + this.getSessionId() + " updated with:" + sessionId);
    }

    @Override
    public void beforeCommand(QAFExtendedWebDriver driver, CommandTracker commandTracker) {
        commandTracker.setStage(CommandTracker.Stage.executingBeforeMethod);
        if (this.listners != null && !this.listners.isEmpty()) {
            for (QAFWebDriverCommandListener listener : this.listners) {
                listener.beforeCommand(driver, commandTracker);
            }
        }
    }

    @Override
    public void onFailure(QAFExtendedWebDriver driver, CommandTracker commandTracker) {
        commandTracker.setStage(CommandTracker.Stage.executingOnFailure);
        commandTracker.setEndTime(System.currentTimeMillis());
        if (commandTracker.getException() instanceof UnsupportedOperationException) {
            this.logger.warn((Object)commandTracker.getException().getMessage());
            commandTracker.setException(null);
        }
        if (this.listners != null) {
            for (QAFWebDriverCommandListener listener : this.listners) {
                listener.onFailure(driver, commandTracker);
            }
        }
    }

    @Override
    public void onInitialize(QAFExtendedWebDriver driver) {
        if (this.listners != null && !this.listners.isEmpty()) {
            for (QAFWebDriverCommandListener listener : this.listners) {
                listener.onInitialize(driver);
            }
        }
    }

    @Override
    public void onInitializationFailure(Capabilities desiredCapabilities, Throwable t) {
    }

    private void registerListeners(String className) {
        try {
            QAFWebDriverCommandListener cls = (QAFWebDriverCommandListener)Class.forName(className).newInstance();
            this.listners.add(cls);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to register listener class " + className), (Throwable)e);
        }
    }

    public void registerListeners(QAFWebDriverCommandListener listener) {
        this.listners.add(listener);
    }

    public QAFExtendedWebElement findElementBySizzleCss(String using) {
        List<QAFExtendedWebElement> elements = this.findElementsBySizzleCss(using);
        if (elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    public List<QAFExtendedWebElement> findElementsBySizzleCss(String using) {
        this.injectSizzleIfNeeded();
        String javascriptExpression = this.createSizzleSelectorExpression(using);
        return (List)this.executeScript(javascriptExpression, new Object[0]);
    }

    private String createSizzleSelectorExpression(String using) {
        return "return Sizzle(\"" + using + "\")";
    }

    private void injectSizzleIfNeeded() {
        if (!this.sizzleLoaded().booleanValue()) {
            this.injectSizzle();
        }
    }

    private Boolean sizzleLoaded() {
        Boolean loaded;
        try {
            loaded = (Boolean)this.executeScript("return Sizzle()!=null", new Object[0]);
        }
        catch (WebDriverException webDriverException) {
            loaded = false;
        }
        return loaded;
    }

    private void injectSizzle() {
        this.executeScript(" var headID = document.getElementsByTagName(\"head\")[0];var newScript = document.createElement('script');newScript.type = 'text/javascript';newScript.src = 'https://raw.github.com/jquery/sizzle/master/sizzle.js';headID.appendChild(newScript);", new Object[0]);
    }

    @Override
    public String takeScreenShot() {
        return (String)this.getScreenshotAs(OutputType.BASE64);
    }

    @Override
    public void waitForAjax(JsToolkit toolkit, long ... timeout) {
        new QAFWebDriverWait(this, timeout).withMessage("AJAX load Wait time out.").until(QAFWebDriverExpectedConditions.jsCondition(toolkit.waitCondition()));
    }

    @Override
    public void waitForAjax(long ... timeout) {
        new QAFWebDriverWait(this, timeout).withMessage("AJAX load Wait time out.").until(QAFWebDriverExpectedConditions.jsCondition(JsToolkit.globalWaitCondition()));
    }

    @Override
    public void waitForAnyElementPresent(QAFWebElement ... elements) {
        new DynamicWait<List<QAFWebElement>>(Arrays.asList(elements)).until(QAFWebElementExpectedConditions.anyElementPresent());
    }

    @Override
    public void waitForAllElementPresent(QAFWebElement ... elements) {
        new DynamicWait<List<QAFWebElement>>(Arrays.asList(elements)).until(QAFWebElementExpectedConditions.allElementPresent());
    }

    @Override
    public void waitForAnyElementVisible(QAFWebElement ... elements) {
        new DynamicWait<List<QAFWebElement>>(Arrays.asList(elements)).until(QAFWebElementExpectedConditions.anyElementVisible());
    }

    @Override
    public void waitForAllElementVisible(QAFWebElement ... elements) {
        new DynamicWait<List<QAFWebElement>>(Arrays.asList(elements)).until(QAFWebElementExpectedConditions.allElementVisible());
    }

    @Override
    public void waitForWindowTitle(StringMatcher titlematcher, long ... timeout) {
        new QAFWebDriverWait(this, timeout).withMessage("Timed out waiting for window title " + titlematcher.toString()).until(QAFWebDriverExpectedConditions.windowTitle(titlematcher));
    }

    @Override
    public void waitForCurrentUrl(StringMatcher matcher, long ... timeout) {
        new QAFWebDriverWait(this, timeout).withMessage("Timed out waiting for url " + matcher.toString() + " timed out").until(QAFWebDriverExpectedConditions.currentURL(matcher));
    }

    @Override
    public void waitForNoOfWindows(int count, long ... timeout) {
        new QAFWebDriverWait(this, timeout).withMessage("Timed out waiting for no of windows " + count).until(QAFWebDriverExpectedConditions.noOfwindowsPresent(count));
    }

    @Override
    public boolean verifyTitle(StringMatcher text, long ... timeout) {
        boolean outcome = true;
        try {
            this.waitForWindowTitle(text, timeout);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("title", outcome, text, this.getTitle());
        return outcome;
    }

    @Override
    public boolean verifyCurrentUrl(StringMatcher text, long ... timeout) {
        boolean outcome = true;
        try {
            this.waitForCurrentUrl(text, timeout);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("currentUrl", outcome, text, this.getCurrentUrl());
        return outcome;
    }

    @Override
    public boolean verifyNoOfWindows(int count, long ... timeout) {
        boolean outcome = true;
        try {
            this.waitForNoOfWindows(count, timeout);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("NoOfWindows", outcome, count, this.getWindowHandles().size());
        return outcome;
    }

    @Override
    public void assertTitle(StringMatcher text, long ... timeout) {
        if (!this.verifyTitle(text, timeout)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertCurrentUrl(StringMatcher text, long ... timeout) {
        if (!this.verifyCurrentUrl(text, timeout)) {
            throw new AssertionError();
        }
    }

    public void assertNoOfWindows(int count, long ... timeout) {
        if (!this.verifyNoOfWindows(count, timeout)) {
            throw new AssertionError();
        }
    }

    protected void report(String op, boolean outcome, Object ... args) {
        this.getReporter().addMessage(WebDriverCommandLogger.getMsgForDriverOp(op, outcome, args), outcome ? MessageTypes.Pass : MessageTypes.Fail, new Object[0]);
    }

    @Override
    public void beforeInitialize(Capabilities desiredCapabilities) {
    }

    public <T> T getCapabilityImpl() {
        WebDriver augmentedDriver = new Augmenter().augment((WebDriver)this);
        return (T)augmentedDriver;
    }

    @Override
    public QAFExtendedWebElement findElementByCustomStretegy(String stetegy, String loc) {
        return (QAFExtendedWebElement)this.execute("findElement", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)stetegy, (Object)"value", (Object)loc)).getValue();
    }

    @Override
    public List<WebElement> findElementsByCustomStretegy(String stetegy, String loc) {
        return (List)this.execute("findElements", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)stetegy, (Object)"value", (Object)loc)).getValue();
    }

    @Override
    public void stop() {
        this.quit();
    }
}

