/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.google.common.collect.ImmutableMap;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFListener;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.WebDriverCommandLogger;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.util.QAFWebElementExpectedConditions;
import com.qmetry.qaf.automation.ui.util.QAFWebElementWait;
import com.qmetry.qaf.automation.ui.webdriver.CommandTracker;
import com.qmetry.qaf.automation.ui.webdriver.ComponentFactory;
import com.qmetry.qaf.automation.ui.webdriver.ElementMetaDataListener;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElementCommandListener;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.LocatorUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.testng.SkipException;

public class QAFExtendedWebElement
extends RemoteWebElement
implements QAFWebElementCommandListener,
QAFWebElement {
    private static final Map<String, Object> GLOBAL_METADATA = JSONUtil.toMap(ApplicationProperties.ELEMENT_GLOBAL_METADATA.getStringVal("{'scroll':'OnFail'}"));
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected transient By by;
    protected QAFExtendedWebElement parentElement;
    protected String locator;
    private Map<String, Object> metaData;
    protected boolean cacheable = false;
    private Set<QAFWebElementCommandListener> listners = new LinkedHashSet<QAFWebElementCommandListener>();
    private String description;

    protected QAFExtendedWebElement(QAFExtendedWebDriver driver) {
        String[] listners;
        this.setParent(driver);
        this.id = "-1";
        this.metaData = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.metaData.putAll(GLOBAL_METADATA);
        this.cacheable = this.metaData.containsKey("cacheable") ? (Boolean)this.metaData.get("cacheable") : true;
        this.listners.add(driver.getReporter());
        if (ApplicationProperties.ELEMENT_ATTACH_DEFAULT_LISTENER.getBoolenVal(true)) {
            this.listners.add(new ElementMetaDataListener());
        }
        try {
            this.setFileDetector(this.parent.getFileDetector());
        }
        catch (Exception e) {
            this.logger.debug((Object)"FileDetector not found!", (Throwable)e);
        }
        String[] stringArray = listners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.WEBELEMENT_COMMAND_LISTENERS.key);
        int n = listners.length;
        int n2 = 0;
        while (n2 < n) {
            String listenr = stringArray[n2];
            this.registerListeners(listenr);
            ++n2;
        }
        stringArray = listners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.QAF_LISTENERS.key);
        n = listners.length;
        n2 = 0;
        while (n2 < n) {
            String listener = stringArray[n2];
            try {
                QAFListener cls = (QAFListener)Class.forName(listener).newInstance();
                if (QAFWebElementCommandListener.class.isAssignableFrom(cls.getClass())) {
                    this.listners.add((QAFWebElementCommandListener)cls);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Unable to register class as element listener:  " + listener), (Throwable)e);
            }
            ++n2;
        }
    }

    public QAFExtendedWebElement(By by) {
        this(new WebDriverTestBase().getDriver(), by);
    }

    public QAFExtendedWebElement(String locator) {
        this((By)null);
        this.initLoc(locator);
    }

    public QAFExtendedWebElement(QAFExtendedWebElement parentElement, String locator) {
        this(parentElement, (By)null);
        this.initLoc(locator);
    }

    public QAFExtendedWebElement(QAFExtendedWebDriver driver, By by) {
        this(driver, by, false);
    }

    public QAFExtendedWebElement(QAFExtendedWebDriver driver, By by, boolean cacheable) {
        this(driver);
        this.by = by;
        this.cacheable = cacheable;
    }

    public QAFExtendedWebElement(QAFExtendedWebElement parentElement, By by) {
        this(parentElement.getWrappedDriver(), by, parentElement.cacheable);
        this.parentElement = parentElement;
    }

    public void setBy(By by) {
        this.by = by;
    }

    public By getBy() {
        if (this.by == null && StringUtil.isNotBlank((String)this.locator)) {
            this.by = LocatorUtil.getBy(this.locator);
        }
        return this.by;
    }

    public String getDescription(String ... label) {
        return label != null && label.length > 0 ? label[0] : (StringUtil.isBlank((String)this.description) ? this.toString() : this.description);
    }

    public void setDescription(String description) {
        if (JSONUtil.isValidJsonString(description)) {
            try {
                Map<String, Object> map = JSONUtil.toMap(description);
                this.description = map.containsKey("desc") ? (String)map.get("desc") : (map.containsKey("description") ? (String)map.get("description") : "");
            }
            catch (JSONException e) {
                this.logger.error((Object)e.getMessage());
            }
        } else {
            this.description = description;
        }
    }

    protected void initLoc(String locator) {
        this.locator = ConfigurationManager.getBundle().getString(locator, locator);
        this.locator = ConfigurationManager.getBundle().getSubstitutor().replace(this.locator);
        if (JSONUtil.isValidJsonString(this.locator)) {
            try {
                this.metaData.putAll(JSONUtil.toMap(this.locator));
                this.description = this.metaData.containsKey("desc") ? (String)this.metaData.get("desc") : (this.metaData.containsKey("description") ? (String)this.metaData.get("description") : "");
                boolean bl = this.cacheable = this.metaData.containsKey("cacheable") ? (Boolean)this.metaData.get("cacheable") : false;
                if (this.metaData.containsKey("child") && !((Boolean)this.metaData.get("child")).booleanValue()) {
                    this.parentElement = null;
                }
            }
            catch (JSONException e) {
                this.logger.error((Object)e.getMessage());
            }
        }
    }

    public void sendKeys(CharSequence ... keysToSend) {
        super.sendKeys(keysToSend);
    }

    protected Response execute(CommandPayload payload) {
        return this.execute(payload.getName(), payload.getParameters());
    }

    protected Response execute(String command, Map<String, ?> parameters) {
        CommandTracker commandTracker = new CommandTracker(command, parameters);
        try {
            this.load();
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.putAll(parameters);
            m.put("id", this.id);
            commandTracker.setParameters(m);
            this.beforeCommand(this, commandTracker);
            if (commandTracker.getResponce() == null) {
                commandTracker.setStartTime(System.currentTimeMillis());
                commandTracker.setResponce(((QAFExtendedWebDriver)this.parent).executeWitoutLog(commandTracker.getCommand(), commandTracker.getParameters()));
                commandTracker.setEndTime(System.currentTimeMillis());
            }
            this.afterCommand(this, commandTracker);
            if (this.getBy() != null && !this.cacheable) {
                this.id = "-1";
            }
        }
        catch (RuntimeException e) {
            commandTracker.setException(e);
            this.onFailure(this, commandTracker);
        }
        if (commandTracker.hasException()) {
            if (commandTracker.retry) {
                commandTracker.setResponce(((QAFExtendedWebDriver)this.parent).executeWitoutLog(commandTracker.getCommand(), commandTracker.getParameters()));
                commandTracker.setException(null);
                commandTracker.setEndTime(System.currentTimeMillis());
            } else {
                throw commandTracker.getException();
            }
        }
        return commandTracker.getResponce();
    }

    protected Response executeWitoutLog(String command, Map<String, ?> parameters) {
        return ((QAFExtendedWebDriver)this.parent).executeWitoutLog(command, parameters);
    }

    public void setId(String id) {
        super.setId(id);
    }

    protected void load() {
        if (this.id == null || this.id == "-1") {
            HashMap parameters = new HashMap();
            CommandTracker commandTracker = new CommandTracker("findElement", parameters);
            if (this.parentElement == null) {
                this.beforeCommand(this, commandTracker);
                ((QAFExtendedWebDriver)this.parent).load(this);
                this.afterCommand(this, commandTracker);
            } else {
                this.parentElement.load();
                this.beforeCommand(this, commandTracker);
                this.setId(this.parentElement.findElement((By)this.getBy()).id);
                this.afterCommand(this, commandTracker);
            }
        }
    }

    public String getId() {
        if (this.id == null || this.id == "-1") {
            this.load();
        }
        return this.id;
    }

    public Point getLocation() {
        this.id = this.getId();
        return super.getLocation();
    }

    public String getCssValue(String propertyName) {
        Response response = this.execute("getElementValueOfCssProperty", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"propertyName", (Object)propertyName));
        return (String)response.getValue();
    }

    public boolean isDisplayed() {
        this.id = this.getId();
        return super.isDisplayed();
    }

    public Dimension getSize() {
        this.id = this.getId();
        return super.getSize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPresent() {
        if (this.cacheable && StringUtil.isNotBlank((String)this.id) && this.id != "-1") {
            return true;
        }
        try {
            QAFExtendedWebElement ele = null;
            if (this.parentElement != null) {
                if (!this.parentElement.isPresent()) {
                    return false;
                }
                ele = this.parentElement.findElement(this.getBy());
            } else {
                ele = this.getWrappedDriver().findElement(this.getBy());
            }
            if (ele == null) {
                return false;
            }
            if (StringUtil.isBlank((String)this.id)) {
                this.id = ele.getId();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getBy() == null ? (this.id != "-1" ? "id: " + this.id : "New WebElement") : this.getBy().toString();
    }

    public WebDriverCommandLogger getReporter() {
        return this.getWrappedDriver().getReporter();
    }

    public QAFExtendedWebDriver getWrappedDriver() {
        return (QAFExtendedWebDriver)this.parent;
    }

    public QAFExtendedWebElement findElement(By by) {
        this.load();
        QAFExtendedWebElement ele = (QAFExtendedWebElement)super.findElement(by);
        ele.parentElement = this;
        return ele;
    }

    @Override
    public QAFExtendedWebElement findElement(String loc) {
        QAFExtendedWebElement ele = this.findElement(LocatorUtil.getBy(loc));
        ele.initLoc(loc);
        return ele;
    }

    public List<WebElement> findElements(By by) {
        try {
            return super.findElements(by);
        }
        catch (Exception exception) {
            return new ArrayList<WebElement>();
        }
    }

    @Override
    public List<QAFWebElement> findElements(String loc) {
        return this.findElements(LocatorUtil.getBy(loc));
    }

    public <T extends QAFExtendedWebElement> List<T> findElements(String loc, Class<T> t) {
        List<QAFWebElement> eles = this.findElements(loc);
        ArrayList<QAFExtendedWebElement> objs = new ArrayList<QAFExtendedWebElement>();
        for (QAFWebElement ele : eles) {
            QAFExtendedWebElement obj = (QAFExtendedWebElement)ComponentFactory.getObject(t, loc, this, (SearchContext)this);
            obj.setId(((QAFExtendedWebElement)ele).getId());
            obj.parentElement = this;
            obj.cacheable = true;
            objs.add(obj);
        }
        return objs;
    }

    public <T extends QAFExtendedWebElement> T findElement(String loc, Class<T> t) {
        QAFExtendedWebElement obj = (QAFExtendedWebElement)ComponentFactory.getObject(t, loc, this, (SearchContext)this);
        obj.parentElement = this;
        obj.getId();
        return (T)obj;
    }

    @Override
    public void afterCommand(QAFExtendedWebElement element, CommandTracker commandTracker) {
        commandTracker.setStage(CommandTracker.Stage.executingAfterMethod);
        for (QAFWebElementCommandListener listener : this.listners) {
            listener.afterCommand(element, commandTracker);
        }
    }

    @Override
    public void beforeCommand(QAFExtendedWebElement element, CommandTracker commandTracker) {
        commandTracker.setStage(CommandTracker.Stage.executingBeforeMethod);
        for (QAFWebElementCommandListener listener : this.listners) {
            listener.beforeCommand(element, commandTracker);
        }
    }

    @Override
    public void onFailure(QAFExtendedWebElement element, CommandTracker commandTracker) {
        commandTracker.setStage(CommandTracker.Stage.executingOnFailure);
        commandTracker.setEndTime(System.currentTimeMillis());
        if (commandTracker.getException() instanceof StaleElementReferenceException) {
            this.logger.warn((Object)commandTracker.getException().getMessage());
            element.setId("-1");
            Map<String, Object> parameters = commandTracker.getParameters();
            parameters.put("id", element.getId());
            commandTracker.setException(null);
            commandTracker.setStage(CommandTracker.Stage.executingMethod);
            Response response = element.execute(commandTracker.command, parameters);
            commandTracker.setEndTime(System.currentTimeMillis());
            commandTracker.setResponce(response);
        }
        for (QAFWebElementCommandListener listener : this.listners) {
            if (!commandTracker.hasException()) break;
            this.logger.debug((Object)("Executing listener " + listener.getClass().getName()));
            listener.onFailure(element, commandTracker);
        }
    }

    @Override
    public void waitForVisible(long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(RuntimeException.class, NoSuchElementException.class, StaleElementReferenceException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " to be visible").until(QAFWebElementExpectedConditions.elementVisible());
    }

    @Override
    public void waitForNotVisible(long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(RuntimeException.class).until(QAFWebElementExpectedConditions.elementNotVisible());
    }

    @Override
    public void waitForDisabled(long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(RuntimeException.class, NoSuchElementException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " to be disabled").until(QAFWebElementExpectedConditions.elementDisabled());
    }

    @Override
    public void waitForEnabled(long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " to be enabled").until(QAFWebElementExpectedConditions.elementEnabled());
    }

    @Override
    public void waitForPresent(long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " to be present").until(QAFWebElementExpectedConditions.elementPresent());
    }

    @Override
    public void waitForNotPresent(long ... timeout) {
        new QAFWebElementWait(this, timeout).withMessage("Wait time out for " + this.getDescription(new String[0]) + " to not be present").until(QAFWebElementExpectedConditions.elementNotPresent());
    }

    @Override
    public void waitForText(StringMatcher matcher, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " text " + matcher.toString()).until(QAFWebElementExpectedConditions.elementTextEq(matcher));
    }

    @Override
    public void waitForText(String text, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " text " + text).until(QAFWebElementExpectedConditions.elementTextEq(text));
    }

    @Override
    public void waitForNotText(StringMatcher matcher, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " text not: " + matcher.toString()).until(QAFWebElementExpectedConditions.elementTextNotEq(matcher));
    }

    @Override
    public void waitForNotText(String text, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " text not: " + text).until(QAFWebElementExpectedConditions.elementTextNotEq(text));
    }

    @Override
    public void waitForValue(Object value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " value" + value).until(QAFWebElementExpectedConditions.elementValueEq(value));
    }

    @Override
    public void waitForNotValue(Object value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " value not " + value).until(QAFWebElementExpectedConditions.elementValueNotEq(value));
    }

    @Override
    public void waitForSelected(long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " to be selected").until(QAFWebElementExpectedConditions.elementSelected());
    }

    @Override
    public void waitForNotSelected(long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " to not selected").until(QAFWebElementExpectedConditions.elementNotSelected());
    }

    @Override
    public void waitForAttribute(String name, String value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " " + name + " = " + value).until(QAFWebElementExpectedConditions.elementAttributeValueEq(name, value));
    }

    @Override
    public void waitForAttribute(String attr, StringMatcher value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " " + attr + " = " + value).until(QAFWebElementExpectedConditions.elementAttributeValueEq(attr, value));
    }

    @Override
    public void waitForNotAttribute(String name, String value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " " + name + "!=" + value).until(QAFWebElementExpectedConditions.elementAttributeValueNotEq(name, value));
    }

    @Override
    public void waitForNotAttribute(String attr, StringMatcher value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " " + attr + " = " + value).until(QAFWebElementExpectedConditions.elementAttributeValueNotEq(attr, value));
    }

    @Override
    public void waitForCssClass(String name, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " have css class " + name).until(QAFWebElementExpectedConditions.elementHasCssClass(name));
    }

    @Override
    public void waitForNotCssClass(String name, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " have not css class" + name).until(QAFWebElementExpectedConditions.elementHasNotCssClass(name));
    }

    @Override
    public void waitForCssStyle(String name, String value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " have css style " + name + "=" + value).until(QAFWebElementExpectedConditions.elementCssPropertyValueEq(name, value));
    }

    @Override
    public void waitForNotCssStyle(String name, String value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " have css style " + name + "!=" + value).until(QAFWebElementExpectedConditions.elementCssPropertyValueNotEq(name, value));
    }

    @Override
    public void waitForCssStyleColor(String name, String value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " have css style " + name + "=" + value).until(QAFWebElementExpectedConditions.elementCssColorPropertyValueEq(name, value));
    }

    @Override
    public void waitForNotCssStyleColor(String name, String value, long ... timeout) {
        new QAFWebElementWait(this, timeout).ignoring(NoSuchElementException.class, RuntimeException.class).withMessage("Wait time out for " + this.getDescription(new String[0]) + " have css style " + name + "!=" + value).until(QAFWebElementExpectedConditions.elementCssColorPropertyValueNotEq(name, value));
    }

    private boolean ensurePresent(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForPresent(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
            this.report("present", outcome, msgFor);
        }
        return outcome;
    }

    @Override
    public boolean verifyPresent(String ... label) {
        boolean outcome = this.ensurePresent(label);
        if (outcome) {
            String msgFor = this.getDescription(label);
            this.report("present", outcome, msgFor);
        }
        return outcome;
    }

    @Override
    public boolean verifyNotPresent(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotPresent(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notpresent", outcome, msgFor);
        return outcome;
    }

    @Override
    public boolean verifyVisible(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForVisible(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("visible", outcome, msgFor);
        return outcome;
    }

    @Override
    public boolean verifyNotVisible(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotVisible(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notvisible", outcome, msgFor);
        return outcome;
    }

    @Override
    public boolean verifyEnabled(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForEnabled(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("enabled", outcome, msgFor);
        return outcome;
    }

    @Override
    public boolean verifyDisabled(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForDisabled(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("disabled", outcome, msgFor);
        return outcome;
    }

    @Override
    public boolean verifyText(String text, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForText(text, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("text", outcome, msgFor, text, this.getText());
        return outcome;
    }

    @Override
    public boolean verifyNotText(String text, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotText(text, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("nottext", outcome, msgFor, text, this.getText());
        return outcome;
    }

    @Override
    public boolean verifyNotText(StringMatcher matcher, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotText(matcher, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("nottext", outcome, msgFor, matcher.toString(), this.getText());
        return outcome;
    }

    @Override
    public boolean verifyText(StringMatcher matcher, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForText(matcher, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("text", outcome, msgFor, matcher.toString(), this.getText());
        return outcome;
    }

    @Override
    public <T> boolean verifyValue(T value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForValue(value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("value", outcome, msgFor, value, this.getAttribute("value"));
        return outcome;
    }

    @Override
    public <T> boolean verifyNotValue(T value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotValue(value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notvalue", outcome, msgFor, value, this.getAttribute("value"));
        return outcome;
    }

    @Override
    public boolean verifySelected(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForSelected(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("selected", outcome, msgFor);
        return outcome;
    }

    @Override
    public boolean verifyNotSelected(String ... label) {
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotSelected(new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notselected", outcome, msgFor);
        return outcome;
    }

    @Override
    public boolean verifyAttribute(String name, String value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForAttribute(name, value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("attribute", outcome, msgFor, value, this.getAttribute(name));
        return outcome;
    }

    @Override
    public boolean verifyAttribute(String attr, StringMatcher matcher, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForAttribute(attr, matcher, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("attribute", outcome, msgFor, matcher, this.getAttribute(attr));
        return outcome;
    }

    @Override
    public boolean verifyNotAttribute(String name, String value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotAttribute(name, value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notattribute", outcome, msgFor, value, this.getAttribute(name));
        return outcome;
    }

    @Override
    public boolean verifyNotAttribute(String attr, StringMatcher matcher, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotAttribute(attr, matcher, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notattribute", outcome, msgFor, matcher, this.getAttribute(attr));
        return outcome;
    }

    @Override
    public boolean verifyCssClass(String name, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForCssClass(name, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("cssclass", outcome, msgFor, name, this.getAttribute("class"));
        return outcome;
    }

    @Override
    public boolean verifyNotCssClass(String name, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotCssClass(name, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notcssclass", outcome, msgFor, name, this.getAttribute("class"));
        return outcome;
    }

    @Override
    public boolean verifyCssStyle(String name, String value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForCssStyle(name, value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("cssstyle", outcome, msgFor, value, this.getCssValue(name));
        return outcome;
    }

    @Override
    public boolean verifyNotCssStyle(String name, String value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotCssStyle(name, value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notcssstyle", outcome, msgFor, value, this.getCssValue(name));
        return outcome;
    }

    @Override
    public boolean verifyCssStyleColor(String prop, String value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForCssStyleColor(prop, value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("cssstyle", outcome, msgFor, value, this.getCssValue(prop));
        return outcome;
    }

    @Override
    public boolean verifyNotCssStyleColor(String prop, String value, String ... label) {
        if (!this.ensurePresent(label)) {
            return false;
        }
        boolean outcome = true;
        String msgFor = this.getDescription(label);
        try {
            this.waitForNotCssStyleColor(prop, value, new long[0]);
        }
        catch (Exception exception) {
            outcome = false;
        }
        this.report("notcssstyle", outcome, msgFor, value, this.getCssValue(prop));
        return outcome;
    }

    @Override
    public void givenPresent() {
        if (!this.verifyPresent(new String[0])) {
            throw new SkipException("Precondition failed:" + this.getDescription(new String[0]) + " should be present");
        }
    }

    @Override
    public void givenNotPresent(String ... label) {
        if (!this.verifyNotPresent(label)) {
            throw new SkipException("Precondition failed:" + WebDriverCommandLogger.getMsgForElementOp("notpresent", false, this.getDescription(label)));
        }
    }

    @Override
    public void assertPresent(String ... label) {
        if (!this.verifyPresent(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotPresent(String ... label) {
        if (!this.verifyNotPresent(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertVisible(String ... label) {
        if (!this.verifyVisible(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotVisible(String ... label) {
        if (!this.verifyNotVisible(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertEnabled(String ... label) {
        if (!this.verifyEnabled(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertDisabled(String ... label) {
        if (!this.verifyDisabled(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertText(String text, String ... label) {
        if (!this.verifyText(text, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotText(String text, String ... label) {
        if (!this.verifyNotText(text, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertText(StringMatcher matcher, String ... label) {
        if (!this.verifyText(matcher, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assetNotText(StringMatcher matcher, String ... label) {
        if (!this.verifyNotText(matcher, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> void assertValue(T value, String ... label) {
        if (!this.verifyValue(value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> void assertNotValue(T value, String ... label) {
        if (!this.verifyNotValue(value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertSelected(String ... label) {
        if (!this.verifySelected(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotSelected(String ... label) {
        if (!this.verifyNotSelected(label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertAttribute(String name, String value, String ... label) {
        if (!this.verifyAttribute(name, value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertAttribute(String attr, StringMatcher matcher, String ... label) {
        if (!this.verifyAttribute(attr, matcher, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotAttribute(String name, String value, String ... label) {
        if (!this.verifyNotAttribute(name, value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotAttribute(String attr, StringMatcher matcher, String ... label) {
        if (!this.verifyNotAttribute(attr, matcher, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertCssClass(String name, String ... label) {
        if (!this.verifyCssClass(name, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotCssClass(String name, String ... label) {
        if (!this.verifyNotCssClass(name, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertCssStyle(String name, String value, String ... label) {
        if (!this.verifyCssStyle(name, value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotCssStyle(String name, String value, String ... label) {
        if (!this.verifyNotCssStyle(name, value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertCssStyleColor(String prop, String value, String ... label) {
        if (!this.verifyCssStyleColor(prop, value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public void assertNotCssStyleColor(String prop, String value, String ... label) {
        if (!this.verifyNotCssStyleColor(prop, value, label)) {
            throw new AssertionError();
        }
    }

    @Override
    public <T> T executeScript(String js) {
        QAFExtendedWebDriver executor = this.getWrappedDriver();
        return (T)executor.executeScript("arguments[0]." + js, new Object[]{this});
    }

    @Override
    public <T> T executeAsyncScript(String js) {
        QAFExtendedWebDriver executor = this.getWrappedDriver();
        return (T)executor.executeAsyncScript("arguments[0]." + js, new Object[]{this});
    }

    @Override
    public void setAttribute(String name, String value) {
        this.executeScript(String.valueOf(name) + "=" + value);
    }

    public void registerListeners(QAFWebElementCommandListener listener) {
        this.listners.add(listener);
    }

    protected void report(String op, boolean outcome, Object ... args) {
        this.getReporter().addMessage(WebDriverCommandLogger.getMsgForElementOp(op, outcome, args), outcome ? MessageTypes.Pass : MessageTypes.Fail, new Object[0]);
    }

    private void registerListeners(String className) {
        try {
            QAFWebElementCommandListener cls = (QAFWebElementCommandListener)Class.forName(className).newInstance();
            this.listners.add(cls);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to register listener class " + className), (Throwable)e);
        }
    }

    public void setParent(RemoteWebDriver parent) {
        if (parent == null) {
            parent = new WebDriverTestBase().getDriver();
        }
        super.setParent(parent);
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public QAFWebElement findElementByCustomStretegy(String strategy, String loc) {
        return (QAFExtendedWebElement)this.execute("findChildElement", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)strategy, (Object)"id", (Object)this.getId(), (Object)"value", (Object)loc)).getValue();
    }

    @Override
    public List<WebElement> findElementsByCustomStretegy(String strategy, String loc) {
        return (List)this.execute("findChildElements", (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)strategy, (Object)"id", (Object)this.getId(), (Object)"value", (Object)loc)).getValue();
    }
}

