/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    public static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";

    public static String getFormatedDate(String dateString, String formatFrom, String formatTo) {
        Date d;
        SimpleDateFormat aformat = new SimpleDateFormat(formatFrom);
        SimpleDateFormat eformat = new SimpleDateFormat(formatTo);
        try {
            d = aformat.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return eformat.format(d);
    }

    public static String getFormatedDate(Date date, String formatTo, String toLocale) {
        SimpleDateFormat eformat = new SimpleDateFormat(formatTo, new Locale(toLocale));
        return eformat.format(date);
    }

    public static String getFormatedDate(String dateString, String formatFrom, String formatTo, String fromLocale, String toLocale) {
        Date d;
        SimpleDateFormat aformat = new SimpleDateFormat(formatFrom, new Locale(fromLocale));
        SimpleDateFormat eformat = new SimpleDateFormat(formatTo, new Locale(toLocale));
        try {
            d = aformat.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return eformat.format(d);
    }

    public static String getDate(int days, String ... format) {
        String outformat = format == null || format.length < 1 ? DEFAULT_DATE_FORMAT : format[0];
        return new SimpleDateFormat(outformat).format(DateUtil.getDate(days));
    }

    public static String getDate(int min, int max, String ... format) {
        Double days = Math.random() * (double)(max - min + 1) + (double)min;
        return DateUtil.getDate(days.intValue(), format);
    }

    public static Date getDate(int days) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date getDateAfter(Date date, int days) {
        Calendar cal = DateUtil.getCalendarDate(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static int getMonthsDifference(Date date1, Date date2) {
        Calendar cal1 = DateUtil.getCalendarDate(date1);
        Calendar cal2 = DateUtil.getCalendarDate(date2);
        int m1 = cal1.get(1) * 12 + cal1.get(2);
        int m2 = cal2.get(1) * 12 + cal2.get(2);
        return m2 - m1;
    }

    public static int getDateDifference(Date date1, Date date2) {
        int oneDay = 86400000;
        Calendar cal1 = DateUtil.getCalendarDate(date1);
        Calendar cal2 = DateUtil.getCalendarDate(date2);
        return (int)((cal1.getTimeInMillis() - cal2.getTimeInMillis()) / (long)oneDay);
    }

    public static Calendar getCalendarDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Date parseDate(String dateStr, String format) throws ParseException {
        if (StringUtil.isBlank((String)format)) {
            format = DEFAULT_DATE_FORMAT;
        }
        return new SimpleDateFormat(format).parse(dateStr);
    }

    public static String getFormatedDate(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }
}

