/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.util.StringComparator;
import com.qmetry.qaf.automation.util.StringUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Random;
import java.util.Vector;
import javax.activation.MimetypesFileTypeMap;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class FileUtil
extends FileUtils {
    private static int counter = -1;

    public static String saveImageFile(String base64Str, String prefix, String dir) throws Exception {
        byte[] decodedScreenshot = Base64.decodeBase64((byte[])base64Str.getBytes());
        File file = FileUtil.generateFile(prefix, ".png", dir);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(decodedScreenshot);
        fos.close();
        return file.getName();
    }

    public static String saveImageFile(BufferedImage bImag, String prefix, String dir) throws Exception {
        File file = FileUtil.generateFile(prefix, ".png", dir);
        ImageIO.write((RenderedImage)bImag, "png", file);
        return file.getName();
    }

    public static String getContentType(File f) {
        MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String ct = fileNameMap.getContentTypeFor(f.getName());
        return StringUtil.isBlank((String)ct) ? fileTypeMap.getContentType(f) : ct;
    }

    public static boolean checkCreateDir(String dir) {
        File tdir = new File(dir);
        boolean dirExists = tdir.exists();
        if (!dirExists) {
            dirExists = tdir.mkdirs();
        }
        return dirExists;
    }

    public static String getReletivePath(String root, String filePath) {
        String relative = new File(root).toURI().relativize(new File(filePath).toURI()).getPath();
        return relative;
    }

    public static File generateFile(String prefix, String suffix, String dir) throws IOException {
        if (counter == -1) {
            counter = new Random().nextInt() & 0xFFFF;
        }
        return new File(dir, String.valueOf(prefix) + Integer.toString(++counter) + suffix);
    }

    public static File[] listFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = FileUtil.listFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> listFiles(File directory, String fname, StringComparator c, boolean recurse) {
        return FileUtil.listFiles(directory, FileUtil.getFileFilterFor(fname, c), recurse);
    }

    public static File[] listFilesAsArray(File directory, String fname, StringComparator c, boolean recurse) {
        Collection<File> files = FileUtil.listFiles(directory, fname, c, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        Vector<File> files = new Vector<File>();
        File[] fileArray = entries = directory.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (recurse && entry.isDirectory() && !entry.isHidden()) {
                files.addAll(FileUtil.listFiles(entry, filter, recurse));
            }
            ++n2;
        }
        return files;
    }

    public static String getBase64String(File f) throws IOException {
        return new String(Base64.encodeBase64((byte[])FileUtil.readFileToByteArray((File)f)));
    }

    public static FilenameFilter getFileFilterFor(final String fname, StringComparator comparator) {
        final StringComparator fnamecomparator = comparator != null ? comparator : StringComparator.In;
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return fnamecomparator.compareIgnoreCase(name, fname);
            }
        };
        return filter;
    }

    public static FilenameFilter getFileFilterFor(String name) {
        return FileUtil.getFileFilterFor(name, null);
    }

    public static FilenameFilter getFileFilterFor(final StringComparator c, final String ... qnames) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String[] stringArray = qnames;
                int n = qnames.length;
                int n2 = 0;
                while (n2 < n) {
                    String qname = stringArray[n2];
                    if (StringUtil.isNotBlank((String)qname) && c.compareIgnoreCase(name, qname)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        return filter;
    }

    public static Collection<File> getFiles(File directory, String extension, boolean recurse) {
        Vector<File> files = new Vector<File>();
        File[] entries = directory.listFiles();
        FilenameFilter filter = FileUtil.getFileFilterFor(extension, StringComparator.Suffix);
        File[] fileArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (recurse && entry.isDirectory()) {
                files.addAll(FileUtil.listFiles(entry, filter, recurse));
            }
            ++n2;
        }
        return files;
    }

    public static Collection<File> getFiles(File directory, String name, StringComparator c, boolean recurse) {
        Vector<File> files = new Vector<File>();
        File[] entries = directory.listFiles();
        FilenameFilter filter = FileUtil.getFileFilterFor(name, c);
        File[] fileArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (recurse && entry.isDirectory()) {
                files.addAll(FileUtil.listFiles(entry, filter, recurse));
            }
            ++n2;
        }
        return files;
    }

    public static File createTempFile(String ... fname) throws IOException {
        return FileUtil.createTempFile(null, fname);
    }

    public static File createTempFile(File dir, String ... name) throws IOException {
        String fname = null;
        String ext = null;
        if (name != null) {
            if (name.length == 1 && StringUtil.isNotEmpty((String)name[0])) {
                int dotSign = name[0].lastIndexOf(".");
                if (dotSign >= 0 && dotSign < name[0].length()) {
                    fname = name[0].substring(0, dotSign);
                    ext = name[0].substring(dotSign);
                } else {
                    fname = name[0];
                }
            } else if (name.length > 1) {
                fname = name[0];
                String string = ext = name[1].startsWith(".") ? name[1] : "." + name[1];
            }
        }
        if (StringUtil.isBlank(fname)) {
            fname = StringUtil.createRandomString("Auto");
        }
        File tmpfile = File.createTempFile(fname, ext, dir);
        tmpfile.deleteOnExit();
        return tmpfile;
    }

    public static void appendFile(String fileName, StringBuffer sb) throws IOException {
        FileWriter fileWritter = new FileWriter(fileName, true);
        BufferedWriter bufferWritter = new BufferedWriter(fileWritter);
        bufferWritter.write(sb.toString());
        bufferWritter.close();
    }

    public static String getExtention(String fileName) {
        int i = fileName.lastIndexOf(46);
        if (i >= 0) {
            return fileName.substring(i + 1);
        }
        return "";
    }

    public static String getRelativePath(String path, String basePath) {
        return FileUtil.getRelativePath(new File(path), new File(basePath));
    }

    public static String getRelativePath(File fileOrFolder, File baseFolder) {
        if (!baseFolder.isDirectory()) {
            baseFolder = baseFolder.getAbsoluteFile().getParentFile();
        }
        return baseFolder.toURI().relativize(fileOrFolder.toURI()).getPath();
    }
}

