/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonCompareUtil {
    public static MapDifference<String, Object> jsonCompare(String actualJsonStr, String expectedJsonStr, boolean strict) {
        Map<String, Object> expectedMap = JsonCompareUtil.toMap(expectedJsonStr);
        Map<String, Object> actualMap = JsonCompareUtil.toMap(actualJsonStr);
        Equivalence equivalenceImpl = strict ? new StrictEquivalenceImpl() : new ContainsEquivalenceImpl();
        return Maps.difference(expectedMap, actualMap, (Equivalence)equivalenceImpl);
    }

    private static boolean contains(Collection<?> c1, Collection<?> c2) {
        Iterator<?> iter = c1.iterator();
        while (iter.hasNext()) {
            ObjectWrapper c = new ObjectWrapper(iter.next());
            if (c2.remove(c)) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Object> toMap(String json) {
        JsonElement je = JSONUtil.getGsonElement(json);
        if (je.isJsonObject()) {
            return JSONUtil.toMap(json);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (je.isJsonArray()) {
            result.put("value", JSONUtil.toObject(json, List.class));
            return result;
        }
        result.put("value", JSONUtil.toObject(json));
        return result;
    }

    private static boolean match(Object o1, Object o2) {
        StringMatcher matcher = StringMatcher.getMatcherOrNull(String.valueOf(o1));
        if (matcher != null) {
            return matcher.match(String.valueOf(o2));
        }
        return o1.equals(o2);
    }

    private static class ContainsEquivalenceImpl
    extends Equivalence<Object> {
        private ContainsEquivalenceImpl() {
        }

        protected boolean doEquivalent(Object arg0, Object arg1) {
            if ("*".equals(arg0)) {
                return true;
            }
            if (arg0 instanceof Map && arg1 instanceof Map) {
                MapDifference res = Maps.difference((Map)((Map)arg0), (Map)((Map)arg1), (Equivalence)this);
                return res.entriesOnlyOnLeft().isEmpty() && res.entriesDiffering().isEmpty();
            }
            if (arg0 instanceof Collection && arg1 instanceof Collection) {
                return JsonCompareUtil.contains((Collection)arg0, (Collection)arg1);
            }
            return JsonCompareUtil.match(arg0, arg1);
        }

        protected int doHash(Object arg0) {
            return arg0.hashCode();
        }
    }

    private static class ObjectWrapper {
        private Object o;
        private Equivalence<Object> e;

        ObjectWrapper(Object o) {
            this.o = o;
            this.e = new ContainsEquivalenceImpl();
        }

        public boolean equals(Object obj) {
            return this.e.equivalent(this.o, obj);
        }

        public int hashCode() {
            return this.o.hashCode();
        }
    }

    private static class StrictEquivalenceImpl
    extends Equivalence<Object> {
        private StrictEquivalenceImpl() {
        }

        protected boolean doEquivalent(Object arg0, Object arg1) {
            if ("*".equals(arg0)) {
                return true;
            }
            if (arg0 instanceof Map && arg1 instanceof Map) {
                MapDifference res = Maps.difference((Map)((Map)arg0), (Map)((Map)arg1), (Equivalence)this);
                return res.areEqual();
            }
            if (arg0 instanceof Collection && arg1 instanceof Collection) {
                return ((Collection)arg1).size() == ((Collection)arg0).size() && JsonCompareUtil.contains((Collection)arg0, (Collection)arg1);
            }
            return JsonCompareUtil.match(arg0, arg1);
        }

        protected int doHash(Object arg0) {
            return arg0.hashCode();
        }
    }
}

