/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.JSONUtil;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.jexl3.JexlContext;

public class QAFJexlContext
implements JexlContext {
    private Map<String, Object> _ctx = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public QAFJexlContext() {
        this.set("_ctx", this);
    }

    public QAFJexlContext(Map<? extends String, ? extends Object> beans) {
        this();
        if (beans != null) {
            this._ctx.putAll(beans);
        }
    }

    public boolean has(String name) {
        return this._ctx.containsKey(name) || this.getClass(name) != null || ConfigurationManager.getBundle().containsKey(name);
    }

    public Object get(String name) {
        Class<?> value = this._ctx.get(name);
        if (value == null && !this._ctx.containsKey(name) && (value = this.getObject(name)) == null) {
            value = this.getClass(name);
        }
        return value;
    }

    public void set(String name, Object value) {
        this._ctx.put(name, value);
    }

    public void clear() {
        this._ctx.clear();
    }

    private Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private Object getObject(String name) {
        Object value = ConfigurationManager.getBundle().getProperty(name);
        if (value instanceof String) {
            String res = ConfigurationManager.getBundle().getSubstitutor().replace((String)value);
            value = JSONUtil.toObject(res);
        }
        return value;
    }
}

