/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.util.QAFJexlContext;
import com.qmetry.qaf.automation.util.StringMatcher;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.json.CDL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class StringUtil
extends StringUtils {
    public static final char NULL = '\u0000';

    public static String getTitleCase(String str) {
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    public static String toCamelCaseIdentifier(String formStr) {
        StringBuffer res = new StringBuffer();
        if (StringUtil.isEmpty((String)formStr)) {
            return "";
        }
        formStr = formStr.replaceAll("\\{(\\d)*(\\s)*\\}", "");
        String[] strArr = formStr.split("\\W");
        int i = 0;
        String[] stringArray = strArr;
        int n = strArr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.trim().length() > 0) {
                char[] stringArray2 = str.trim().toCharArray();
                stringArray2[0] = i == 0 ? Character.toLowerCase(stringArray2[0]) : Character.toUpperCase(stringArray2[0]);
                str = new String(stringArray2);
                res.append(str);
            }
            ++i;
            ++n2;
        }
        return res.toString().trim();
    }

    public static String toTitleCaseIdentifier(String formStr) {
        return StringUtil.getTitleCase(StringUtil.toCamelCaseIdentifier(formStr));
    }

    public static String getRandomString(String format) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < format.length()) {
            char c = format.charAt(i);
            char a = Character.isDigit(c) ? RandomStringUtils.randomNumeric((int)1).charAt(0) : (Character.isLetter(c) ? RandomStringUtils.randomAlphabetic((int)c).charAt(0) : c);
            sb.append(a);
            ++i;
        }
        return sb.toString();
    }

    public boolean containsNumbers(String str) {
        return str.matches(".*\\d.*");
    }

    public static String getFormatedDate(String dateString, String formatFrom, String formatTo) {
        Date d;
        SimpleDateFormat aformat = new SimpleDateFormat(formatFrom);
        SimpleDateFormat eformat = new SimpleDateFormat(formatTo);
        try {
            d = aformat.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return eformat.format(d);
    }

    public static String createRandomString(String prefix) {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return String.valueOf(prefix) + "_" + token;
    }

    public static String createRandomString() {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return token;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isXpath(String val) {
        return !StringUtil.isNullOrEmpty(val) && (val.startsWith("//") || val.toLowerCase().startsWith("xpath"));
    }

    public static String getWellFormedXPATH(String val) {
        String fstr = val;
        if (!val.toLowerCase().startsWith("xpath")) {
            fstr = "xpath=(" + val + ")[1]";
        }
        if (!val.endsWith("]")) {
            fstr = String.valueOf(val) + "[1]";
        }
        return fstr;
    }

    public static String extractParamValueFromUrl(String urlString, String paramName) {
        String[] params2;
        String retVal = "";
        String[] stringArray = params2 = urlString.split("\\?|&");
        int n = params2.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.startsWith(String.valueOf(paramName.trim()) + "=")) {
                retVal = param.substring(paramName.trim().length() + 1);
                break;
            }
            ++n2;
        }
        return retVal;
    }

    public static boolean seleniumEquals(String expectedPattern, String actual) {
        return StringMatcher.match(expectedPattern, actual);
    }

    public static Boolean handleRegex(String prefix, String expectedPattern, String actual, int flags) {
        if (expectedPattern.startsWith(prefix)) {
            String expectedRegEx = expectedPattern.replaceFirst(prefix, "");
            Pattern p = Pattern.compile(expectedRegEx, flags);
            if (!p.matcher(actual).matches()) {
                System.out.println("expected " + actual + " to match regexp " + expectedPattern);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public static Map<String, String> toMap(String csvKeyVal, boolean ensureKeyUppercase, char ... ch) {
        Object[] params2 = StringUtil.parseCSV(csvKeyVal, ch);
        return StringUtil.toMap((String[])params2, ensureKeyUppercase);
    }

    public static Map<String, String> toMap(String[] csvKeyVal, boolean ensureKeyUppercase) {
        WeakHashMap<String, String> map = new WeakHashMap<String, String>();
        if (csvKeyVal == null) {
            return map;
        }
        String[] stringArray = csvKeyVal;
        int n = csvKeyVal.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (StringUtil.isNotBlank((String)param)) {
                String[] kv = param.split("=", 2);
                map.put(ensureKeyUppercase ? kv[0].toUpperCase() : kv[0], kv.length > 1 ? kv[1] : "");
            }
            ++n2;
        }
        return map;
    }

    public static Object[] parseCSV(String data, char ... ch) {
        char escapeChar;
        ArrayList<Object> values = new ArrayList<Object>();
        boolean hasSeperator = ch != null && ch.length > 0 && ch[0] != '\u0000' && ch[0] != ',';
        char seperator = hasSeperator ? ch[0] : (char)',';
        char c = escapeChar = ch == null || ch.length < 2 || ch[1] == '\u0000' ? (char)'\\' : ch[1];
        if (data.indexOf(String.valueOf(escapeChar) + seperator) < 0) {
            String commaSperatoredData;
            if (hasSeperator && data.contains(",")) {
                data = StringUtil.ensuerStringQuated(data, seperator);
            }
            if ((commaSperatoredData = data.replace(seperator, ',')).trim().endsWith(",")) {
                commaSperatoredData = String.valueOf(commaSperatoredData) + "\"\"";
            }
            return StringUtil.getArrayFromCsv(commaSperatoredData);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length()) {
            char c2 = data.charAt(i);
            if (c2 == seperator) {
                values.add(StringUtil.toObject(sb.toString()));
                sb = new StringBuilder();
            } else {
                if (c2 == escapeChar) {
                    c2 = data.charAt(++i);
                }
                sb.append(c2);
            }
            ++i;
        }
        values.add(StringUtil.toObject(sb.toString()));
        return values.toArray(new Object[values.size()]);
    }

    public static Double[] extractNums(String s) {
        ArrayList<Double> lst = new ArrayList<Double>();
        Pattern p = Pattern.compile("-?\\d+.?\\d+");
        Matcher m = p.matcher(s);
        while (m.find()) {
            lst.add(Double.parseDouble(m.group()));
        }
        return lst.toArray(new Double[lst.size()]);
    }

    public static String commaSeparate(Collection<String> strings) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            buffer.append(string);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public static boolean booleanValueOf(String sVal, Boolean defaultValue) {
        if (StringUtil.isBlank((String)sVal)) {
            return defaultValue == null ? false : defaultValue;
        }
        boolean val = StringUtil.isNumeric((String)(sVal = sVal.trim())) ? Integer.parseInt(sVal) != 0 : Boolean.parseBoolean(sVal) || sVal.equalsIgnoreCase("T") || sVal.equalsIgnoreCase("Y") || sVal.equalsIgnoreCase("YES") || sVal.equalsIgnoreCase("ON");
        return val;
    }

    public static boolean booleanValueOf(String sVal) {
        return StringUtil.booleanValueOf(sVal, false);
    }

    public static String toStringWithSufix(int number) {
        if (number % 100 > 10 && number % 100 < 20) {
            return String.valueOf(number) + "th";
        }
        switch (number % 10) {
            case 1: {
                return String.valueOf(number) + "st";
            }
            case 2: {
                return String.valueOf(number) + "nd";
            }
            case 3: {
                return String.valueOf(number) + "rd";
            }
        }
        return String.valueOf(number) + "th";
    }

    public static <T> T eval(String expression) throws ScriptException {
        return StringUtil.eval(expression, Collections.emptyMap());
    }

    public static <T> T eval(String expression, Map<? extends String, ? extends Object> context) throws ScriptException {
        try {
            JexlEngine jexlEngine = new JexlBuilder().create();
            JexlExpression expr = jexlEngine.createExpression(expression);
            QAFJexlContext jc = new QAFJexlContext(context);
            return (T)expr.evaluate((JexlContext)jc);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public static Object toObject(String string) {
        if (string == null || JSONObject.NULL == string) {
            return null;
        }
        Object val = JSONObject.stringToValue((String)string);
        if (val == null || JSONObject.NULL == val) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).doubleValue();
        }
        return val;
    }

    private static String ensuerStringQuated(String data, char seperator) {
        String[] parts;
        if (StringUtil.isBlank((String)data) || data.indexOf(seperator) < 0) {
            return data;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = parts = data.split(Pattern.quote(String.valueOf(seperator)), -1);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if ((part = part.trim()).indexOf(44) >= 0 && !part.startsWith("\"") && !part.endsWith("\"")) {
                sb.append(JSONObject.quote((String)part));
            } else {
                sb.append(part);
            }
            sb.append(seperator);
            ++n2;
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static Object[] getArrayFromCsv(String csv) {
        JSONArray obj = CDL.rowToJSONArray((JSONTokener)new JSONTokener(csv));
        List strings = obj.toList();
        Object[] array = new Object[strings.size()];
        int i = 0;
        while (i < strings.size()) {
            array[i] = StringUtil.toObject((String)strings.get(i));
            ++i;
        }
        return array;
    }
}

