/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ws.rest;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ws.Response;
import com.qmetry.qaf.automation.ws.rest.DefaultRestClient;
import com.qmetry.qaf.automation.ws.rest.RequestTracker;
import com.qmetry.qaf.automation.ws.rest.RestClientFactory;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;

public class RestTestBase {
    private static final String REST_CLIENT_KEY = "rest.client";
    protected static final String REST_REQ_TRACKER_KEY = "rest.client.requesttracker";

    public Client getClient() {
        if (RestTestBase.getTestBase().getContext().getObject(REST_CLIENT_KEY) == null) {
            String clientFactoryClass = ApplicationProperties.REST_CLIENT_FACTORY_IMPL.getStringVal(DefaultRestClient.class.getName());
            try {
                RestClientFactory clientFactory = (RestClientFactory)Class.forName(clientFactoryClass).newInstance();
                RestTestBase.getTestBase().getContext().setProperty(REST_CLIENT_KEY, clientFactory.getClient());
            }
            catch (Exception e) {
                new AutomationError("Unable to create rest client", e);
            }
        }
        return (Client)RestTestBase.getTestBase().getContext().getObject(REST_CLIENT_KEY);
    }

    public void setClient(Client client) {
        RestTestBase.getTestBase().getContext().setProperty(REST_CLIENT_KEY, new DefaultRestClient(client).getClient());
    }

    public Response getResponse() {
        return new Response(RestTestBase.getRequestTracker().getClientResponse());
    }

    public WebResource getWebResource(String resouce) {
        return this.getWebResource(ApplicationProperties.SELENIUM_BASE_URL.getStringVal(new String[0]), resouce);
    }

    public WebResource getWebResource(String serviceEndPoint, String resouce) {
        return this.getClient().resource(serviceEndPoint).path(resouce);
    }

    public void resetClient() {
        RestTestBase.getTestBase().getContext().clearProperty(REST_CLIENT_KEY);
    }

    static QAFTestBase getTestBase() {
        return (QAFTestBase)TestBaseProvider.instance().get();
    }

    static RequestTracker getRequestTracker() {
        RequestTracker requestTracker = (RequestTracker)((Object)RestTestBase.getTestBase().getContext().getObject(REST_REQ_TRACKER_KEY));
        if (requestTracker == null) {
            requestTracker = new RequestTracker();
            RestTestBase.getTestBase().getContext().setProperty(REST_REQ_TRACKER_KEY, (Object)requestTracker);
        }
        return requestTracker;
    }
}

