/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.photo.activity;

import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import com.qmuiteam.photo.data.PhotoTransitionProviderRecover;
import com.qmuiteam.photo.data.PhotoViewerData;
import com.qmuiteam.photo.data.QMUIPhotoTransitionDelivery;
import com.qmuiteam.photo.data.QMUIPhotoTransitionInfo;
import com.qmuiteam.photo.data.QMUIPhotoTransitionInfoKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/qmuiteam/photo/activity/QMUIPhotoViewerViewModel;", "Landroidx/lifecycle/ViewModel;", "state", "Landroidx/lifecycle/SavedStateHandle;", "(Landroidx/lifecycle/SavedStateHandle;)V", "data", "Lcom/qmuiteam/photo/data/PhotoViewerData;", "getData", "()Lcom/qmuiteam/photo/data/PhotoViewerData;", "enterIndex", "", "getEnterIndex", "()I", "getState", "()Landroidx/lifecycle/SavedStateHandle;", "transitionDeliverKey", "", "onCleared", "", "photo_release"})
@StabilityInferred(parameters=0)
public final class QMUIPhotoViewerViewModel
extends ViewModel {
    @NotNull
    private final SavedStateHandle state;
    private final int enterIndex;
    @Nullable
    private final PhotoViewerData data;
    private final long transitionDeliverKey;
    public static final int $stable = 8;

    public QMUIPhotoViewerViewModel(@NotNull SavedStateHandle state) {
        PhotoViewerData photoViewerData;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        Integer n = (Integer)this.state.get("qmui_photo_current_index");
        if (n == null) {
            n = 0;
        }
        this.enterIndex = ((Number)n).intValue();
        Long l = (Long)this.state.get("qmui_photo_transition_delivery");
        if (l == null) {
            l = -1L;
        }
        this.transitionDeliverKey = ((Number)l).longValue();
        PhotoViewerData transitionDeliverData = QMUIPhotoTransitionDelivery.INSTANCE.getAndRemove(this.transitionDeliverKey);
        QMUIPhotoViewerViewModel qMUIPhotoViewerViewModel = this;
        if (transitionDeliverData != null) {
            photoViewerData = transitionDeliverData;
        } else {
            int count;
            Integer n2 = (Integer)this.state.get("qmui_photo_count");
            if (n2 == null) {
                n2 = 0;
            }
            if ((count = ((Number)n2).intValue()) > 0) {
                ArrayList<QMUIPhotoTransitionInfo> list = new ArrayList<QMUIPhotoTransitionInfo>();
                int n3 = 0;
                QMUIPhotoViewerViewModel qMUIPhotoViewerViewModel2 = qMUIPhotoViewerViewModel;
                while (n3 < count) {
                    int i = n3++;
                    try {
                        CharSequence charSequence;
                        Bundle meta = (Bundle)this.state.get("qmui_photo_meta_" + i);
                        String clsName = (String)this.state.get("qmui_photo_provider_recover_cls_" + i);
                        if (meta == null || (charSequence = (CharSequence)clsName) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                            list.add(QMUIPhotoTransitionInfoKt.getLossPhotoTransitionInfo());
                            continue;
                        }
                        Class<?> cls = Class.forName(clsName);
                        Object obj = cls.newInstance();
                        if (obj == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.qmuiteam.photo.data.PhotoTransitionProviderRecover");
                        }
                        PhotoTransitionProviderRecover recover = (PhotoTransitionProviderRecover)obj;
                        QMUIPhotoTransitionInfo qMUIPhotoTransitionInfo = recover.recover(meta);
                        if (qMUIPhotoTransitionInfo == null) {
                            qMUIPhotoTransitionInfo = QMUIPhotoTransitionInfoKt.getLossPhotoTransitionInfo();
                        }
                        list.add(qMUIPhotoTransitionInfo);
                    }
                    catch (Throwable e) {
                        list.add(QMUIPhotoTransitionInfoKt.getLossPhotoTransitionInfo());
                    }
                }
                qMUIPhotoViewerViewModel = qMUIPhotoViewerViewModel2;
                photoViewerData = new PhotoViewerData((List<QMUIPhotoTransitionInfo>)list, this.enterIndex, null);
            } else {
                photoViewerData = null;
            }
        }
        qMUIPhotoViewerViewModel.data = photoViewerData;
    }

    @NotNull
    public final SavedStateHandle getState() {
        return this.state;
    }

    public final int getEnterIndex() {
        return this.enterIndex;
    }

    @Nullable
    public final PhotoViewerData getData() {
        return this.data;
    }

    protected void onCleared() {
        super.onCleared();
        QMUIPhotoTransitionDelivery.INSTANCE.remove(this.transitionDeliverKey);
    }
}

