/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.photo.util;

import com.qmuiteam.photo.util.BitmapCompressStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/qmuiteam/photo/util/BitmapCompressFileStream;", "Lcom/qmuiteam/photo/util/BitmapCompressStream;", "cacheDir", "Ljava/io/File;", "(Ljava/io/File;)V", "getCacheDir", "()Ljava/io/File;", "file", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "reset", "", "size", "", "photo_release"})
public final class BitmapCompressFileStream
implements BitmapCompressStream {
    @NotNull
    private final File cacheDir;
    @Nullable
    private File file;

    public BitmapCompressFileStream(@NotNull File cacheDir) {
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        this.cacheDir = cacheDir;
    }

    @NotNull
    public final File getCacheDir() {
        return this.cacheDir;
    }

    @Override
    public void reset() {
        File file = this.file;
        if (file != null) {
            file.delete();
        }
        this.file = new File(this.cacheDir, "qmui-bm-" + System.nanoTime());
    }

    @Override
    public int size() {
        int n;
        File file = this.file;
        if (file == null) {
            n = 0;
        } else {
            int n2;
            long l = file.length();
            n = n2 = (int)l;
        }
        return n;
    }

    @Override
    @NotNull
    public OutputStream outputStream() {
        File file = this.file;
        Intrinsics.checkNotNull((Object)file);
        OutputStream outputStream = new FileOutputStream(file);
        int n = 8192;
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
    }

    @Override
    @Nullable
    public InputStream inputStream() {
        BufferedInputStream bufferedInputStream;
        File file = this.file;
        if (file == null) {
            bufferedInputStream = null;
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStream inputStream = fileInputStream;
            int n = 8192;
            bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
        }
        return bufferedInputStream;
    }
}

