/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.photo.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.qmuiteam.compose.core.helper.QMUILog;
import com.qmuiteam.photo.util.BitmapCompressFileStream;
import com.qmuiteam.photo.util.BitmapCompressMemoryStream;
import com.qmuiteam.photo.util.BitmapCompressResult;
import com.qmuiteam.photo.util.BitmapCompressStream;
import com.qmuiteam.photo.util.BitmapCompressStreamResult;
import com.qmuiteam.photo.util.BitmapExKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a^\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00072\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u00012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0007\u001a&\u0010\u0013\u001a\u00020\u0014*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0007\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00070\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\u0017"}, d2={"DefaultBitmapCompressCanUseMemoryStorage", "Lkotlin/Function1;", "Landroid/graphics/Bitmap;", "", "getDefaultBitmapCompressCanUseMemoryStorage", "()Lkotlin/jvm/functions/Function1;", "DefaultBitmapCompressMaxSizeStrategy", "", "getDefaultBitmapCompressMaxSizeStrategy", "compressByShortEdgeWidthAndByteSize", "Lcom/qmuiteam/photo/util/BitmapCompressResult;", "context", "Landroid/content/Context;", "shortEdgeMaxWidth", "byteMaxSizeStrategy", "canUseMemoryStorage", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "compressQuality", "saveToLocal", "Landroid/net/Uri;", "dir", "Ljava/io/File;", "photo_release"})
public final class BitmapExKt {
    @NotNull
    private static final Function1<Bitmap, Integer> DefaultBitmapCompressMaxSizeStrategy = DefaultBitmapCompressMaxSizeStrategy.1.INSTANCE;
    @NotNull
    private static final Function1<Bitmap, Boolean> DefaultBitmapCompressCanUseMemoryStorage = DefaultBitmapCompressCanUseMemoryStorage.1.INSTANCE;

    @NotNull
    public static final Function1<Bitmap, Integer> getDefaultBitmapCompressMaxSizeStrategy() {
        return DefaultBitmapCompressMaxSizeStrategy;
    }

    @NotNull
    public static final Function1<Bitmap, Boolean> getDefaultBitmapCompressCanUseMemoryStorage() {
        return DefaultBitmapCompressCanUseMemoryStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Uri saveToLocal(@NotNull Bitmap $this$saveToLocal, @NotNull File dir, @NotNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$saveToLocal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        switch (WhenMappings.$EnumSwitchMapping$0[compressFormat.ordinal()]) {
            case 1: {
                string = "jpeg";
                break;
            }
            case 2: {
                string = "png";
                break;
            }
            default: {
                string = "webp";
            }
        }
        String suffix = string;
        String fileName = "qmui_photo_" + System.nanoTime() + "." + suffix;
        dir.mkdirs();
        File destFile = new File(dir, fileName);
        Closeable closeable = new FileOutputStream(destFile);
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)closeable;
            boolean bl = false;
            boolean bl2 = $this$saveToLocal.compress(compressFormat, compressQuality, (OutputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File $this$toUri$iv = destFile;
        boolean $i$f$toUri = false;
        Uri uri = Uri.fromFile((File)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
        return uri;
    }

    public static /* synthetic */ Uri saveToLocal$default(Bitmap bitmap2, File file, Bitmap.CompressFormat compressFormat, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            compressFormat = Bitmap.CompressFormat.JPEG;
        }
        if ((n2 & 4) != 0) {
            n = 80;
        }
        return BitmapExKt.saveToLocal(bitmap2, file, compressFormat, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final BitmapCompressResult compressByShortEdgeWidthAndByteSize(@NotNull Bitmap $this$compressByShortEdgeWidthAndByteSize, @NotNull Context context, int shortEdgeMaxWidth, @NotNull Function1<? super Bitmap, Integer> byteMaxSizeStrategy, @NotNull Function1<? super Bitmap, Boolean> canUseMemoryStorage, @NotNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        BitmapCompressStream bitmapCompressStream;
        Intrinsics.checkNotNullParameter((Object)$this$compressByShortEdgeWidthAndByteSize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(byteMaxSizeStrategy, (String)"byteMaxSizeStrategy");
        Intrinsics.checkNotNullParameter(canUseMemoryStorage, (String)"canUseMemoryStorage");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Bitmap bitmap2 = null;
        bitmap2 = $this$compressByShortEdgeWidthAndByteSize;
        try {
            Bitmap bitmap3;
            float ratio = (float)$this$compressByShortEdgeWidthAndByteSize.getWidth() / (float)$this$compressByShortEdgeWidthAndByteSize.getHeight();
            if ($this$compressByShortEdgeWidthAndByteSize.getWidth() <= $this$compressByShortEdgeWidthAndByteSize.getHeight()) {
                if ($this$compressByShortEdgeWidthAndByteSize.getWidth() > shortEdgeMaxWidth) {
                    bitmap3 = Bitmap.createScaledBitmap((Bitmap)$this$compressByShortEdgeWidthAndByteSize, (int)shortEdgeMaxWidth, (int)((int)((float)shortEdgeMaxWidth / ratio)), (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createScaledBitmap(this,\u2026 / ratio).toInt(), false)");
                    bitmap2 = bitmap3;
                }
            } else if ($this$compressByShortEdgeWidthAndByteSize.getHeight() > shortEdgeMaxWidth) {
                bitmap3 = Bitmap.createScaledBitmap((Bitmap)$this$compressByShortEdgeWidthAndByteSize, (int)((int)((float)shortEdgeMaxWidth * ratio)), (int)shortEdgeMaxWidth, (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createScaledBitmap(this,\u2026shortEdgeMaxWidth, false)");
                bitmap2 = bitmap3;
            }
        }
        catch (OutOfMemoryError ignored) {
            QMUILog.w$default((QMUILog)QMUILog.INSTANCE, (String)"compressByShortEdgeWidthAndByteSize", (String)("createScaledBitmap failed: shortEdgeMaxWidth = " + shortEdgeMaxWidth + ", width = " + $this$compressByShortEdgeWidthAndByteSize.getWidth() + "; height = " + $this$compressByShortEdgeWidthAndByteSize.getHeight()), null, (int)4, null);
        }
        int byteMaxSize = ((Number)byteMaxSizeStrategy.invoke((Object)$this$compressByShortEdgeWidthAndByteSize)).intValue();
        boolean useMemoryStorage = (Boolean)canUseMemoryStorage.invoke((Object)$this$compressByShortEdgeWidthAndByteSize);
        if (useMemoryStorage) {
            bitmapCompressStream = new BitmapCompressMemoryStream();
        } else {
            File file = context.getCacheDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.cacheDir");
            bitmapCompressStream = new BitmapCompressFileStream(file);
        }
        BitmapCompressStream stream = bitmapCompressStream;
        int currentQuality = 0;
        int nextQuality = currentQuality = compressQuality;
        int failCount = 0;
        int succes = 0;
        do {
            int n;
            stream.reset();
            currentQuality = nextQuality;
            try {
                boolean bl;
                Closeable closeable = stream.outputStream();
                Throwable throwable = null;
                try {
                    OutputStream it = (OutputStream)closeable;
                    boolean bl2 = false;
                    bl = bitmap2.compress(compressFormat, currentQuality, it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                n = bl ? 1 : 0;
            }
            catch (Throwable e) {
                QMUILog.INSTANCE.w("compressByShortEdgeWidthAndByteSize", "compress bitmap failed(compressFormat = " + compressFormat + "; quality = " + nextQuality + ", failCount = " + failCount + ").", e);
                n = 0;
            }
            succes = n;
            if (succes != 0) {
                nextQuality -= 10;
                failCount = 0;
                continue;
            }
            nextQuality -= 5;
            n = failCount;
            failCount = n + 1;
        } while (succes == 0 && failCount < 2 && nextQuality >= 20 || succes != 0 && nextQuality >= 20 && stream.size() > byteMaxSize);
        if (succes == 0) {
            return null;
        }
        return new BitmapCompressStreamResult(compressFormat, currentQuality, stream);
    }

    public static /* synthetic */ BitmapCompressResult compressByShortEdgeWidthAndByteSize$default(Bitmap bitmap2, Context context, int n, Function1 function1, Function1 function12, Bitmap.CompressFormat compressFormat, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 1200;
        }
        if ((n3 & 4) != 0) {
            function1 = DefaultBitmapCompressMaxSizeStrategy;
        }
        if ((n3 & 8) != 0) {
            function12 = DefaultBitmapCompressCanUseMemoryStorage;
        }
        if ((n3 & 0x10) != 0) {
            compressFormat = Bitmap.CompressFormat.JPEG;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 80;
        }
        return BitmapExKt.compressByShortEdgeWidthAndByteSize(bitmap2, context, n, function1, function12, compressFormat, n2);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitmap.CompressFormat.values().length];
            nArray[Bitmap.CompressFormat.JPEG.ordinal()] = 1;
            nArray[Bitmap.CompressFormat.PNG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

