/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.photo.util;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.qmuiteam.photo.util.BitmapCompressResult;
import com.qmuiteam.photo.util.BitmapExKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jp\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\r0\n2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\n2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\rJ>\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\rJ>\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/qmuiteam/photo/util/QMUIPhotoHelper;", "", "()V", "TAG", "", "compressByShortEdgeWidthAndByteSize", "Lcom/qmuiteam/photo/util/BitmapCompressResult;", "context", "Landroid/content/Context;", "originProvider", "Lkotlin/Function1;", "Ljava/io/InputStream;", "shortEdgeMaxWidth", "", "byteMaxSizeStrategy", "Landroid/graphics/Bitmap;", "canUseMemoryStorage", "", "compressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "compressQuality", "saveToStore", "Landroid/net/Uri;", "bitmap", "nameWithoutSuffix", "dirName", "name", "mimeType", "writer", "Ljava/io/OutputStream;", "", "photo_release"})
@StabilityInferred(parameters=0)
public final class QMUIPhotoHelper {
    @NotNull
    public static final QMUIPhotoHelper INSTANCE = new QMUIPhotoHelper();
    @NotNull
    private static final String TAG = "QMUIPhotoHelper";
    public static final int $stable;

    private QMUIPhotoHelper() {
    }

    @Nullable
    public final Uri saveToStore(@NotNull Context context, @NotNull Bitmap bitmap2, @NotNull String nameWithoutSuffix, @NotNull String dirName, @NotNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)nameWithoutSuffix, (String)"nameWithoutSuffix");
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        switch (WhenMappings.$EnumSwitchMapping$0[compressFormat.ordinal()]) {
            case 1: {
                string2 = ".jpeg";
                break;
            }
            case 2: {
                string2 = ".png";
                break;
            }
            default: {
                string2 = ".webp";
            }
        }
        String suffix = string2;
        switch (WhenMappings.$EnumSwitchMapping$0[compressFormat.ordinal()]) {
            case 1: {
                string = "image/jpeg";
                break;
            }
            case 2: {
                string = "image/png";
                break;
            }
            default: {
                string = "image/webp";
            }
        }
        String mime = string;
        return this.saveToStore(context, nameWithoutSuffix + suffix, mime, dirName, (Function1<? super OutputStream, Unit>)((Function1)new Function1<OutputStream, Unit>(bitmap2, compressFormat, compressQuality){
            final /* synthetic */ Bitmap $bitmap;
            final /* synthetic */ Bitmap.CompressFormat $compressFormat;
            final /* synthetic */ int $compressQuality;
            {
                this.$bitmap = $bitmap;
                this.$compressFormat = $compressFormat;
                this.$compressQuality = $compressQuality;
                super(1);
            }

            public final void invoke(@NotNull OutputStream it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$bitmap.compress(this.$compressFormat, this.$compressQuality, it);
            }
        }));
    }

    public static /* synthetic */ Uri saveToStore$default(QMUIPhotoHelper qMUIPhotoHelper, Context context, Bitmap bitmap2, String string, String string2, Bitmap.CompressFormat compressFormat, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            String string3 = Environment.DIRECTORY_PICTURES;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DIRECTORY_PICTURES");
            string2 = string3;
        }
        if ((n2 & 0x10) != 0) {
            compressFormat = Bitmap.CompressFormat.JPEG;
        }
        if ((n2 & 0x20) != 0) {
            n = 100;
        }
        return qMUIPhotoHelper.saveToStore(context, bitmap2, string, string2, compressFormat, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Uri saveToStore(@NotNull Context context, @NotNull String name, @NotNull String mimeType, @NotNull String dirName, @NotNull Function1<? super OutputStream, Unit> writer) {
        OutputStream outputStream;
        Uri uri;
        ContentValues contentValues;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        ContentValues $this$saveToStore_u24lambda_u2d0 = contentValues = new ContentValues();
        boolean bl = false;
        $this$saveToStore_u24lambda_u2d0.put("_display_name", name);
        $this$saveToStore_u24lambda_u2d0.put("date_added", Long.valueOf(System.currentTimeMillis()));
        $this$saveToStore_u24lambda_u2d0.put("mime_type", mimeType);
        if (Build.VERSION.SDK_INT >= 29) {
            $this$saveToStore_u24lambda_u2d0.put("relative_path", dirName);
            $this$saveToStore_u24lambda_u2d0.put("is_pending", Integer.valueOf(1));
        }
        ContentValues contentValues2 = contentValues;
        Uri contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        OutputStream stream = null;
        Uri uri2 = null;
        try {
            uri2 = context.getContentResolver().insert(contentUri, contentValues2);
            if (uri2 == null) {
                throw new IOException("Failed to create new MediaStore record.");
            }
            stream = context.getContentResolver().openOutputStream(uri2);
            if (stream == null) {
                throw new IOException("Failed to get output stream.");
            }
            writer.invoke((Object)stream);
            contentValues2.clear();
            if (Build.VERSION.SDK_INT >= 29) {
                contentValues2.put("is_pending", Integer.valueOf(0));
                context.getContentResolver().update(uri2, contentValues2, null, null);
            }
            uri = uri2;
            outputStream = stream;
        }
        catch (Throwable e) {
            try {
                Log.i((String)TAG, (String)"saveToStore failed.", (Throwable)e);
                if (uri2 == null) return null;
                context.getContentResolver().delete(uri2, null, null);
                return null;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                OutputStream outputStream2 = stream;
                if (outputStream2 != null) {
                    outputStream2.close();
                }
            }
        }
        outputStream.close();
        return uri;
    }

    public static /* synthetic */ Uri saveToStore$default(QMUIPhotoHelper qMUIPhotoHelper, Context context, String string, String string2, String string3, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            String string4 = Environment.DIRECTORY_PICTURES;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"DIRECTORY_PICTURES");
            string3 = string4;
        }
        return qMUIPhotoHelper.saveToStore(context, string, string2, string3, (Function1<? super OutputStream, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final BitmapCompressResult compressByShortEdgeWidthAndByteSize(@NotNull Context context, @NotNull Function1<? super Context, ? extends InputStream> originProvider, int shortEdgeMaxWidth, @NotNull Function1<? super Bitmap, Integer> byteMaxSizeStrategy, @NotNull Function1<? super Bitmap, Boolean> canUseMemoryStorage, @NotNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        Bitmap bitmap2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(originProvider, (String)"originProvider");
        Intrinsics.checkNotNullParameter(byteMaxSizeStrategy, (String)"byteMaxSizeStrategy");
        Intrinsics.checkNotNullParameter(canUseMemoryStorage, (String)"canUseMemoryStorage");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        Context applicationContext = context.getApplicationContext();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"applicationContext");
        InputStream inputStream = (InputStream)originProvider.invoke((Object)applicationContext);
        if (inputStream == null) {
            return null;
        }
        InputStream inputStream2 = inputStream;
        Closeable closeable = inputStream2;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            it = BitmapFactory.decodeStream((InputStream)it, null, (BitmapFactory.Options)options);
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        int imageHeight = options.outHeight;
        int imageWidth = options.outWidth;
        if (imageWidth <= imageHeight) {
            if (imageWidth > shortEdgeMaxWidth) {
                options.inSampleSize = Integer.highestOneBit(imageWidth / shortEdgeMaxWidth);
            }
        } else if (imageHeight > shortEdgeMaxWidth) {
            options.inSampleSize = Integer.highestOneBit(imageHeight / shortEdgeMaxWidth);
        }
        options.inJustDecodeBounds = false;
        InputStream inputStream3 = (InputStream)originProvider.invoke((Object)applicationContext);
        if (inputStream3 == null) {
            return null;
        }
        inputStream2 = inputStream3;
        Closeable closeable2 = inputStream2;
        Throwable throwable2 = null;
        try {
            InputStream it = (InputStream)closeable2;
            boolean bl = false;
            bitmap2 = BitmapFactory.decodeStream((InputStream)it, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
        }
        Bitmap bitmap3 = bitmap2;
        if (bitmap3 == null) {
            return new BitmapCompressResult(compressFormat, originProvider, applicationContext){
                final /* synthetic */ Bitmap.CompressFormat $compressFormat;
                final /* synthetic */ Function1<Context, InputStream> $originProvider;
                final /* synthetic */ Context $applicationContext;
                {
                    this.$compressFormat = $compressFormat;
                    this.$originProvider = $originProvider;
                    this.$applicationContext = $applicationContext;
                    super($compressFormat, -1);
                }

                @Nullable
                public InputStream inputStream() {
                    Context context = this.$applicationContext;
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                    return (InputStream)this.$originProvider.invoke((Object)context);
                }
            };
        }
        Bitmap bitmap4 = bitmap3;
        return BitmapExKt.compressByShortEdgeWidthAndByteSize(bitmap4, context, shortEdgeMaxWidth, byteMaxSizeStrategy, canUseMemoryStorage, compressFormat, compressQuality);
    }

    public static /* synthetic */ BitmapCompressResult compressByShortEdgeWidthAndByteSize$default(QMUIPhotoHelper qMUIPhotoHelper, Context context, Function1 function1, int n, Function1 function12, Function1 function13, Bitmap.CompressFormat compressFormat, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 1200;
        }
        if ((n3 & 8) != 0) {
            function12 = BitmapExKt.getDefaultBitmapCompressMaxSizeStrategy();
        }
        if ((n3 & 0x10) != 0) {
            function13 = BitmapExKt.getDefaultBitmapCompressCanUseMemoryStorage();
        }
        if ((n3 & 0x20) != 0) {
            compressFormat = Bitmap.CompressFormat.JPEG;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 80;
        }
        return qMUIPhotoHelper.compressByShortEdgeWidthAndByteSize(context, (Function1<? super Context, ? extends InputStream>)function1, n, function12, function13, compressFormat, n2);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitmap.CompressFormat.values().length];
            nArray[Bitmap.CompressFormat.JPEG.ordinal()] = 1;
            nArray[Bitmap.CompressFormat.PNG.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

