/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.photo.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Size;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.widget.ImageView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"getWindowSize", "Landroid/util/Size;", "context", "Landroid/content/Context;", "asBitmap", "Landroid/graphics/Bitmap;", "Landroid/view/View;", "photo_release"})
public final class ViewExKt {
    @Nullable
    public static final Bitmap asBitmap(@NotNull View $this$asBitmap) {
        Bitmap bitmap2;
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)$this$asBitmap, (String)"<this>");
        if ($this$asBitmap instanceof ImageView && (drawable2 = ((ImageView)$this$asBitmap).getDrawable()) != null && drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        try {
            $this$asBitmap.clearFocus();
            Bitmap bm = Bitmap.createBitmap((int)$this$asBitmap.getWidth(), (int)$this$asBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas();
            canvas.setBitmap(bm);
            canvas.save();
            $this$asBitmap.draw(canvas);
            canvas.restore();
            canvas.setBitmap(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            bitmap2 = null;
        }
        return bitmap2;
    }

    @NotNull
    public static final Size getWindowSize(@NotNull Context context) {
        Size size;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 30) {
            Object object = context.getSystemService("window");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager wm = (WindowManager)object;
            WindowMetrics windowMetrics = wm.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"wm.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            size = new Size(windowMetrics2.getBounds().width(), windowMetrics2.getBounds().height());
        } else {
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            size = new Size(displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        return size;
    }
}

