/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import androidx.annotation.NonNull;
import androidx.core.view.NestedScrollingChild2;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent2;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.QMUIInterpolatorStaticHolder;
import com.qmuiteam.qmui.layout.QMUIFrameLayout;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedBottomView;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedScrollCommon;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.util.QMUIViewOffsetHelper;

public abstract class QMUIContinuousNestedBottomDelegateLayout
extends QMUIFrameLayout
implements NestedScrollingChild2,
NestedScrollingParent2,
IQMUIContinuousNestedBottomView {
    public static final String KEY_SCROLL_INFO_OFFSET = "@qmui_scroll_info_bottom_dl_offset";
    private final NestedScrollingParentHelper mParentHelper;
    private final NestedScrollingChildHelper mChildHelper;
    private View mHeaderView;
    private View mContentView;
    private QMUIViewOffsetHelper mHeaderViewOffsetHelper;
    private QMUIViewOffsetHelper mContentViewOffsetHelper;
    private IQMUIContinuousNestedScrollCommon.OnScrollNotifier mOnScrollNotifier;
    private static final int INVALID_POINTER = -1;
    private boolean isBeingDragged;
    private int activePointerId = -1;
    private int lastMotionY;
    private int touchSlop = -1;
    private VelocityTracker velocityTracker;
    private final ViewFlinger mViewFlinger;
    private final int[] mScrollConsumed = new int[2];
    private final int[] mScrollOffset = new int[2];
    private Rect mTempRect = new Rect();
    private int mNestedOffsetY = 0;
    private Runnable mCheckLayoutAction = new Runnable(){

        @Override
        public void run() {
            QMUIContinuousNestedBottomDelegateLayout.this.checkLayout();
        }
    };

    public QMUIContinuousNestedBottomDelegateLayout(Context context) {
        this(context, null);
    }

    public QMUIContinuousNestedBottomDelegateLayout(Context context, AttributeSet attrs) {
        this(context, null, 0);
    }

    public QMUIContinuousNestedBottomDelegateLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        ViewCompat.setNestedScrollingEnabled((View)this, (boolean)true);
        this.mHeaderView = this.onCreateHeaderView();
        this.mContentView = this.onCreateContentView();
        if (!(this.mContentView instanceof IQMUIContinuousNestedBottomView)) {
            throw new IllegalStateException("the view create by onCreateContentView() should implement from IQMUIContinuousNestedBottomView");
        }
        this.addView(this.mHeaderView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.getHeaderHeightLayoutParam()));
        this.addView(this.mContentView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mHeaderViewOffsetHelper = new QMUIViewOffsetHelper(this.mHeaderView);
        this.mContentViewOffsetHelper = new QMUIViewOffsetHelper(this.mContentView);
        this.mViewFlinger = new ViewFlinger();
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public int getOffsetCurrent() {
        return -this.mHeaderViewOffsetHelper.getTopAndBottomOffset();
    }

    public int getOffsetRange() {
        return -this.getMiniOffset();
    }

    private int getMiniOffset() {
        IQMUIContinuousNestedBottomView b = (IQMUIContinuousNestedBottomView)this.mContentView;
        int contentHeight = b.getContentHeight();
        FrameLayout.LayoutParams headerLp = (FrameLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        int minOffset = -this.mHeaderView.getHeight() - headerLp.bottomMargin + this.getHeaderStickyHeight();
        if (contentHeight != -1) {
            minOffset += this.mContentView.getHeight() - contentHeight;
            minOffset = Math.min(minOffset, 0);
        }
        return minOffset;
    }

    @Override
    public int getContentHeight() {
        IQMUIContinuousNestedBottomView b = (IQMUIContinuousNestedBottomView)this.mContentView;
        int bc = b.getContentHeight();
        if (bc == -1 || bc > this.mContentView.getHeight()) {
            return -1;
        }
        int bottomMargin = this.getContentBottomMargin();
        if (bc + this.mHeaderView.getHeight() + bottomMargin > this.getHeight()) {
            return -1;
        }
        return this.mHeaderView.getHeight() + bc + bottomMargin;
    }

    @NonNull
    protected abstract View onCreateHeaderView();

    @NonNull
    protected abstract View onCreateContentView();

    protected int getHeaderStickyHeight() {
        return 0;
    }

    protected int getHeaderHeightLayoutParam() {
        return -2;
    }

    protected int getContentBottomMargin() {
        return 0;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mContentView.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)(heightSize - this.getHeaderStickyHeight() - this.getContentBottomMargin()), (int)0x40000000));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mHeaderView.layout(0, 0, this.mHeaderView.getMeasuredWidth(), this.mHeaderView.getMeasuredHeight());
        int contentTop = this.mHeaderView.getBottom();
        this.mContentView.layout(0, contentTop, this.mContentView.getMeasuredWidth(), contentTop + this.mContentView.getMeasuredHeight());
        this.mHeaderViewOffsetHelper.onViewLayout();
        this.mContentViewOffsetHelper.onViewLayout();
        this.postCheckLayout();
    }

    public void postCheckLayout() {
        this.removeCallbacks(this.mCheckLayoutAction);
        this.post(this.mCheckLayoutAction);
    }

    public void checkLayout() {
        int offsetCurrent = this.getOffsetCurrent();
        int offsetRange = this.getOffsetRange();
        IQMUIContinuousNestedBottomView bottomView = (IQMUIContinuousNestedBottomView)this.mContentView;
        if (offsetCurrent < offsetRange && bottomView.getCurrentScroll() > 0) {
            bottomView.consumeScroll(Integer.MIN_VALUE);
        }
    }

    private int offsetBy(int dyUnConsumed) {
        int canConsume = 0;
        FrameLayout.LayoutParams headerLp = (FrameLayout.LayoutParams)this.mHeaderView.getLayoutParams();
        int minOffset = this.getMiniOffset();
        if (dyUnConsumed > 0) {
            canConsume = Math.min(this.mHeaderView.getTop() - minOffset, dyUnConsumed);
        } else if (dyUnConsumed < 0) {
            canConsume = Math.max(this.mHeaderView.getTop() - headerLp.topMargin, dyUnConsumed);
        }
        if (canConsume != 0) {
            this.mHeaderViewOffsetHelper.setTopAndBottomOffset(this.mHeaderViewOffsetHelper.getTopAndBottomOffset() - canConsume);
            this.mContentViewOffsetHelper.setTopAndBottomOffset(this.mContentViewOffsetHelper.getTopAndBottomOffset() - canConsume);
        }
        this.mOnScrollNotifier.notify(-this.mHeaderViewOffsetHelper.getTopAndBottomOffset(), this.mHeaderView.getHeight() + ((IQMUIContinuousNestedBottomView)this.mContentView).getScrollOffsetRange());
        return dyUnConsumed - canConsume;
    }

    @Override
    public void consumeScroll(int dy) {
        if (dy == Integer.MAX_VALUE) {
            this.offsetBy(dy);
            ((IQMUIContinuousNestedBottomView)this.mContentView).consumeScroll(Integer.MAX_VALUE);
            return;
        }
        if (dy == Integer.MIN_VALUE) {
            ((IQMUIContinuousNestedBottomView)this.mContentView).consumeScroll(Integer.MIN_VALUE);
            this.offsetBy(dy);
            return;
        }
        ((IQMUIContinuousNestedBottomView)this.mContentView).consumeScroll(dy);
    }

    @Override
    public void smoothScrollYBy(int dy, int duration) {
        ((IQMUIContinuousNestedBottomView)this.mContentView).smoothScrollYBy(dy, duration);
    }

    @Override
    public void stopScroll() {
        ((IQMUIContinuousNestedBottomView)this.mContentView).stopScroll();
    }

    @Override
    public int getCurrentScroll() {
        return -this.mHeaderViewOffsetHelper.getTopAndBottomOffset() + ((IQMUIContinuousNestedBottomView)this.mContentView).getCurrentScroll();
    }

    @Override
    public int getScrollOffsetRange() {
        if (this.getContentHeight() != -1) {
            return 0;
        }
        return this.mHeaderView.getHeight() - this.getHeaderStickyHeight() + ((IQMUIContinuousNestedBottomView)this.mContentView).getScrollOffsetRange();
    }

    @Override
    public void injectScrollNotifier(final IQMUIContinuousNestedScrollCommon.OnScrollNotifier notifier) {
        this.mOnScrollNotifier = notifier;
        if (this.mContentView instanceof IQMUIContinuousNestedBottomView) {
            ((IQMUIContinuousNestedBottomView)this.mContentView).injectScrollNotifier(new IQMUIContinuousNestedScrollCommon.OnScrollNotifier(){

                @Override
                public void notify(int innerOffset, int innerRange) {
                    notifier.notify(innerOffset - QMUIContinuousNestedBottomDelegateLayout.this.mHeaderView.getTop(), innerRange + QMUIContinuousNestedBottomDelegateLayout.this.mHeaderView.getHeight());
                }

                @Override
                public void onScrollStateChange(View view, int newScrollState) {
                    notifier.onScrollStateChange(view, newScrollState);
                }
            });
        }
    }

    @Override
    public void saveScrollInfo(@NonNull Bundle bundle) {
        bundle.putInt(KEY_SCROLL_INFO_OFFSET, this.mHeaderViewOffsetHelper.getTopAndBottomOffset());
        if (this.mContentView != null) {
            ((IQMUIContinuousNestedBottomView)this.mContentView).saveScrollInfo(bundle);
        }
    }

    @Override
    public void restoreScrollInfo(@NonNull Bundle bundle) {
        int offset = bundle.getInt(KEY_SCROLL_INFO_OFFSET, 0);
        offset = QMUILangHelper.constrain(offset, this.getMiniOffset(), 0);
        this.mHeaderViewOffsetHelper.setTopAndBottomOffset(offset);
        this.mContentViewOffsetHelper.setTopAndBottomOffset(offset);
        if (this.mContentView != null) {
            ((IQMUIContinuousNestedBottomView)this.mContentView).restoreScrollInfo(bundle);
        }
    }

    public boolean startNestedScroll(int axes, int type) {
        return this.mChildHelper.startNestedScroll(axes, type);
    }

    public void stopNestedScroll(int type) {
        this.mChildHelper.stopNestedScroll(type);
    }

    public boolean hasNestedScrollingParent(int type) {
        return this.mChildHelper.hasNestedScrollingParent(type);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, type);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow, int type) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, type);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.startNestedScroll(axes, 0);
    }

    public void stopNestedScroll() {
        this.stopNestedScroll(0);
    }

    public boolean hasNestedScrollingParent() {
        return this.hasNestedScrollingParent(0);
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow, 0);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow, 0);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int axes, int type) {
        return (axes & 2) != 0;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes, int type) {
        this.mParentHelper.onNestedScrollAccepted(child, target, axes, type);
        this.startNestedScroll(2, type);
    }

    public void onStopNestedScroll(@NonNull View target, int type) {
        this.mParentHelper.onStopNestedScroll(target, type);
        this.stopNestedScroll(type);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        int remain = this.offsetBy(dyUnconsumed);
        this.dispatchNestedScroll(0, dyUnconsumed - remain, 0, remain, null, type);
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        this.dispatchNestedPreScroll(dx, dy, consumed, null, type);
        int unconsumed = dy - consumed[1];
        if (unconsumed > 0) {
            consumed[1] = consumed[1] + (unconsumed - this.offsetBy(unconsumed));
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.onStartNestedScroll(child, target, nestedScrollAxes, 0);
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.onNestedScrollAccepted(child, target, nestedScrollAxes, 0);
    }

    public void onStopNestedScroll(View target) {
        this.onStopNestedScroll(target, 0);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, 0);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.onNestedPreScroll(target, dx, dy, consumed, 0);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed) {
            this.mViewFlinger.fling((int)velocityY);
            return true;
        }
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    private boolean isPointInHeaderBounds(int x, int y) {
        QMUIViewHelper.getDescendantRect((ViewGroup)this, this.mHeaderView, this.mTempRect);
        return this.mTempRect.contains(x, y);
    }

    private void ensureVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action;
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        }
        if ((action = ev.getAction()) == 2 && this.isBeingDragged) {
            return true;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.mViewFlinger.stop();
                this.isBeingDragged = false;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (!this.isPointInHeaderBounds(x, y)) break;
                this.lastMotionY = y;
                this.activePointerId = ev.getPointerId(0);
                this.startNestedScroll(2, 0);
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                return actionIndex != 0 && !this.isPointInHeaderBounds((int)ev.getX(), (int)ev.getY()) && this.isPointInHeaderBounds((int)ev.getX(actionIndex), (int)ev.getY(actionIndex));
            }
            case 2: {
                int y;
                int yDiff;
                int pointerIndex;
                int activePointerId = this.activePointerId;
                if (activePointerId == -1 || (pointerIndex = ev.findPointerIndex(activePointerId)) == -1 || (yDiff = Math.abs((y = (int)ev.getY(pointerIndex)) - this.lastMotionY)) <= this.touchSlop) break;
                this.isBeingDragged = true;
                this.lastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                this.isBeingDragged = false;
                this.activePointerId = -1;
                this.stopNestedScroll(0);
            }
        }
        return this.isBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        }
        if (ev.getAction() == 0) {
            this.mNestedOffsetY = 0;
        }
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)ev);
        vtev.offsetLocation(0.0f, (float)this.mNestedOffsetY);
        switch (ev.getActionMasked()) {
            case 0: {
                this.mViewFlinger.stop();
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (this.isPointInHeaderBounds(x, y)) {
                    this.lastMotionY = y;
                    this.activePointerId = ev.getPointerId(0);
                    this.ensureVelocityTracker();
                    this.startNestedScroll(2, 0);
                    break;
                }
                return false;
            }
            case 2: {
                int unconsumed;
                int activePointerIndex = ev.findPointerIndex(this.activePointerId);
                if (activePointerIndex == -1) {
                    return false;
                }
                int y = (int)ev.getY(activePointerIndex);
                int dy = this.lastMotionY - y;
                if (!this.isBeingDragged && Math.abs(dy) > this.touchSlop) {
                    this.isBeingDragged = true;
                    dy = dy > 0 ? (dy -= this.touchSlop) : (dy += this.touchSlop);
                }
                if (!this.isBeingDragged) break;
                this.lastMotionY = y;
                if (dy < 0 && ((IQMUIContinuousNestedBottomView)this.mContentView).getCurrentScroll() > 0) {
                    return true;
                }
                this.mScrollConsumed[0] = 0;
                this.mScrollConsumed[1] = 0;
                if (this.dispatchNestedPreScroll(0, dy, this.mScrollConsumed, this.mScrollOffset)) {
                    dy -= this.mScrollConsumed[1];
                    this.lastMotionY = y - this.mScrollOffset[1];
                    vtev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedOffsetY += this.mScrollOffset[1];
                }
                if (!this.dispatchNestedScroll(0, dy - (unconsumed = this.offsetBy(dy)), 0, unconsumed, this.mScrollOffset, 0)) break;
                this.lastMotionY = y - this.mScrollOffset[1];
                vtev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                this.mNestedOffsetY += this.mScrollOffset[1];
                break;
            }
            case 1: {
                if (this.velocityTracker != null) {
                    this.velocityTracker.addMovement(vtev);
                    this.velocityTracker.computeCurrentVelocity(1000);
                    int yvel = -((int)(this.velocityTracker.getYVelocity(this.activePointerId) + 0.5f));
                    this.mViewFlinger.fling(yvel);
                }
            }
            case 3: {
                this.isBeingDragged = false;
                this.activePointerId = -1;
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                }
                this.stopNestedScroll(0);
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    class ViewFlinger
    implements Runnable {
        private int mLastFlingY;
        OverScroller mOverScroller;
        Interpolator mInterpolator = QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR;
        private boolean mEatRunOnAnimationRequest = false;
        private boolean mReSchedulePostAnimationCallback = false;

        ViewFlinger() {
            this.mOverScroller = new OverScroller(QMUIContinuousNestedBottomDelegateLayout.this.getContext(), QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR);
        }

        @Override
        public void run() {
            this.mReSchedulePostAnimationCallback = false;
            this.mEatRunOnAnimationRequest = true;
            OverScroller scroller = this.mOverScroller;
            if (scroller.computeScrollOffset()) {
                boolean canScroll;
                int y = scroller.getCurrY();
                int unconsumedY = y - this.mLastFlingY;
                this.mLastFlingY = y;
                IQMUIContinuousNestedBottomView bottomView = (IQMUIContinuousNestedBottomView)QMUIContinuousNestedBottomDelegateLayout.this.mContentView;
                boolean bl = canScroll = unconsumedY <= 0 || bottomView.getCurrentScroll() < bottomView.getScrollOffsetRange();
                if (canScroll) {
                    if (!QMUIContinuousNestedBottomDelegateLayout.this.mChildHelper.hasNestedScrollingParent(1)) {
                        QMUIContinuousNestedBottomDelegateLayout.this.startNestedScroll(2, 1);
                    }
                    QMUIContinuousNestedBottomDelegateLayout.this.consumeScroll(unconsumedY);
                    this.postOnAnimation();
                } else {
                    this.stop();
                }
            }
            this.mEatRunOnAnimationRequest = false;
            if (this.mReSchedulePostAnimationCallback) {
                this.internalPostOnAnimation();
            } else {
                QMUIContinuousNestedBottomDelegateLayout.this.stopNestedScroll(1);
            }
        }

        void postOnAnimation() {
            if (this.mEatRunOnAnimationRequest) {
                this.mReSchedulePostAnimationCallback = true;
            } else {
                this.internalPostOnAnimation();
            }
        }

        private void internalPostOnAnimation() {
            QMUIContinuousNestedBottomDelegateLayout.this.removeCallbacks(this);
            ViewCompat.postOnAnimation((View)QMUIContinuousNestedBottomDelegateLayout.this, (Runnable)this);
        }

        public void fling(int velocityY) {
            QMUIContinuousNestedBottomDelegateLayout.this.startNestedScroll(2, 1);
            this.mLastFlingY = 0;
            if (this.mInterpolator != QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR) {
                this.mInterpolator = QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR;
                this.mOverScroller = new OverScroller(QMUIContinuousNestedBottomDelegateLayout.this.getContext(), QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR);
            }
            this.mOverScroller.fling(0, 0, 0, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.postOnAnimation();
        }

        public void stop() {
            QMUIContinuousNestedBottomDelegateLayout.this.removeCallbacks(this);
            this.mOverScroller.abortAnimation();
        }
    }
}

