/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.recyclerView;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.recyclerView.QMUISwipeAction;
import com.qmuiteam.qmui.recyclerView.QMUISwipeViewHolder;
import java.util.ArrayList;
import java.util.List;

public class QMUIRVItemSwipeAction
extends RecyclerView.ItemDecoration
implements RecyclerView.OnChildAttachStateChangeListener {
    public static final int SWIPE_NONE = 0;
    public static final int SWIPE_LEFT = 1;
    public static final int SWIPE_RIGHT = 2;
    public static final int SWIPE_UP = 3;
    public static final int SWIPE_DOWN = 4;
    public static final int ANIMATION_TYPE_SWIPE_SUCCESS = 1;
    public static final int ANIMATION_TYPE_SWIPE_CANCEL = 2;
    public static final int ANIMATION_TYPE_SWIPE_ACTION = 3;
    private static final int ACTIVE_POINTER_ID_NONE = -1;
    private static final int PIXELS_PER_SECOND = 1000;
    private static final int SWIPE_TRIGGERED_IMMEDIATELY = -1;
    private static final String TAG = "QMUIRVItemSwipeAction";
    private static final boolean DEBUG = false;
    final List<View> mPendingCleanup = new ArrayList<View>();
    private final float[] mTmpPosition = new float[2];
    float mInitialTouchX;
    float mInitialTouchY;
    long mDownTimeMillis = 0L;
    private float mSwipeEscapeVelocity;
    private float mMaxSwipeVelocity;
    float mDx;
    float mDy;
    int mActivePointerId = -1;
    List<RecoverAnimation> mRecoverAnimations = new ArrayList<RecoverAnimation>();
    private int mSlop;
    RecyclerView mRecyclerView;
    VelocityTracker mVelocityTracker;
    private long mPressTimeToSwipe = -1L;
    float mSelectedStartX;
    float mSelectedStartY;
    int mSwipeDirection;
    private MotionEvent mCurrentDownEvent;
    private Runnable mLongPressToSwipe = new Runnable(){

        @Override
        public void run() {
            int activePointerIndex;
            if (QMUIRVItemSwipeAction.this.mCurrentDownEvent != null && (activePointerIndex = QMUIRVItemSwipeAction.this.mCurrentDownEvent.findPointerIndex(QMUIRVItemSwipeAction.this.mActivePointerId)) >= 0) {
                QMUIRVItemSwipeAction.this.checkSelectForSwipe(QMUIRVItemSwipeAction.this.mCurrentDownEvent.getAction(), QMUIRVItemSwipeAction.this.mCurrentDownEvent, activePointerIndex, true);
            }
        }
    };
    RecyclerView.ViewHolder mSelected = null;
    private final RecyclerView.OnItemTouchListener mOnItemTouchListener = new RecyclerView.OnItemTouchListener(){

        /*
         * Enabled aggressive block sorting
         */
        public boolean onInterceptTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent event) {
            block14: {
                int index;
                int action;
                block15: {
                    block16: {
                        action = event.getActionMasked();
                        if (action != 0) break block15;
                        if (QMUIRVItemSwipeAction.this.mCurrentDownEvent != null) {
                            QMUIRVItemSwipeAction.this.mCurrentDownEvent.recycle();
                        }
                        QMUIRVItemSwipeAction.this.mCurrentDownEvent = MotionEvent.obtain((MotionEvent)event);
                        if (QMUIRVItemSwipeAction.this.mPressTimeToSwipe > 0L && QMUIRVItemSwipeAction.this.mSelected == null) {
                            recyclerView.postDelayed(QMUIRVItemSwipeAction.this.mLongPressToSwipe, QMUIRVItemSwipeAction.this.mPressTimeToSwipe);
                        }
                        QMUIRVItemSwipeAction.this.mActivePointerId = event.getPointerId(0);
                        QMUIRVItemSwipeAction.this.mInitialTouchX = event.getX();
                        QMUIRVItemSwipeAction.this.mInitialTouchY = event.getY();
                        QMUIRVItemSwipeAction.this.obtainVelocityTracker();
                        QMUIRVItemSwipeAction.this.mDownTimeMillis = System.currentTimeMillis();
                        if (QMUIRVItemSwipeAction.this.mSelected != null) break block16;
                        RecoverAnimation animation = QMUIRVItemSwipeAction.this.findAnimation(event);
                        if (animation != null) {
                            QMUIRVItemSwipeAction.this.mInitialTouchX -= animation.mX;
                            QMUIRVItemSwipeAction.this.mInitialTouchY -= animation.mY;
                            QMUIRVItemSwipeAction.this.endRecoverAnimation(animation.mViewHolder, true);
                            if (QMUIRVItemSwipeAction.this.mPendingCleanup.remove(animation.mViewHolder.itemView)) {
                                QMUIRVItemSwipeAction.this.mCallback.clearView(QMUIRVItemSwipeAction.this.mRecyclerView, animation.mViewHolder);
                            }
                            QMUIRVItemSwipeAction.this.select(animation.mViewHolder);
                            QMUIRVItemSwipeAction.this.updateDxDy(event, QMUIRVItemSwipeAction.this.mSwipeDirection, 0);
                        }
                        break block14;
                    }
                    if (QMUIRVItemSwipeAction.this.mSelected instanceof QMUISwipeViewHolder) {
                        QMUISwipeViewHolder swipeViewHolder = (QMUISwipeViewHolder)QMUIRVItemSwipeAction.this.mSelected;
                        boolean isDownToAction = swipeViewHolder.checkDown(QMUIRVItemSwipeAction.this.mInitialTouchX, QMUIRVItemSwipeAction.this.mInitialTouchY);
                        if (!isDownToAction) {
                            if (!QMUIRVItemSwipeAction.hitTest(QMUIRVItemSwipeAction.this.mSelected.itemView, QMUIRVItemSwipeAction.this.mInitialTouchX, QMUIRVItemSwipeAction.this.mInitialTouchY, QMUIRVItemSwipeAction.this.mSelectedStartX + QMUIRVItemSwipeAction.this.mDx, QMUIRVItemSwipeAction.this.mSelectedStartY + QMUIRVItemSwipeAction.this.mDy)) {
                                QMUIRVItemSwipeAction.this.select(null);
                                return true;
                            }
                            QMUIRVItemSwipeAction.this.mInitialTouchX -= QMUIRVItemSwipeAction.this.mDx;
                            QMUIRVItemSwipeAction.this.mInitialTouchY -= QMUIRVItemSwipeAction.this.mDy;
                            break block14;
                        } else {
                            QMUIRVItemSwipeAction.this.mInitialTouchX -= QMUIRVItemSwipeAction.this.mDx;
                            QMUIRVItemSwipeAction.this.mInitialTouchY -= QMUIRVItemSwipeAction.this.mDy;
                        }
                    }
                    break block14;
                }
                if (action == 3) {
                    QMUIRVItemSwipeAction.this.mActivePointerId = -1;
                    QMUIRVItemSwipeAction.this.mRecyclerView.removeCallbacks(QMUIRVItemSwipeAction.this.mLongPressToSwipe);
                    QMUIRVItemSwipeAction.this.select(null);
                } else if (action == 1) {
                    QMUIRVItemSwipeAction.this.mRecyclerView.removeCallbacks(QMUIRVItemSwipeAction.this.mLongPressToSwipe);
                    QMUIRVItemSwipeAction.this.handleActionUp(event.getX(), event.getY(), QMUIRVItemSwipeAction.this.mSlop);
                    QMUIRVItemSwipeAction.this.mActivePointerId = -1;
                } else if (QMUIRVItemSwipeAction.this.mActivePointerId != -1 && (index = event.findPointerIndex(QMUIRVItemSwipeAction.this.mActivePointerId)) >= 0) {
                    QMUIRVItemSwipeAction.this.checkSelectForSwipe(action, event, index, false);
                }
            }
            if (QMUIRVItemSwipeAction.this.mVelocityTracker != null) {
                QMUIRVItemSwipeAction.this.mVelocityTracker.addMovement(event);
            }
            if (QMUIRVItemSwipeAction.this.mSelected == null) return false;
            return true;
        }

        public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent event) {
            RecyclerView.ViewHolder viewHolder;
            if (QMUIRVItemSwipeAction.this.mVelocityTracker != null) {
                QMUIRVItemSwipeAction.this.mVelocityTracker.addMovement(event);
            }
            if (QMUIRVItemSwipeAction.this.mActivePointerId == -1) {
                return;
            }
            int action = event.getActionMasked();
            int activePointerIndex = event.findPointerIndex(QMUIRVItemSwipeAction.this.mActivePointerId);
            if (activePointerIndex >= 0) {
                QMUIRVItemSwipeAction.this.checkSelectForSwipe(action, event, activePointerIndex, false);
            }
            if ((viewHolder = QMUIRVItemSwipeAction.this.mSelected) == null) {
                return;
            }
            switch (action) {
                case 2: {
                    if (activePointerIndex < 0) break;
                    QMUIRVItemSwipeAction.this.updateDxDy(event, QMUIRVItemSwipeAction.this.mSwipeDirection, activePointerIndex);
                    QMUIRVItemSwipeAction.this.mRecyclerView.invalidate();
                    float x = event.getX(activePointerIndex);
                    float y = event.getY(activePointerIndex);
                    if (!(Math.abs(x - QMUIRVItemSwipeAction.this.mInitialTouchX) > (float)QMUIRVItemSwipeAction.this.mSlop) && !(Math.abs(y - QMUIRVItemSwipeAction.this.mInitialTouchY) > (float)QMUIRVItemSwipeAction.this.mSlop)) break;
                    QMUIRVItemSwipeAction.this.mRecyclerView.removeCallbacks(QMUIRVItemSwipeAction.this.mLongPressToSwipe);
                    break;
                }
                case 3: {
                    QMUIRVItemSwipeAction.this.mRecyclerView.removeCallbacks(QMUIRVItemSwipeAction.this.mLongPressToSwipe);
                    QMUIRVItemSwipeAction.this.select(null);
                    if (QMUIRVItemSwipeAction.this.mVelocityTracker != null) {
                        QMUIRVItemSwipeAction.this.mVelocityTracker.clear();
                    }
                    QMUIRVItemSwipeAction.this.mActivePointerId = -1;
                    break;
                }
                case 1: {
                    QMUIRVItemSwipeAction.this.mRecyclerView.removeCallbacks(QMUIRVItemSwipeAction.this.mLongPressToSwipe);
                    QMUIRVItemSwipeAction.this.handleActionUp(event.getX(), event.getY(), QMUIRVItemSwipeAction.this.mSlop);
                    if (QMUIRVItemSwipeAction.this.mVelocityTracker != null) {
                        QMUIRVItemSwipeAction.this.mVelocityTracker.clear();
                    }
                    QMUIRVItemSwipeAction.this.mActivePointerId = -1;
                    break;
                }
                case 6: {
                    int pointerIndex = event.getActionIndex();
                    int pointerId = event.getPointerId(pointerIndex);
                    if (pointerId != QMUIRVItemSwipeAction.this.mActivePointerId) break;
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    QMUIRVItemSwipeAction.this.mActivePointerId = event.getPointerId(newPointerIndex);
                    QMUIRVItemSwipeAction.this.updateDxDy(event, QMUIRVItemSwipeAction.this.mSwipeDirection, pointerIndex);
                    break;
                }
            }
        }

        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            if (!disallowIntercept) {
                return;
            }
            QMUIRVItemSwipeAction.this.select(null);
        }
    };
    private Callback mCallback;
    private boolean mSwipeDeleteWhenOnlyOneAction = false;

    public QMUIRVItemSwipeAction(boolean swipeDeleteWhenOnlyOneAction, Callback callback) {
        this.mCallback = callback;
        this.mSwipeDeleteWhenOnlyOneAction = swipeDeleteWhenOnlyOneAction;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        if (this.mRecyclerView == recyclerView) {
            return;
        }
        if (this.mRecyclerView != null) {
            this.destroyCallbacks();
        }
        this.mRecyclerView = recyclerView;
        if (recyclerView != null) {
            Resources resources = recyclerView.getResources();
            this.mSwipeEscapeVelocity = resources.getDimension(R.dimen.qmui_rv_swipe_action_escape_velocity);
            this.mMaxSwipeVelocity = resources.getDimension(R.dimen.qmui_rv_swipe_action_escape_max_velocity);
            this.setupCallbacks();
        }
    }

    public void setPressTimeToSwipe(long pressTimeToSwipe) {
        this.mPressTimeToSwipe = pressTimeToSwipe;
    }

    private void setupCallbacks() {
        ViewConfiguration vc = ViewConfiguration.get((Context)this.mRecyclerView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)this);
        this.mRecyclerView.addOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.addOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this);
    }

    private void destroyCallbacks() {
        this.mRecyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this);
        this.mRecyclerView.removeOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.removeOnChildAttachStateChangeListener((RecyclerView.OnChildAttachStateChangeListener)this);
        int recoverAnimSize = this.mRecoverAnimations.size();
        for (int i = recoverAnimSize - 1; i >= 0; --i) {
            RecoverAnimation recoverAnimation = this.mRecoverAnimations.get(0);
            this.mCallback.clearView(this.mRecyclerView, recoverAnimation.mViewHolder);
        }
        this.mRecoverAnimations.clear();
        this.releaseVelocityTracker();
    }

    public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.mSelected != null) {
            this.getSelectedDxDy(this.mTmpPosition);
            dx = this.mTmpPosition[0];
            dy = this.mTmpPosition[1];
        }
        this.mCallback.onDrawOver(c, parent, this.mSelected, this.mRecoverAnimations, dx, dy);
    }

    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.mSelected != null) {
            this.getSelectedDxDy(this.mTmpPosition);
            dx = this.mTmpPosition[0];
            dy = this.mTmpPosition[1];
        }
        this.mCallback.onDraw(c, parent, this.mSelected, this.mRecoverAnimations, dx, dy, this.mSwipeDirection);
    }

    public void onChildViewAttachedToWindow(@NonNull View view) {
    }

    public void onChildViewDetachedFromWindow(@NonNull View view) {
        RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(view);
        if (holder == null) {
            return;
        }
        if (this.mSelected != null && holder == this.mSelected) {
            this.select(null);
        } else {
            this.endRecoverAnimation(holder, false);
            if (this.mPendingCleanup.remove(holder.itemView)) {
                this.mCallback.clearView(this.mRecyclerView, holder);
            }
        }
    }

    void updateDxDy(MotionEvent ev, int swipeDirection, int pointerIndex) {
        float x = ev.getX(pointerIndex);
        float y = ev.getY(pointerIndex);
        if (swipeDirection == 2) {
            this.mDx = Math.max(0.0f, x - this.mInitialTouchX);
            this.mDy = 0.0f;
        } else if (swipeDirection == 1) {
            this.mDx = Math.min(0.0f, x - this.mInitialTouchX);
            this.mDy = 0.0f;
        } else if (swipeDirection == 4) {
            this.mDx = 0.0f;
            this.mDy = Math.max(0.0f, y - this.mInitialTouchY);
        } else if (swipeDirection == 3) {
            this.mDx = 0.0f;
            this.mDy = Math.min(0.0f, y - this.mInitialTouchY);
        }
    }

    void checkSelectForSwipe(int action, MotionEvent motionEvent, int pointerIndex, boolean isLongPressToSwipe) {
        if (this.mSelected != null || this.mPressTimeToSwipe == -1L && action != 2) {
            return;
        }
        if (this.mRecyclerView.getScrollState() == 1) {
            return;
        }
        RecyclerView.ViewHolder vh = this.findSwipedView(motionEvent, isLongPressToSwipe);
        if (vh == null) {
            return;
        }
        int swipeDirection = this.mCallback.getSwipeDirection(this.mRecyclerView, vh);
        if (swipeDirection == 0) {
            return;
        }
        if (this.mPressTimeToSwipe == -1L) {
            float x = motionEvent.getX(pointerIndex);
            float y = motionEvent.getY(pointerIndex);
            float dx = x - this.mInitialTouchX;
            float dy = y - this.mInitialTouchY;
            float absDx = Math.abs(dx);
            float absDy = Math.abs(dy);
            if (swipeDirection == 1 ? absDx < (float)this.mSlop || dx >= 0.0f : (swipeDirection == 2 ? absDx < (float)this.mSlop || dx <= 0.0f : (swipeDirection == 3 ? absDy < (float)this.mSlop || dy >= 0.0f : swipeDirection == 4 && (absDy < (float)this.mSlop || dy <= 0.0f)))) {
                return;
            }
        } else if (this.mPressTimeToSwipe >= System.currentTimeMillis() - this.mDownTimeMillis) {
            return;
        }
        this.mRecyclerView.removeCallbacks(this.mLongPressToSwipe);
        this.mDy = 0.0f;
        this.mDx = 0.0f;
        this.mActivePointerId = motionEvent.getPointerId(0);
        MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        cancelEvent.setAction(3);
        vh.itemView.dispatchTouchEvent(cancelEvent);
        cancelEvent.recycle();
        this.select(vh);
    }

    public void clear() {
        this.select(null, false);
    }

    void handleActionUp(float x, float y, int touchSlop) {
        if (this.mSelected != null) {
            if (this.mSelected instanceof QMUISwipeViewHolder) {
                QMUISwipeViewHolder swipeViewHolder = (QMUISwipeViewHolder)this.mSelected;
                if (!swipeViewHolder.hasAction()) {
                    this.select(null, true);
                } else if (swipeViewHolder.mSwipeActions.size() == 1 && this.mSwipeDeleteWhenOnlyOneAction) {
                    if (this.mCallback.isOverThreshold(this.mRecyclerView, this.mSelected, this.mDx, this.mDy, this.mSwipeDirection)) {
                        this.select(null, true);
                    } else {
                        this.handleSwipeActionActionUp(swipeViewHolder, x, y, touchSlop);
                    }
                } else {
                    this.handleSwipeActionActionUp(swipeViewHolder, x, y, touchSlop);
                }
            } else {
                this.select(null, true);
            }
        }
    }

    void handleSwipeActionActionUp(QMUISwipeViewHolder swipeViewHolder, float x, float y, int touchSlop) {
        QMUISwipeAction action = swipeViewHolder.checkUp(x, y, touchSlop);
        if (action != null) {
            this.mCallback.onClickAction(this, this.mSelected, action);
            swipeViewHolder.clearTouchInfo();
            return;
        }
        swipeViewHolder.clearTouchInfo();
        int swipeDir = this.checkSwipe(this.mSelected, this.mSwipeDirection, true);
        if (swipeDir == 0) {
            this.select(null, true);
        } else {
            float targetTranslateX;
            float targetTranslateY;
            this.getSelectedDxDy(this.mTmpPosition);
            float currentTranslateX = this.mTmpPosition[0];
            float currentTranslateY = this.mTmpPosition[1];
            switch (swipeDir) {
                case 1: {
                    targetTranslateY = 0.0f;
                    targetTranslateX = -swipeViewHolder.mActionTotalWidth;
                    break;
                }
                case 2: {
                    targetTranslateY = 0.0f;
                    targetTranslateX = swipeViewHolder.mActionTotalWidth;
                    break;
                }
                case 3: {
                    targetTranslateX = 0.0f;
                    targetTranslateY = -swipeViewHolder.mActionTotalHeight;
                    break;
                }
                case 4: {
                    targetTranslateX = 0.0f;
                    targetTranslateY = swipeViewHolder.mActionTotalHeight;
                    break;
                }
                default: {
                    targetTranslateX = 0.0f;
                    targetTranslateY = 0.0f;
                }
            }
            this.mDx += targetTranslateX - currentTranslateX;
            this.mDy += targetTranslateY - currentTranslateY;
            RecoverAnimation rv = new RecoverAnimation(swipeViewHolder, currentTranslateX, currentTranslateY, targetTranslateX, targetTranslateY, this.mCallback.getInterpolator(3));
            long duration = this.mCallback.getAnimationDuration(this.mRecyclerView, 3, targetTranslateX - currentTranslateX, targetTranslateY - currentTranslateY);
            rv.setDuration(duration);
            this.mRecoverAnimations.add(rv);
            rv.start();
            this.mRecyclerView.invalidate();
        }
    }

    void select(@Nullable RecyclerView.ViewHolder selected) {
        this.select(selected, false);
    }

    void select(@Nullable RecyclerView.ViewHolder selected, boolean isActionUp) {
        ViewParent rvParent;
        if (selected == this.mSelected) {
            return;
        }
        this.endRecoverAnimation(selected, true);
        boolean preventLayout = false;
        if (this.mSelected != null) {
            final RecyclerView.ViewHolder prevSelected = this.mSelected;
            if (prevSelected.itemView.getParent() != null) {
                int animType;
                float targetTranslateX;
                float targetTranslateY;
                this.endRecoverAnimation(prevSelected, true);
                final int swipeDir = isActionUp ? this.checkSwipe(this.mSelected, this.mSwipeDirection, false) : 0;
                this.getSelectedDxDy(this.mTmpPosition);
                float currentTranslateX = this.mTmpPosition[0];
                float currentTranslateY = this.mTmpPosition[1];
                switch (swipeDir) {
                    case 1: 
                    case 2: {
                        targetTranslateY = 0.0f;
                        targetTranslateX = Math.signum(this.mDx) * (float)this.mRecyclerView.getWidth();
                        break;
                    }
                    case 3: 
                    case 4: {
                        targetTranslateX = 0.0f;
                        targetTranslateY = Math.signum(this.mDy) * (float)this.mRecyclerView.getHeight();
                        break;
                    }
                    default: {
                        targetTranslateX = 0.0f;
                        targetTranslateY = 0.0f;
                    }
                }
                int n = animType = swipeDir > 0 ? 1 : 2;
                if (swipeDir > 0) {
                    this.mCallback.onStartSwipeAnimation(this.mSelected, swipeDir);
                }
                RecoverAnimation rv = new RecoverAnimation(prevSelected, currentTranslateX, currentTranslateY, targetTranslateX, targetTranslateY, this.mCallback.getInterpolator(3)){

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (this.mOverridden) {
                            return;
                        }
                        if (swipeDir == 0) {
                            QMUIRVItemSwipeAction.this.mCallback.clearView(QMUIRVItemSwipeAction.this.mRecyclerView, prevSelected);
                        } else {
                            QMUIRVItemSwipeAction.this.mPendingCleanup.add(prevSelected.itemView);
                            this.mIsPendingCleanup = true;
                            if (swipeDir > 0) {
                                QMUIRVItemSwipeAction.this.postDispatchSwipe(this, swipeDir);
                            }
                        }
                    }
                };
                long duration = this.mCallback.getAnimationDuration(this.mRecyclerView, animType, targetTranslateX - currentTranslateX, targetTranslateY - currentTranslateY);
                rv.setDuration(duration);
                this.mRecoverAnimations.add(rv);
                rv.start();
                preventLayout = true;
            } else {
                this.mCallback.clearView(this.mRecyclerView, prevSelected);
            }
            this.mSelected = null;
        }
        if (selected != null) {
            this.mSwipeDirection = this.mCallback.getSwipeDirection(this.mRecyclerView, selected);
            this.mSelectedStartX = selected.itemView.getLeft();
            this.mSelectedStartY = selected.itemView.getTop();
            this.mSelected = selected;
            if (selected instanceof QMUISwipeViewHolder) {
                QMUISwipeViewHolder qmuiSwipeViewHolder = (QMUISwipeViewHolder)selected;
                qmuiSwipeViewHolder.setup(this.mSwipeDirection, this.mSwipeDeleteWhenOnlyOneAction);
            }
        }
        if ((rvParent = this.mRecyclerView.getParent()) != null) {
            rvParent.requestDisallowInterceptTouchEvent(this.mSelected != null);
        }
        if (!preventLayout) {
            this.mRecyclerView.getLayoutManager().requestSimpleAnimationsInNextLayout();
        }
        this.mCallback.onSelectedChanged(this.mSelected);
        this.mRecyclerView.invalidate();
    }

    private void getSelectedDxDy(float[] outPosition) {
        outPosition[0] = this.mSwipeDirection == 1 || this.mSwipeDirection == 2 ? this.mSelectedStartX + this.mDx - (float)this.mSelected.itemView.getLeft() : this.mSelected.itemView.getTranslationX();
        outPosition[1] = this.mSwipeDirection == 3 || this.mSwipeDirection == 4 ? this.mSelectedStartY + this.mDy - (float)this.mSelected.itemView.getTop() : this.mSelected.itemView.getTranslationY();
    }

    void postDispatchSwipe(final RecoverAnimation anim, final int swipeDir) {
        this.mRecyclerView.post(new Runnable(){

            @Override
            public void run() {
                if (QMUIRVItemSwipeAction.this.mRecyclerView != null && QMUIRVItemSwipeAction.this.mRecyclerView.isAttachedToWindow() && !anim.mOverridden && anim.mViewHolder.getAdapterPosition() != -1) {
                    RecyclerView.ItemAnimator animator = QMUIRVItemSwipeAction.this.mRecyclerView.getItemAnimator();
                    if (!(animator != null && animator.isRunning(null) || QMUIRVItemSwipeAction.this.hasRunningRecoverAnim())) {
                        QMUIRVItemSwipeAction.this.mCallback.onSwiped(anim.mViewHolder, swipeDir);
                    } else {
                        QMUIRVItemSwipeAction.this.mRecyclerView.post((Runnable)this);
                    }
                }
            }
        });
    }

    boolean hasRunningRecoverAnim() {
        int size = this.mRecoverAnimations.size();
        for (int i = 0; i < size; ++i) {
            if (this.mRecoverAnimations.get((int)i).mEnded) continue;
            return true;
        }
        return false;
    }

    private int checkSwipe(RecyclerView.ViewHolder viewHolder, int swipeDirection, boolean checkAction) {
        if (swipeDirection == 1 || swipeDirection == 2) {
            int dirFlag;
            int n = dirFlag = this.mDx > 0.0f ? 2 : 1;
            if (this.mVelocityTracker != null && this.mActivePointerId > -1) {
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mCallback.getSwipeVelocityThreshold(this.mMaxSwipeVelocity));
                float xVelocity = this.mVelocityTracker.getXVelocity(this.mActivePointerId);
                int velDirFlag = xVelocity > 0.0f ? 2 : 1;
                float absXVelocity = Math.abs(xVelocity);
                if (dirFlag == velDirFlag && absXVelocity >= this.mCallback.getSwipeEscapeVelocity(this.mSwipeEscapeVelocity)) {
                    return velDirFlag;
                }
            }
            float threshold = checkAction && viewHolder instanceof QMUISwipeViewHolder ? (float)((QMUISwipeViewHolder)viewHolder).mActionTotalWidth : (float)this.mRecyclerView.getWidth() * this.mCallback.getSwipeThreshold(viewHolder);
            if (Math.abs(this.mDx) >= threshold) {
                return dirFlag;
            }
        } else if (swipeDirection == 3 || swipeDirection == 4) {
            int dirFlag;
            int n = dirFlag = this.mDy > 0.0f ? 4 : 3;
            if (this.mVelocityTracker != null && this.mActivePointerId > -1) {
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mCallback.getSwipeVelocityThreshold(this.mMaxSwipeVelocity));
                float yVelocity = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                int velDirFlag = yVelocity > 0.0f ? 4 : 3;
                float absYVelocity = Math.abs(yVelocity);
                if (velDirFlag == dirFlag && absYVelocity >= this.mCallback.getSwipeEscapeVelocity(this.mSwipeEscapeVelocity)) {
                    return velDirFlag;
                }
            }
            float threshold = checkAction && viewHolder instanceof QMUISwipeViewHolder ? (float)((QMUISwipeViewHolder)viewHolder).mActionTotalHeight : (float)this.mRecyclerView.getHeight() * this.mCallback.getSwipeThreshold(viewHolder);
            if (Math.abs(this.mDy) >= threshold) {
                return dirFlag;
            }
        }
        return 0;
    }

    @Nullable
    private RecyclerView.ViewHolder findSwipedView(MotionEvent motionEvent, boolean isLongPressToSwipe) {
        RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
        if (this.mActivePointerId == -1 || lm == null) {
            return null;
        }
        if (isLongPressToSwipe) {
            View child = this.findChildView(motionEvent);
            if (child == null) {
                return null;
            }
            return this.mRecyclerView.getChildViewHolder(child);
        }
        int pointerIndex = motionEvent.findPointerIndex(this.mActivePointerId);
        float dx = motionEvent.getX(pointerIndex) - this.mInitialTouchX;
        float dy = motionEvent.getY(pointerIndex) - this.mInitialTouchY;
        float absDx = Math.abs(dx);
        float absDy = Math.abs(dy);
        if (absDx < (float)this.mSlop && absDy < (float)this.mSlop) {
            return null;
        }
        if (absDx > absDy && lm.canScrollHorizontally()) {
            return null;
        }
        if (absDy > absDx && lm.canScrollVertically()) {
            return null;
        }
        View child = this.findChildView(motionEvent);
        if (child == null) {
            return null;
        }
        return this.mRecyclerView.getChildViewHolder(child);
    }

    void endRecoverAnimation(RecyclerView.ViewHolder viewHolder, boolean override) {
        int recoverAnimSize = this.mRecoverAnimations.size();
        for (int i = recoverAnimSize - 1; i >= 0; --i) {
            RecoverAnimation anim = this.mRecoverAnimations.get(i);
            if (anim.mViewHolder != viewHolder) continue;
            anim.mOverridden |= override;
            if (!anim.mEnded) {
                anim.cancel();
            }
            this.mRecoverAnimations.remove(i);
            return;
        }
    }

    View findChildView(MotionEvent event) {
        View selectedView;
        float x = event.getX();
        float y = event.getY();
        if (this.mSelected != null && QMUIRVItemSwipeAction.hitTest(selectedView = this.mSelected.itemView, x, y, this.mSelectedStartX + this.mDx, this.mSelectedStartY + this.mDy)) {
            return selectedView;
        }
        for (int i = this.mRecoverAnimations.size() - 1; i >= 0; --i) {
            RecoverAnimation anim = this.mRecoverAnimations.get(i);
            View view = anim.mViewHolder.itemView;
            if (!QMUIRVItemSwipeAction.hitTest(view, x, y, view.getX(), view.getY())) continue;
            return view;
        }
        return this.mRecyclerView.findChildViewUnder(x, y);
    }

    @Nullable
    RecoverAnimation findAnimation(MotionEvent event) {
        if (this.mRecoverAnimations.isEmpty()) {
            return null;
        }
        View target = this.findChildView(event);
        for (int i = this.mRecoverAnimations.size() - 1; i >= 0; --i) {
            RecoverAnimation anim = this.mRecoverAnimations.get(i);
            if (anim.mViewHolder.itemView != target) continue;
            return anim;
        }
        return null;
    }

    void obtainVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = VelocityTracker.obtain();
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private static boolean hitTest(View child, float x, float y, float left, float top) {
        return x >= left && x <= left + (float)child.getWidth() && y >= top && y <= top + (float)child.getHeight();
    }

    public static abstract class Callback {
        public static final int DEFAULT_SWIPE_ANIMATION_DURATION = 250;

        public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            View view = viewHolder.itemView;
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
            if (viewHolder instanceof QMUISwipeViewHolder) {
                ((QMUISwipeViewHolder)viewHolder).clearTouchInfo();
            }
        }

        public int getSwipeDirection(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
            return 0;
        }

        public void onStartSwipeAnimation(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        }

        public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        }

        public float getSwipeThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
            return 0.5f;
        }

        public float getSwipeEscapeVelocity(float defaultValue) {
            return defaultValue;
        }

        public float getSwipeVelocityThreshold(float defaultValue) {
            return defaultValue;
        }

        public long getAnimationDuration(@NonNull RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
            return 250L;
        }

        public void onSelectedChanged(RecyclerView.ViewHolder selected) {
        }

        public void onClickAction(QMUIRVItemSwipeAction swipeAction, RecyclerView.ViewHolder selected, QMUISwipeAction action) {
        }

        public TimeInterpolator getInterpolator(int animationType) {
            return null;
        }

        void onDraw(Canvas c, RecyclerView parent, RecyclerView.ViewHolder selected, List<RecoverAnimation> recoverAnimationList, float dX, float dY, int swipeDirection) {
            int recoverAnimSize = recoverAnimationList.size();
            for (int i = 0; i < recoverAnimSize; ++i) {
                RecoverAnimation anim = recoverAnimationList.get(i);
                anim.update();
                if (anim.mViewHolder == selected) {
                    dX = anim.mX;
                    dY = anim.mY;
                    continue;
                }
                int count = c.save();
                this.onChildDraw(c, parent, anim.mViewHolder, anim.mX, anim.mY, false, swipeDirection);
                c.restoreToCount(count);
            }
            if (selected != null) {
                int count = c.save();
                this.onChildDraw(c, parent, selected, dX, dY, true, swipeDirection);
                c.restoreToCount(count);
            }
        }

        void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.ViewHolder selected, List<RecoverAnimation> recoverAnimationList, float dX, float dY) {
            int recoverAnimSize = recoverAnimationList.size();
            for (int i = 0; i < recoverAnimSize; ++i) {
                RecoverAnimation anim = recoverAnimationList.get(i);
                int count = c.save();
                this.onChildDrawOver(c, parent, anim.mViewHolder, anim.mX, anim.mY, false);
                c.restoreToCount(count);
            }
            if (selected != null) {
                int count = c.save();
                this.onChildDrawOver(c, parent, selected, dX, dY, true);
                c.restoreToCount(count);
            }
            boolean hasRunningAnimation = false;
            for (int i = recoverAnimSize - 1; i >= 0; --i) {
                RecoverAnimation anim = recoverAnimationList.get(i);
                if (anim.mEnded && !anim.mIsPendingCleanup) {
                    recoverAnimationList.remove(i);
                    continue;
                }
                if (anim.mEnded) continue;
                hasRunningAnimation = true;
            }
            if (hasRunningAnimation) {
                parent.invalidate();
            }
        }

        public void onChildDrawOver(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, boolean isCurrentlyActive) {
        }

        protected boolean isOverThreshold(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dx, float dy, int swipeDirection) {
            if (swipeDirection == 1 || swipeDirection == 2) {
                return Math.abs(dx) >= (float)recyclerView.getWidth() * this.getSwipeThreshold(viewHolder);
            }
            return Math.abs(dy) >= (float)recyclerView.getHeight() * this.getSwipeThreshold(viewHolder);
        }

        public void onChildDraw(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, boolean isCurrentlyActive, int swipeDirection) {
            View view = viewHolder.itemView;
            view.setTranslationX(dX);
            view.setTranslationY(dY);
            if (viewHolder instanceof QMUISwipeViewHolder && swipeDirection != 0) {
                ((QMUISwipeViewHolder)viewHolder).draw(c, this.isOverThreshold(recyclerView, viewHolder, dX, dY, swipeDirection), dX, dY);
            }
        }
    }

    private static class RecoverAnimation
    implements Animator.AnimatorListener {
        final float mStartDx;
        final float mStartDy;
        final float mTargetX;
        final float mTargetY;
        final RecyclerView.ViewHolder mViewHolder;
        private final ValueAnimator mValueAnimator;
        boolean mIsPendingCleanup;
        float mX;
        float mY;
        boolean mOverridden = false;
        boolean mEnded = false;
        private float mFraction;

        RecoverAnimation(RecyclerView.ViewHolder viewHolder, float startDx, float startDy, float targetX, float targetY, TimeInterpolator interpolator) {
            this.mViewHolder = viewHolder;
            this.mStartDx = startDx;
            this.mStartDy = startDy;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    this.setFraction(animation.getAnimatedFraction());
                }
            });
            this.mValueAnimator.setTarget((Object)viewHolder.itemView);
            this.mValueAnimator.addListener((Animator.AnimatorListener)this);
            this.mValueAnimator.setInterpolator(interpolator);
            this.setFraction(0.0f);
        }

        public void setDuration(long duration) {
            this.mValueAnimator.setDuration(duration);
        }

        public void start() {
            this.mViewHolder.setIsRecyclable(false);
            this.mValueAnimator.start();
        }

        public void cancel() {
            this.mValueAnimator.cancel();
        }

        public void setFraction(float fraction) {
            this.mFraction = fraction;
        }

        public void update() {
            this.mX = this.mStartDx == this.mTargetX ? this.mViewHolder.itemView.getTranslationX() : this.mStartDx + this.mFraction * (this.mTargetX - this.mStartDx);
            this.mY = this.mStartDy == this.mTargetY ? this.mViewHolder.itemView.getTranslationY() : this.mStartDy + this.mFraction * (this.mTargetY - this.mStartDy);
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            if (!this.mEnded) {
                this.mViewHolder.setIsRecyclable(true);
            }
            this.mEnded = true;
        }

        public void onAnimationCancel(Animator animation) {
            this.setFraction(1.0f);
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

