/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.recyclerView;

import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.QMUIInterpolatorStaticHolder;

public class QMUISwipeAction {
    final String mText;
    Drawable mIcon;
    int mTextSize;
    Typeface mTypeface;
    int mSwipeDirectionMiniSize;
    int mIconTextGap;
    int mTextColor;
    int mTextColorAttr;
    int mBackgroundColor;
    int mBackgroundColorAttr;
    int mIconAttr;
    boolean mUseIconTint;
    int mPaddingStartEnd;
    int mOrientation;
    boolean mReverseDrawOrder;
    TimeInterpolator mSwipeMoveInterpolator;
    int mSwipePxPerMS;
    Paint paint;
    float contentWidth;
    float contentHeight;

    private QMUISwipeAction(ActionBuilder builder) {
        this.mText = builder.mText != null && builder.mText.length() > 0 ? builder.mText : null;
        this.mTextColor = builder.mTextColor;
        this.mTextSize = builder.mTextSize;
        this.mTypeface = builder.mTypeface;
        this.mTextColorAttr = builder.mTextColorAttr;
        this.mIcon = builder.mIcon;
        this.mIconAttr = builder.mIconAttr;
        this.mUseIconTint = builder.mUseIconTint;
        this.mIconTextGap = builder.mIconTextGap;
        this.mBackgroundColor = builder.mBackgroundColor;
        this.mBackgroundColorAttr = builder.mBackgroundColorAttr;
        this.mPaddingStartEnd = builder.mPaddingStartEnd;
        this.mSwipeDirectionMiniSize = builder.mSwipeDirectionMiniSize;
        this.mOrientation = builder.mOrientation;
        this.mReverseDrawOrder = builder.mReverseDrawOrder;
        this.mSwipeMoveInterpolator = builder.mSwipeMoveInterpolator;
        this.mSwipePxPerMS = builder.mSwipePxPerMS;
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTypeface(this.mTypeface);
        this.paint.setTextSize((float)this.mTextSize);
        Paint.FontMetrics fontMetrics = this.paint.getFontMetrics();
        if (this.mIcon != null && this.mText != null) {
            this.mIcon.setBounds(0, 0, this.mIcon.getIntrinsicWidth(), this.mIcon.getIntrinsicHeight());
            if (this.mOrientation == 2) {
                this.contentWidth = (float)(this.mIcon.getIntrinsicWidth() + this.mIconTextGap) + this.paint.measureText(this.mText);
                this.contentHeight = Math.max(fontMetrics.descent - fontMetrics.ascent, (float)this.mIcon.getIntrinsicHeight());
            } else {
                this.contentWidth = Math.max((float)this.mIcon.getIntrinsicWidth(), this.paint.measureText(this.mText));
                this.contentHeight = fontMetrics.descent - fontMetrics.ascent + (float)this.mIconTextGap + (float)this.mIcon.getIntrinsicHeight();
            }
        } else if (this.mIcon != null) {
            this.mIcon.setBounds(0, 0, this.mIcon.getIntrinsicWidth(), this.mIcon.getIntrinsicHeight());
            this.contentWidth = this.mIcon.getIntrinsicWidth();
            this.contentHeight = this.mIcon.getIntrinsicHeight();
        } else if (this.mText != null) {
            this.contentWidth = this.paint.measureText(this.mText);
            this.contentHeight = fontMetrics.descent - fontMetrics.ascent;
        }
    }

    public String getText() {
        return this.mText;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public int getTextColorAttr() {
        return this.mTextColorAttr;
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    public int getIconAttr() {
        return this.mIconAttr;
    }

    public boolean isUseIconTint() {
        return this.mUseIconTint;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getBackgroundColorAttr() {
        return this.mBackgroundColorAttr;
    }

    public int getPaddingStartEnd() {
        return this.mPaddingStartEnd;
    }

    public int getIconTextGap() {
        return this.mIconTextGap;
    }

    public int getSwipeDirectionMiniSize() {
        return this.mSwipeDirectionMiniSize;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    protected void draw(Canvas canvas) {
        if (this.mText != null && this.mIcon != null) {
            if (this.mOrientation == 2) {
                if (this.mReverseDrawOrder) {
                    canvas.drawText(this.mText, 0.0f, (this.contentHeight - this.paint.descent() + this.paint.ascent()) / 2.0f - this.paint.ascent(), this.paint);
                    canvas.save();
                    canvas.translate(this.contentWidth - (float)this.mIcon.getIntrinsicWidth(), (this.contentHeight - (float)this.mIcon.getIntrinsicHeight()) / 2.0f);
                    this.mIcon.draw(canvas);
                    canvas.restore();
                } else {
                    canvas.save();
                    canvas.translate(0.0f, (this.contentHeight - (float)this.mIcon.getIntrinsicHeight()) / 2.0f);
                    this.mIcon.draw(canvas);
                    canvas.restore();
                    canvas.drawText(this.mText, (float)(this.mIcon.getIntrinsicWidth() + this.mIconTextGap), (this.contentHeight - this.paint.descent() + this.paint.ascent()) / 2.0f - this.paint.ascent(), this.paint);
                }
            } else {
                float textWidth = this.paint.measureText(this.mText);
                if (this.mReverseDrawOrder) {
                    canvas.drawText(this.mText, (this.contentWidth - textWidth) / 2.0f, -this.paint.ascent(), this.paint);
                    canvas.save();
                    canvas.translate((this.contentWidth - (float)this.mIcon.getIntrinsicWidth()) / 2.0f, this.contentHeight - (float)this.mIcon.getIntrinsicHeight());
                    this.mIcon.draw(canvas);
                    canvas.restore();
                } else {
                    canvas.save();
                    canvas.translate((this.contentWidth - (float)this.mIcon.getIntrinsicWidth()) / 2.0f, 0.0f);
                    this.mIcon.draw(canvas);
                    canvas.restore();
                    canvas.drawText(this.mText, (this.contentWidth - textWidth) / 2.0f, this.contentHeight - this.paint.descent(), this.paint);
                }
            }
        } else if (this.mIcon != null) {
            this.mIcon.draw(canvas);
        } else if (this.mText != null) {
            canvas.drawText(this.mText, 0.0f, -this.paint.ascent(), this.paint);
        }
    }

    public static class ActionBuilder {
        public static final int VERTICAL = 1;
        public static final int HORIZONTAL = 2;
        String mText;
        Drawable mIcon;
        int mTextSize;
        Typeface mTypeface;
        int mSwipeDirectionMiniSize;
        int mIconTextGap;
        int mTextColor;
        int mTextColorAttr = 0;
        int mBackgroundColor;
        int mBackgroundColorAttr = 0;
        int mIconAttr = 0;
        boolean mUseIconTint = false;
        int mPaddingStartEnd = 0;
        int mOrientation = 1;
        boolean mReverseDrawOrder = false;
        TimeInterpolator mSwipeMoveInterpolator = QMUIInterpolatorStaticHolder.ACCELERATE_INTERPOLATOR;
        int mSwipePxPerMS = 2;

        public ActionBuilder text(String text) {
            this.mText = text;
            return this;
        }

        public ActionBuilder textSize(int textSize) {
            this.mTextSize = textSize;
            return this;
        }

        public ActionBuilder textColor(int textColor) {
            this.mTextColor = textColor;
            return this;
        }

        public ActionBuilder typeface(Typeface typeface) {
            this.mTypeface = typeface;
            return this;
        }

        public ActionBuilder textColorAttr(int textColorAttr) {
            this.mTextColorAttr = textColorAttr;
            return this;
        }

        public ActionBuilder icon(@Nullable Drawable drawable2) {
            this.mIcon = drawable2 == null ? null : drawable2.mutate();
            return this;
        }

        public ActionBuilder iconAttr(int iconAttr) {
            this.mIconAttr = iconAttr;
            return this;
        }

        public ActionBuilder useIconTint(boolean useIconTint) {
            this.mUseIconTint = useIconTint;
            return this;
        }

        public ActionBuilder backgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public ActionBuilder backgroundColorAttr(int backgroundColorAttr) {
            this.mBackgroundColorAttr = backgroundColorAttr;
            return this;
        }

        public ActionBuilder paddingStartEnd(int paddingStartEnd) {
            this.mPaddingStartEnd = paddingStartEnd;
            return this;
        }

        public ActionBuilder iconTextGap(int iconTextGap) {
            this.mIconTextGap = iconTextGap;
            return this;
        }

        public ActionBuilder swipeDirectionMinSize(int minSize) {
            this.mSwipeDirectionMiniSize = minSize;
            return this;
        }

        public ActionBuilder orientation(int orientation) {
            this.mOrientation = orientation;
            return this;
        }

        public ActionBuilder reverseDrawOrder(boolean reverse) {
            this.mReverseDrawOrder = reverse;
            return this;
        }

        public ActionBuilder swipeMoveInterpolator(TimeInterpolator interpolator) {
            this.mSwipeMoveInterpolator = interpolator;
            return this;
        }

        public ActionBuilder swipePxPerMS(int swipePxPerMS) {
            this.mSwipePxPerMS = swipePxPerMS;
            return this;
        }

        public QMUISwipeAction build() {
            return new QMUISwipeAction(this);
        }
    }
}

