/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.recyclerView;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.recyclerView.QMUISwipeAction;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import java.util.ArrayList;
import java.util.List;

public class QMUISwipeViewHolder
extends RecyclerView.ViewHolder {
    List<ActionWrapper> mSwipeActions;
    int mActionTotalWidth = 0;
    int mActionTotalHeight = 0;
    int mSetupDirection = 0;
    ActionWrapper mCurrentTouchAction = null;
    float mActionDownX = 0.0f;
    float mActionDownY = 0.0f;
    private ActionWrapper.Callback mCallback = new ActionWrapper.Callback(){

        @Override
        public void invalidate() {
            ViewParent viewParent = QMUISwipeViewHolder.this.itemView.getParent();
            if (viewParent instanceof RecyclerView) {
                ((RecyclerView)viewParent).invalidate();
            }
        }
    };

    public QMUISwipeViewHolder(@NonNull View itemView) {
        super(itemView);
    }

    public void addSwipeAction(QMUISwipeAction action) {
        if (this.mSwipeActions == null) {
            this.mSwipeActions = new ArrayList<ActionWrapper>();
        }
        ActionWrapper actionWrapper = new ActionWrapper(action, this.mCallback);
        this.mSwipeActions.add(actionWrapper);
    }

    public void clearActions() {
        if (this.mSwipeActions != null) {
            this.mSwipeActions.clear();
        }
    }

    public boolean hasAction() {
        return this.mSwipeActions != null && !this.mSwipeActions.isEmpty();
    }

    public void clearTouchInfo() {
        this.mCurrentTouchAction = null;
        this.mActionDownY = -1.0f;
        this.mActionDownX = -1.0f;
    }

    void setup(int swipeDirection, boolean swipeDeleteIfOnlyOneAction) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        this.mActionTotalWidth = 0;
                        this.mActionTotalHeight = 0;
                        if (this.mSwipeActions == null || this.mSwipeActions.isEmpty()) {
                            return;
                        }
                        this.mSetupDirection = swipeDirection;
                        for (ActionWrapper wrapper : this.mSwipeActions) {
                            QMUISwipeAction action = wrapper.action;
                            if (swipeDirection == 1 || swipeDirection == 2) {
                                wrapper.measureWidth = Math.max((float)action.mSwipeDirectionMiniSize, action.contentWidth + (float)(2 * action.mPaddingStartEnd));
                                wrapper.measureHeight = this.itemView.getHeight();
                                this.mActionTotalWidth = (int)((float)this.mActionTotalWidth + wrapper.measureWidth);
                                continue;
                            }
                            if (swipeDirection != 3 && swipeDirection != 4) continue;
                            wrapper.measureHeight = Math.max((float)action.mSwipeDirectionMiniSize, action.contentHeight + (float)(2 * action.mPaddingStartEnd));
                            wrapper.measureWidth = this.itemView.getWidth();
                            this.mActionTotalHeight = (int)((float)this.mActionTotalHeight + wrapper.measureHeight);
                        }
                        if (this.mSwipeActions.size() == 1 && swipeDeleteIfOnlyOneAction) {
                            this.mSwipeActions.get((int)0).swipeDeleteMode = true;
                        } else {
                            for (ActionWrapper wrapper : this.mSwipeActions) {
                                wrapper.swipeDeleteMode = false;
                            }
                        }
                        if (swipeDirection != 1) break block10;
                        int targetLeft = this.itemView.getRight() - this.mActionTotalWidth;
                        for (ActionWrapper wrapper : this.mSwipeActions) {
                            wrapper.initLeft = this.itemView.getRight();
                            wrapper.initTop = wrapper.targetTop = (float)this.itemView.getTop();
                            wrapper.targetLeft = targetLeft;
                            targetLeft = (int)((float)targetLeft + wrapper.measureWidth);
                        }
                        break block11;
                    }
                    if (swipeDirection != 2) break block12;
                    int targetLeft = 0;
                    for (ActionWrapper wrapper : this.mSwipeActions) {
                        wrapper.initLeft = (float)this.itemView.getLeft() - wrapper.measureWidth;
                        wrapper.initTop = wrapper.targetTop = (float)this.itemView.getTop();
                        wrapper.targetLeft = targetLeft;
                        targetLeft = (int)((float)targetLeft + wrapper.measureWidth);
                    }
                    break block11;
                }
                if (swipeDirection != 3) break block13;
                int targetTop = this.itemView.getBottom() - this.mActionTotalHeight;
                for (ActionWrapper wrapper : this.mSwipeActions) {
                    wrapper.initLeft = wrapper.targetLeft = (float)this.itemView.getLeft();
                    wrapper.initTop = this.itemView.getBottom();
                    wrapper.targetTop = targetTop;
                    targetTop = (int)((float)targetTop + wrapper.measureHeight);
                }
                break block11;
            }
            if (swipeDirection != 4) break block11;
            int targetTop = 0;
            for (ActionWrapper wrapper : this.mSwipeActions) {
                wrapper.initLeft = wrapper.targetLeft = (float)this.itemView.getLeft();
                wrapper.initTop = (float)this.itemView.getTop() - wrapper.measureHeight;
                wrapper.targetTop = targetTop;
                targetTop = (int)((float)targetTop + wrapper.measureHeight);
            }
        }
    }

    boolean checkDown(float x, float y) {
        for (ActionWrapper actionInfo : this.mSwipeActions) {
            if (!actionInfo.hitTest(x, y)) continue;
            this.mCurrentTouchAction = actionInfo;
            this.mActionDownX = x;
            this.mActionDownY = y;
            return true;
        }
        return false;
    }

    QMUISwipeAction checkUp(float x, float y, int touchSlop) {
        if (this.mCurrentTouchAction != null && this.mCurrentTouchAction.hitTest(x, y) && Math.abs(x - this.mActionDownX) < (float)touchSlop && Math.abs(y - this.mActionDownY) < (float)touchSlop) {
            return this.mCurrentTouchAction.action;
        }
        return null;
    }

    void draw(Canvas canvas, boolean overSwipeThreshold, float dx, float dy) {
        float percent;
        if (this.mSwipeActions == null || this.mSwipeActions.isEmpty()) {
            return;
        }
        if (this.mActionTotalWidth > 0) {
            float absDx = Math.abs(dx);
            if (absDx <= (float)this.mActionTotalWidth) {
                percent = absDx / (float)this.mActionTotalWidth;
                for (ActionWrapper actionInfo : this.mSwipeActions) {
                    actionInfo.width = actionInfo.measureWidth;
                    actionInfo.left = actionInfo.initLeft + (actionInfo.targetLeft - actionInfo.initLeft) * percent;
                }
            } else {
                float overDx = absDx - (float)this.mActionTotalWidth;
                float eachOver = overDx / (float)this.mSwipeActions.size();
                float startLeft = dx > 0.0f ? (float)this.itemView.getLeft() : (float)this.itemView.getRight() + dx;
                for (ActionWrapper actionInfo : this.mSwipeActions) {
                    actionInfo.width = actionInfo.measureWidth + eachOver;
                    actionInfo.left = startLeft;
                    startLeft += actionInfo.width;
                }
            }
        } else {
            for (ActionWrapper actionInfo : this.mSwipeActions) {
                actionInfo.width = actionInfo.measureWidth;
                actionInfo.left = actionInfo.initLeft;
            }
        }
        if (this.mActionTotalHeight > 0) {
            float absDy = Math.abs(dy);
            if (absDy <= (float)this.mActionTotalHeight) {
                percent = absDy / (float)this.mActionTotalHeight;
                for (ActionWrapper actionInfo : this.mSwipeActions) {
                    actionInfo.height = actionInfo.measureHeight;
                    actionInfo.top = actionInfo.initTop + (actionInfo.targetTop - actionInfo.initTop) * percent;
                }
            } else {
                float overDy = absDy - (float)this.mActionTotalHeight;
                float eachOver = overDy / (float)this.mSwipeActions.size();
                float startTop = dy > 0.0f ? (float)this.itemView.getTop() : (float)this.itemView.getBottom() + dy;
                for (ActionWrapper actionInfo : this.mSwipeActions) {
                    actionInfo.height = actionInfo.measureHeight + eachOver + 0.5f;
                    actionInfo.top = startTop;
                    startTop += actionInfo.height;
                }
            }
        } else {
            for (ActionWrapper actionInfo : this.mSwipeActions) {
                actionInfo.height = actionInfo.measureHeight;
                actionInfo.top = actionInfo.initTop;
            }
        }
        for (ActionWrapper actionInfo : this.mSwipeActions) {
            actionInfo.draw(canvas, overSwipeThreshold, this.mSetupDirection);
        }
    }

    static class ActionWrapper {
        static int SWIPE_DELETE_BEFORE = 0;
        static int SWIPE_DELETE_ANIMATING_TO_AFTER = 1;
        static int SWIPE_DELETE_ANIMATING_TO_BEFORE = 2;
        static int SWIPE_DELETE_AFTER = 3;
        static int MAX_SWIPE_MOVE_DURATION = 250;
        final QMUISwipeAction action;
        final Callback callback;
        float measureWidth;
        float measureHeight;
        float targetLeft;
        float targetTop;
        float initLeft;
        float initTop;
        float left;
        float top;
        float width;
        float height;
        boolean swipeDeleteMode = false;
        private int swipeDeleteState = SWIPE_DELETE_BEFORE;
        private float currentAnimationProgress = 0.0f;
        private ValueAnimator animator;
        private ValueAnimator.AnimatorUpdateListener listener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                currentAnimationProgress = ((Float)animation.getAnimatedValue()).floatValue();
                callback.invalidate();
            }
        };
        private float lastLeft = -1.0f;
        private float lastTop = -1.0f;
        private float animStartLeft = -1.0f;
        private float animStartTop = -1.0f;

        public ActionWrapper(@NonNull QMUISwipeAction action, @NonNull Callback callback) {
            this.action = action;
            this.callback = callback;
        }

        boolean hitTest(float x, float y) {
            return x > this.left && x < this.left + this.width && y > this.top && y < this.top + this.height;
        }

        void draw(Canvas canvas, boolean overSwipeThreshold, int direction) {
            canvas.save();
            canvas.translate(this.left, this.top);
            this.action.paint.setStyle(Paint.Style.FILL);
            this.action.paint.setColor(this.action.mBackgroundColor);
            canvas.drawRect(0.0f, 0.0f, this.width, this.height, this.action.paint);
            if (!this.swipeDeleteMode) {
                canvas.translate((this.width - this.action.contentWidth) / 2.0f, (this.height - this.action.contentHeight) / 2.0f);
            } else {
                float drawTop;
                float drawLeft;
                float anchorLeft = this.getAnchorDrawLeft(direction);
                float anchorTop = this.getAnchorDrawTop(direction);
                float followLeft = this.getFollowDrawLeft(direction);
                float followTop = this.getFollowDrawTop(direction);
                if (!overSwipeThreshold) {
                    if (this.swipeDeleteState == SWIPE_DELETE_BEFORE) {
                        drawLeft = anchorLeft;
                        drawTop = anchorTop;
                    } else if (this.swipeDeleteState == SWIPE_DELETE_AFTER) {
                        this.swipeDeleteState = SWIPE_DELETE_ANIMATING_TO_BEFORE;
                        drawLeft = followLeft;
                        drawTop = followTop;
                        this.startAnimator(drawLeft, drawTop, anchorLeft, anchorTop, direction);
                    } else if (this.swipeDeleteState == SWIPE_DELETE_ANIMATING_TO_AFTER) {
                        this.swipeDeleteState = SWIPE_DELETE_ANIMATING_TO_BEFORE;
                        drawLeft = this.lastLeft;
                        drawTop = this.lastTop;
                        this.startAnimator(drawLeft, drawTop, anchorLeft, anchorTop, direction);
                    } else {
                        if (this.isVer(direction)) {
                            drawLeft = anchorLeft;
                            drawTop = this.animStartTop + (anchorTop - this.animStartTop) * this.currentAnimationProgress;
                        } else {
                            drawLeft = this.animStartLeft + (anchorLeft - this.animStartLeft) * this.currentAnimationProgress;
                            drawTop = anchorTop;
                        }
                        if (this.currentAnimationProgress >= 1.0f) {
                            this.swipeDeleteState = SWIPE_DELETE_BEFORE;
                        }
                    }
                } else if (this.swipeDeleteState == SWIPE_DELETE_AFTER) {
                    drawLeft = followLeft;
                    drawTop = followTop;
                } else if (this.swipeDeleteState == SWIPE_DELETE_ANIMATING_TO_BEFORE) {
                    this.swipeDeleteState = SWIPE_DELETE_ANIMATING_TO_AFTER;
                    drawLeft = this.lastLeft;
                    drawTop = this.lastTop;
                    this.startAnimator(drawLeft, drawTop, followLeft, followTop, direction);
                } else if (this.swipeDeleteState == SWIPE_DELETE_BEFORE) {
                    this.swipeDeleteState = SWIPE_DELETE_ANIMATING_TO_AFTER;
                    drawLeft = anchorLeft;
                    drawTop = anchorTop;
                    this.startAnimator(drawLeft, drawTop, followLeft, followTop, direction);
                } else {
                    if (this.isVer(direction)) {
                        drawLeft = followLeft;
                        drawTop = this.animStartTop + (followTop - this.animStartTop) * this.currentAnimationProgress;
                    } else {
                        drawLeft = this.animStartLeft + (followLeft - this.animStartLeft) * this.currentAnimationProgress;
                        drawTop = followTop;
                    }
                    if (this.currentAnimationProgress >= 1.0f) {
                        this.swipeDeleteState = SWIPE_DELETE_AFTER;
                    }
                }
                canvas.translate(drawLeft - this.left, drawTop - this.top);
                this.lastLeft = drawLeft;
                this.lastTop = drawTop;
            }
            this.action.paint.setColor(this.action.mTextColor);
            this.action.draw(canvas);
            canvas.restore();
        }

        private void startAnimator(float curLeft, float curTop, float targetLeft, float targetTop, int direction) {
            QMUIViewHelper.clearValueAnimator((Animator)this.animator);
            if (this.isVer(direction)) {
                this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                this.animStartTop = curTop;
            } else {
                this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                this.animStartLeft = curLeft;
            }
            float dis = this.isVer(direction) ? Math.abs(targetTop - curTop) : Math.abs(targetLeft - curLeft);
            int duration = Math.min(MAX_SWIPE_MOVE_DURATION, (int)(dis / (float)this.action.mSwipePxPerMS));
            this.animator.setDuration((long)duration);
            this.animator.setInterpolator(this.action.mSwipeMoveInterpolator);
            this.animator.addUpdateListener(this.listener);
            this.animator.start();
        }

        private boolean isVer(int direction) {
            return direction == 4 || direction == 3;
        }

        private float getAnchorDrawLeft(int direction) {
            if (direction == 1 ? this.left > this.targetLeft : direction == 2 && this.left < this.targetLeft) {
                return this.getFollowDrawLeft(direction);
            }
            return this.targetLeft + (this.measureWidth - this.action.contentWidth) / 2.0f;
        }

        private float getAnchorDrawTop(int direction) {
            if (direction == 3 ? this.top > this.targetTop : direction == 4 && this.top < this.targetTop) {
                return this.getFollowDrawTop(direction);
            }
            return this.targetTop + (this.measureHeight - this.action.contentHeight) / 2.0f;
        }

        private float getFollowDrawLeft(int direction) {
            float innerHor = (this.measureWidth - this.action.contentWidth) / 2.0f;
            if (direction == 1) {
                return this.left + innerHor;
            }
            if (direction == 2) {
                return this.left + this.width - this.measureWidth + innerHor;
            }
            return this.left + (this.width - this.action.contentWidth) / 2.0f;
        }

        private float getFollowDrawTop(int direction) {
            float innerVer = (this.measureHeight - this.action.contentHeight) / 2.0f;
            if (direction == 3) {
                return this.top + innerVer;
            }
            if (direction == 4) {
                return this.top + this.height - this.measureHeight + innerVer;
            }
            return this.top + (this.height - this.action.contentHeight) / 2.0f;
        }

        static interface Callback {
            public void invalidate();
        }
    }
}

