/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.skin;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import com.qmuiteam.qmui.QMUILog;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUILangHelper;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.HashMap;

public class QMUISkinLayoutInflaterFactory
implements LayoutInflater.Factory2 {
    private static final String TAG = "QMUISkin";
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.app.", "android.view."};
    private static final HashMap<String, String> sSuccessClassNamePrefixMap = new HashMap();
    private static boolean sCanUseCreateViewFourArguments = true;
    private static boolean sDidCheckLayoutInflaterCreateViewExitFourArgMethod = false;
    private Resources.Theme mEmptyTheme;
    private WeakReference<Activity> mActivityWeakReference;
    private LayoutInflater mOriginLayoutInflater;

    public QMUISkinLayoutInflaterFactory(Activity activity, LayoutInflater originLayoutInflater) {
        this.mActivityWeakReference = new WeakReference<Activity>(activity);
        this.mOriginLayoutInflater = originLayoutInflater;
    }

    public QMUISkinLayoutInflaterFactory cloneForLayoutInflaterIfNeeded(LayoutInflater layoutInflater) {
        if (this.mOriginLayoutInflater.getContext() == layoutInflater.getContext()) {
            return this;
        }
        return new QMUISkinLayoutInflaterFactory((Activity)this.mActivityWeakReference.get(), layoutInflater);
    }

    public View onCreateView(View parent, String name, Context context, AttributeSet attrs) {
        View view;
        block16: {
            Activity activity = (Activity)this.mActivityWeakReference.get();
            view = null;
            if (activity instanceof AppCompatActivity) {
                view = ((AppCompatActivity)activity).getDelegate().createView(parent, name, context, attrs);
            }
            if (view == null) {
                try {
                    if (!name.contains(".")) {
                        if (sSuccessClassNamePrefixMap.containsKey(name)) {
                            view = this.mOriginLayoutInflater.createView(name, sSuccessClassNamePrefixMap.get(name), attrs);
                            break block16;
                        }
                        for (String prefix : sClassPrefixList) {
                            try {
                                view = this.mOriginLayoutInflater.createView(name, prefix, attrs);
                                if (view == null) continue;
                                sSuccessClassNamePrefixMap.put(name, prefix);
                                break block16;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        break block16;
                    }
                    if (Build.VERSION.SDK_INT >= 29) {
                        if (!sDidCheckLayoutInflaterCreateViewExitFourArgMethod) {
                            try {
                                LayoutInflater.class.getDeclaredMethod("createView", Context.class, String.class, String.class, AttributeSet.class);
                            }
                            catch (Exception e) {
                                sCanUseCreateViewFourArguments = false;
                            }
                            sDidCheckLayoutInflaterCreateViewExitFourArgMethod = true;
                        }
                        view = sCanUseCreateViewFourArguments ? this.mOriginLayoutInflater.createView(context, name, null, attrs) : this.originCreateViewForLowSDK(name, context, attrs);
                        break block16;
                    }
                    view = this.originCreateViewForLowSDK(name, context, attrs);
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    QMUILog.e(TAG, "Failed to inflate view " + name + "; error: " + e.getMessage(), new Object[0]);
                }
            }
        }
        if (view != null) {
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            this.getSkinValueFromAttributeSet(view.getContext(), attrs, builder);
            if (!builder.isEmpty()) {
                QMUISkinHelper.setSkinValue(view, builder);
            }
            QMUISkinValueBuilder.release(builder);
        }
        return view;
    }

    private View originCreateViewForLowSDK(String name, Context context, AttributeSet attrs) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InflateException, ClassNotFoundException {
        Field field = LayoutInflater.class.getDeclaredField("mConstructorArgs");
        field.setAccessible(true);
        Object[] mConstructorArgs = (Object[])field.get(this.mOriginLayoutInflater);
        Object lastContext = mConstructorArgs[0];
        mConstructorArgs[0] = context;
        View view = this.mOriginLayoutInflater.createView(name, null, attrs);
        mConstructorArgs[0] = lastContext;
        return view;
    }

    public View onCreateView(String name, Context context, AttributeSet attrs) {
        return this.onCreateView(null, name, context, attrs);
    }

    public void getSkinValueFromAttributeSet(Context context, @Nullable AttributeSet attrs, QMUISkinValueBuilder builder) {
        if (this.mEmptyTheme == null) {
            this.mEmptyTheme = context.getApplicationContext().getResources().newTheme();
        }
        TypedArray a = this.mEmptyTheme.obtainStyledAttributes(attrs, R.styleable.QMUISkinDef, 0, 0);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int id2;
            int attr2 = a.getIndex(i);
            String name = a.getString(attr2);
            if (QMUILangHelper.isNullOrEmpty(name)) continue;
            if (name.startsWith("?")) {
                name = name.substring(1);
            }
            if ((id2 = context.getResources().getIdentifier(name, "attr", context.getPackageName())) == 0) continue;
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_background) {
                builder.background(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_alpha) {
                builder.alpha(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_border) {
                builder.border(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_text_color) {
                builder.textColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_second_text_color) {
                builder.secondTextColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_src) {
                builder.src(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_tint_color) {
                builder.tintColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_separator_top) {
                builder.topSeparator(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_separator_right) {
                builder.rightSeparator(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_separator_bottom) {
                builder.bottomSeparator(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_separator_left) {
                builder.leftSeparator(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_bg_tint_color) {
                builder.bgTintColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_progress_color) {
                builder.progressColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_underline) {
                builder.underline(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_more_bg_color) {
                builder.moreBgColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_more_text_color) {
                builder.moreTextColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_hint_color) {
                builder.hintColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_text_compound_tint_color) {
                builder.textCompoundTintColor(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_text_compound_src_left) {
                builder.textCompoundLeftSrc(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_text_compound_src_top) {
                builder.textCompoundTopSrc(id2);
                continue;
            }
            if (attr2 == R.styleable.QMUISkinDef_qmui_skin_text_compound_src_right) {
                builder.textCompoundRightSrc(id2);
                continue;
            }
            if (attr2 != R.styleable.QMUISkinDef_qmui_skin_text_compound_src_bottom) continue;
            builder.textCompoundBottomSrc(id2);
        }
        a.recycle();
    }
}

