/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.skin;

import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.LinkedList;

public class QMUISkinValueBuilder {
    public static final String BACKGROUND = "background";
    public static final String TEXT_COLOR = "textColor";
    public static final String HINT_COLOR = "hintColor";
    public static final String SECOND_TEXT_COLOR = "secondTextColor";
    public static final String SRC = "src";
    public static final String BORDER = "border";
    public static final String TOP_SEPARATOR = "topSeparator";
    public static final String BOTTOM_SEPARATOR = "bottomSeparator";
    public static final String RIGHT_SEPARATOR = "rightSeparator";
    public static final String LEFT_SEPARATOR = "LeftSeparator";
    public static final String ALPHA = "alpha";
    public static final String TINT_COLOR = "tintColor";
    public static final String BG_TINT_COLOR = "bgTintColor";
    public static final String PROGRESS_COLOR = "progressColor";
    public static final String TEXT_COMPOUND_TINT_COLOR = "tcTintColor";
    public static final String TEXT_COMPOUND_LEFT_SRC = "tclSrc";
    public static final String TEXT_COMPOUND_RIGHT_SRC = "tcrSrc";
    public static final String TEXT_COMPOUND_TOP_SRC = "tctSrc";
    public static final String TEXT_COMPOUND_BOTTOM_SRC = "tcbSrc";
    public static final String UNDERLINE = "underline";
    public static final String MORE_TEXT_COLOR = "moreTextColor";
    public static final String MORE_BG_COLOR = "moreBgColor";
    private static LinkedList<QMUISkinValueBuilder> sValueBuilderPool;
    private HashMap<String, String> mValues = new HashMap();

    public static QMUISkinValueBuilder acquire() {
        if (sValueBuilderPool == null) {
            return new QMUISkinValueBuilder();
        }
        QMUISkinValueBuilder valueBuilder = sValueBuilderPool.poll();
        if (valueBuilder != null) {
            return valueBuilder;
        }
        return new QMUISkinValueBuilder();
    }

    public static void release(@NonNull QMUISkinValueBuilder valueBuilder) {
        valueBuilder.clear();
        if (sValueBuilderPool == null) {
            sValueBuilderPool = new LinkedList();
        }
        if (sValueBuilderPool.size() < 2) {
            sValueBuilderPool.push(valueBuilder);
        }
    }

    private QMUISkinValueBuilder() {
    }

    public QMUISkinValueBuilder background(int attr2) {
        this.mValues.put(BACKGROUND, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder background(String attrName) {
        this.mValues.put(BACKGROUND, attrName);
        return this;
    }

    public QMUISkinValueBuilder underline(int attr2) {
        this.mValues.put(UNDERLINE, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder underline(String attrName) {
        this.mValues.put(UNDERLINE, attrName);
        return this;
    }

    public QMUISkinValueBuilder moreTextColor(int attr2) {
        this.mValues.put(MORE_TEXT_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder moreTextColor(String attrName) {
        this.mValues.put(MORE_TEXT_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder moreBgColor(int attr2) {
        this.mValues.put(MORE_BG_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder moreBgColor(String attrName) {
        this.mValues.put(MORE_BG_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder textCompoundTintColor(int attr2) {
        this.mValues.put(TEXT_COMPOUND_TINT_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder textCompoundTintColor(String attrName) {
        this.mValues.put(TEXT_COMPOUND_TINT_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder textCompoundTopSrc(int attr2) {
        this.mValues.put(TEXT_COMPOUND_TOP_SRC, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder textCompoundTopSrc(String attrName) {
        this.mValues.put(TEXT_COMPOUND_TOP_SRC, attrName);
        return this;
    }

    public QMUISkinValueBuilder textCompoundRightSrc(int attr2) {
        this.mValues.put(TEXT_COMPOUND_RIGHT_SRC, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder textCompoundRightSrc(String attrName) {
        this.mValues.put(TEXT_COMPOUND_RIGHT_SRC, attrName);
        return this;
    }

    public QMUISkinValueBuilder textCompoundBottomSrc(int attr2) {
        this.mValues.put(TEXT_COMPOUND_BOTTOM_SRC, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder textCompoundBottomSrc(String attrName) {
        this.mValues.put(TEXT_COMPOUND_BOTTOM_SRC, attrName);
        return this;
    }

    public QMUISkinValueBuilder textCompoundLeftSrc(int attr2) {
        this.mValues.put(TEXT_COMPOUND_LEFT_SRC, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder textCompoundLeftSrc(String attrName) {
        this.mValues.put(TEXT_COMPOUND_LEFT_SRC, attrName);
        return this;
    }

    public QMUISkinValueBuilder textColor(int attr2) {
        this.mValues.put(TEXT_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder textColor(String attrName) {
        this.mValues.put(TEXT_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder hintColor(int attr2) {
        this.mValues.put(HINT_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder hintColor(String attrName) {
        this.mValues.put(HINT_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder progressColor(int attr2) {
        this.mValues.put(PROGRESS_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder progressColor(String attrName) {
        this.mValues.put(PROGRESS_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder src(int attr2) {
        this.mValues.put(SRC, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder src(String attrName) {
        this.mValues.put(SRC, attrName);
        return this;
    }

    public QMUISkinValueBuilder border(int attr2) {
        this.mValues.put(BORDER, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder border(String attrName) {
        this.mValues.put(BORDER, attrName);
        return this;
    }

    public QMUISkinValueBuilder topSeparator(int attr2) {
        this.mValues.put(TOP_SEPARATOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder topSeparator(String attrName) {
        this.mValues.put(TOP_SEPARATOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder rightSeparator(int attr2) {
        this.mValues.put(RIGHT_SEPARATOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder rightSeparator(String attrName) {
        this.mValues.put(RIGHT_SEPARATOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder bottomSeparator(int attr2) {
        this.mValues.put(BOTTOM_SEPARATOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder bottomSeparator(String attrName) {
        this.mValues.put(BOTTOM_SEPARATOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder leftSeparator(int attr2) {
        this.mValues.put(LEFT_SEPARATOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder leftSeparator(String attrName) {
        this.mValues.put(LEFT_SEPARATOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder alpha(int attr2) {
        this.mValues.put(ALPHA, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder alpha(String attrName) {
        this.mValues.put(ALPHA, attrName);
        return this;
    }

    public QMUISkinValueBuilder tintColor(int attr2) {
        this.mValues.put(TINT_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder tintColor(String attrName) {
        this.mValues.put(TINT_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder bgTintColor(int attr2) {
        this.mValues.put(BG_TINT_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder bgTintColor(String attrName) {
        this.mValues.put(BG_TINT_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder secondTextColor(int attr2) {
        this.mValues.put(SECOND_TEXT_COLOR, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder secondTextColor(String attrName) {
        this.mValues.put(SECOND_TEXT_COLOR, attrName);
        return this;
    }

    public QMUISkinValueBuilder custom(String name, int attr2) {
        this.mValues.put(name, String.valueOf(attr2));
        return this;
    }

    public QMUISkinValueBuilder custom(String name, String attrName) {
        this.mValues.put(name, attrName);
        return this;
    }

    public QMUISkinValueBuilder clear() {
        this.mValues.clear();
        return this;
    }

    public QMUISkinValueBuilder convertFrom(String value) {
        String[] items;
        for (String item : items = value.split("[|]")) {
            String[] kv = item.split(":");
            if (kv.length != 2) continue;
            this.mValues.put(kv[0].trim(), kv[1].trim());
        }
        return this;
    }

    public boolean isEmpty() {
        return this.mValues.isEmpty();
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        boolean isFirstItem = true;
        for (String name : this.mValues.keySet()) {
            String itemValue = this.mValues.get(name);
            if (itemValue == null || itemValue.isEmpty()) continue;
            if (!isFirstItem) {
                builder.append("|");
            }
            builder.append(name);
            builder.append(":");
            builder.append(itemValue);
            isFirstItem = false;
        }
        return builder.toString();
    }

    public void release() {
        QMUISkinValueBuilder.release(this);
    }
}

