/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Interpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.RequiresApi;
import androidx.core.text.TextDirectionHeuristicsCompat;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIColorHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;

public final class QMUICollapsingTextHelper {
    private static final boolean USE_SCALING_TEXTURE = Build.VERSION.SDK_INT < 18;
    private static final boolean DEBUG_DRAW = false;
    private static final Paint DEBUG_DRAW_PAINT = null;
    private final View mView;
    private boolean mDrawTitle;
    private float mExpandedFraction;
    private final Rect mExpandedBounds;
    private final Rect mCollapsedBounds;
    private final RectF mCurrentBounds;
    private int mExpandedTextGravity = 16;
    private int mCollapsedTextGravity = 16;
    private float mExpandedTextSize = 15.0f;
    private float mCollapsedTextSize = 15.0f;
    private ColorStateList mExpandedTextColor;
    private ColorStateList mCollapsedTextColor;
    private float mExpandedDrawY;
    private float mCollapsedDrawY;
    private float mExpandedDrawX;
    private float mCollapsedDrawX;
    private float mCurrentDrawX;
    private float mCurrentDrawY;
    private float mCollapsedTextWidth;
    private float mExpandedTextWidth;
    private float mCurrentTextWidth;
    private float mCollapsedTextHeight;
    private float mExpandedTextHeight;
    private float mCurrentTextHeight;
    private Typeface mCollapsedTypeface;
    private Typeface mExpandedTypeface;
    private Typeface mCurrentTypeface;
    private float mTypefaceUpdateAreaPercent;
    private CharSequence mText;
    private CharSequence mTextToDraw;
    private boolean mIsRtl;
    private boolean mUseTexture;
    private Bitmap mExpandedTitleTexture;
    private Paint mTexturePaint;
    private float mTextureAscent;
    private float mTextureDescent;
    private float mScale;
    private float mCurrentTextSize;
    private int[] mState;
    private boolean mBoundsChanged;
    private final TextPaint mTextPaint;
    private Interpolator mPositionInterpolator;
    private Interpolator mTextSizeInterpolator;
    private float mCollapsedShadowRadius;
    private float mCollapsedShadowDx;
    private float mCollapsedShadowDy;
    private int mCollapsedShadowColor;
    private float mExpandedShadowRadius;
    private float mExpandedShadowDx;
    private float mExpandedShadowDy;
    private int mExpandedShadowColor;

    public QMUICollapsingTextHelper(View view) {
        this(view, 0.0f);
    }

    public QMUICollapsingTextHelper(View view, float defaultExpanededFraction) {
        this.mView = view;
        this.mTextPaint = new TextPaint(129);
        this.mExpandedFraction = defaultExpanededFraction;
        this.mCollapsedBounds = new Rect();
        this.mExpandedBounds = new Rect();
        this.mCurrentBounds = new RectF();
    }

    public void setTextSizeInterpolator(Interpolator interpolator) {
        this.mTextSizeInterpolator = interpolator;
        this.recalculate();
    }

    public void setPositionInterpolator(Interpolator interpolator) {
        this.mPositionInterpolator = interpolator;
        this.recalculate();
    }

    public void setTextSize(float collapsedTextSize, float expandedTextSize, boolean recalculate) {
        if (this.mExpandedTextSize != expandedTextSize || this.mCollapsedTextSize != collapsedTextSize) {
            this.mExpandedTextSize = expandedTextSize;
            this.mCollapsedTextSize = collapsedTextSize;
            if (recalculate) {
                this.recalculate();
            }
        }
    }

    public void setExpandedTextSize(float textSize) {
        if (this.mExpandedTextSize != textSize) {
            this.mExpandedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextSize(float textSize) {
        if (this.mCollapsedTextSize != textSize) {
            this.mCollapsedTextSize = textSize;
            this.recalculate();
        }
    }

    public void setCollapsedTextColor(ColorStateList textColor) {
        if (this.mCollapsedTextColor != textColor) {
            this.mCollapsedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setExpandedTextColor(ColorStateList textColor) {
        if (this.mExpandedTextColor != textColor) {
            this.mExpandedTextColor = textColor;
            this.recalculate();
        }
    }

    public void setTextColor(ColorStateList collapsedTextColor, ColorStateList expandedTextColor, boolean recalculate) {
        if (this.mCollapsedTextColor != collapsedTextColor || this.mExpandedTextColor != expandedTextColor) {
            this.mCollapsedTextColor = collapsedTextColor;
            this.mExpandedTextColor = expandedTextColor;
            if (recalculate) {
                this.recalculate();
            }
        }
    }

    public void setCollapsedTextAppearance(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, R.styleable.QMUITextAppearance);
        if (a.hasValue(R.styleable.QMUITextAppearance_android_textColor)) {
            this.mCollapsedTextColor = a.getColorStateList(R.styleable.QMUITextAppearance_android_textColor);
        }
        if (a.hasValue(R.styleable.QMUITextAppearance_android_textSize)) {
            this.mCollapsedTextSize = a.getDimensionPixelSize(R.styleable.QMUITextAppearance_android_textSize, (int)this.mCollapsedTextSize);
        }
        this.mCollapsedShadowColor = a.getInt(R.styleable.QMUITextAppearance_android_shadowColor, 0);
        this.mCollapsedShadowDx = a.getFloat(R.styleable.QMUITextAppearance_android_shadowDx, 0.0f);
        this.mCollapsedShadowDy = a.getFloat(R.styleable.QMUITextAppearance_android_shadowDy, 0.0f);
        this.mCollapsedShadowRadius = a.getFloat(R.styleable.QMUITextAppearance_android_shadowRadius, 0.0f);
        a.recycle();
        this.mCollapsedTypeface = this.readFontFamilyTypeface(resId);
        this.recalculate();
    }

    public void setExpandedTextAppearance(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, R.styleable.QMUITextAppearance);
        if (a.hasValue(R.styleable.QMUITextAppearance_android_textColor)) {
            this.mExpandedTextColor = a.getColorStateList(R.styleable.QMUITextAppearance_android_textColor);
        }
        if (a.hasValue(R.styleable.QMUITextAppearance_android_textSize)) {
            this.mExpandedTextSize = a.getDimensionPixelSize(R.styleable.QMUITextAppearance_android_textSize, (int)this.mExpandedTextSize);
        }
        this.mExpandedShadowColor = a.getInt(R.styleable.QMUITextAppearance_android_shadowColor, 0);
        this.mExpandedShadowDx = a.getFloat(R.styleable.QMUITextAppearance_android_shadowDx, 0.0f);
        this.mExpandedShadowDy = a.getFloat(R.styleable.QMUITextAppearance_android_shadowDy, 0.0f);
        this.mExpandedShadowRadius = a.getFloat(R.styleable.QMUITextAppearance_android_shadowRadius, 0.0f);
        a.recycle();
        this.mExpandedTypeface = this.readFontFamilyTypeface(resId);
        this.recalculate();
    }

    public void setExpandedBounds(int left, int top, int right, int bottom) {
        if (!QMUICollapsingTextHelper.rectEquals(this.mExpandedBounds, left, top, right, bottom)) {
            this.mExpandedBounds.set(left, top, right, bottom);
            this.mBoundsChanged = true;
            this.onBoundsChanged();
        }
    }

    public void setCollapsedBounds(int left, int top, int right, int bottom) {
        if (!QMUICollapsingTextHelper.rectEquals(this.mCollapsedBounds, left, top, right, bottom)) {
            this.mCollapsedBounds.set(left, top, right, bottom);
            this.mBoundsChanged = true;
            this.onBoundsChanged();
        }
    }

    void onBoundsChanged() {
        this.mDrawTitle = this.mCollapsedBounds.width() > 0 && this.mCollapsedBounds.height() > 0 && this.mExpandedBounds.width() > 0 && this.mExpandedBounds.height() > 0;
    }

    public void setExpandedTextGravity(int gravity) {
        if (this.mExpandedTextGravity != gravity) {
            this.mExpandedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getExpandedTextGravity() {
        return this.mExpandedTextGravity;
    }

    public void setCollapsedTextGravity(int gravity) {
        if (this.mCollapsedTextGravity != gravity) {
            this.mCollapsedTextGravity = gravity;
            this.recalculate();
        }
    }

    public int getCollapsedTextGravity() {
        return this.mCollapsedTextGravity;
    }

    public void setGravity(int collapsedGravity, int expandedGravity, boolean recalculate) {
        if (this.mCollapsedTextGravity != collapsedGravity || this.mExpandedTextGravity != expandedGravity) {
            this.mCollapsedTextGravity = collapsedGravity;
            this.mExpandedTextGravity = expandedGravity;
            if (recalculate) {
                this.recalculate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=16)
    private Typeface readFontFamilyTypeface(int resId) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(resId, new int[]{16843692});
        try {
            String family = a.getString(0);
            if (family != null) {
                Typeface typeface = Typeface.create((String)family, (int)0);
                return typeface;
            }
        }
        finally {
            a.recycle();
        }
        return null;
    }

    public void setTypeface(Typeface collapsedTypeface, Typeface expandedTypeface, boolean recalculate) {
        if (this.mCollapsedTypeface != collapsedTypeface || this.mExpandedTypeface != expandedTypeface) {
            this.mCollapsedTypeface = collapsedTypeface;
            this.mExpandedTypeface = expandedTypeface;
            if (recalculate) {
                this.recalculate();
            }
        }
    }

    public void setCollapsedTypeface(Typeface typeface) {
        if (this.mCollapsedTypeface != typeface) {
            this.mCollapsedTypeface = typeface;
            this.recalculate();
        }
    }

    public void setExpandedTypeface(Typeface typeface) {
        if (this.mExpandedTypeface != typeface) {
            this.mExpandedTypeface = typeface;
            this.recalculate();
        }
    }

    public void setTypefaces(Typeface typeface) {
        this.mCollapsedTypeface = this.mExpandedTypeface = typeface;
        this.recalculate();
    }

    public Typeface getCollapsedTypeface() {
        return this.mCollapsedTypeface != null ? this.mCollapsedTypeface : Typeface.DEFAULT;
    }

    public Typeface getExpandedTypeface() {
        return this.mExpandedTypeface != null ? this.mExpandedTypeface : Typeface.DEFAULT;
    }

    public void setExpansionFraction(float fraction) {
        if ((fraction = QMUILangHelper.constrain(fraction, 0.0f, 1.0f)) != this.mExpandedFraction) {
            this.mExpandedFraction = fraction;
            this.calculateCurrentOffsets();
        }
    }

    public final boolean setState(int[] state) {
        this.mState = state;
        if (this.isStateful()) {
            this.recalculate();
            return true;
        }
        return false;
    }

    public void setTypefaceUpdateAreaPercent(float typefaceUpdateAreaPercent) {
        this.mTypefaceUpdateAreaPercent = typefaceUpdateAreaPercent;
    }

    public final boolean isStateful() {
        return this.mCollapsedTextColor != null && this.mCollapsedTextColor.isStateful() || this.mExpandedTextColor != null && this.mExpandedTextColor.isStateful();
    }

    public float getExpansionFraction() {
        return this.mExpandedFraction;
    }

    public float getCollapsedTextSize() {
        return this.mCollapsedTextSize;
    }

    public float getExpandedTextSize() {
        return this.mExpandedTextSize;
    }

    public void calculateCurrentOffsets() {
        this.calculateOffsets(this.mExpandedFraction);
    }

    private void calculateOffsets(float fraction) {
        this.interpolateBounds(fraction);
        this.mCurrentDrawX = QMUICollapsingTextHelper.lerp(this.mExpandedDrawX, this.mCollapsedDrawX, fraction, this.mPositionInterpolator);
        this.mCurrentDrawY = QMUICollapsingTextHelper.lerp(this.mExpandedDrawY, this.mCollapsedDrawY, fraction, this.mPositionInterpolator);
        this.mCurrentTextHeight = QMUICollapsingTextHelper.lerp(this.mExpandedTextHeight, this.mCollapsedTextHeight, fraction, this.mPositionInterpolator);
        this.mCurrentTextWidth = QMUICollapsingTextHelper.lerp(this.mExpandedTextWidth, this.mCollapsedTextWidth, fraction, this.mPositionInterpolator);
        this.setInterpolatedTextSize(QMUICollapsingTextHelper.lerp(this.mExpandedTextSize, this.mCollapsedTextSize, fraction, this.mTextSizeInterpolator));
        if (this.mCollapsedTextColor != this.mExpandedTextColor) {
            this.mTextPaint.setColor(QMUIColorHelper.computeColor(this.getCurrentExpandedTextColor(), this.getCurrentCollapsedTextColor(), fraction));
        } else {
            this.mTextPaint.setColor(this.getCurrentCollapsedTextColor());
        }
        this.mTextPaint.setShadowLayer(QMUICollapsingTextHelper.lerp(this.mExpandedShadowRadius, this.mCollapsedShadowRadius, fraction, null), QMUICollapsingTextHelper.lerp(this.mExpandedShadowDx, this.mCollapsedShadowDx, fraction, null), QMUICollapsingTextHelper.lerp(this.mExpandedShadowDy, this.mCollapsedShadowDy, fraction, null), QMUIColorHelper.computeColor(this.mExpandedShadowColor, this.mCollapsedShadowColor, fraction));
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    @ColorInt
    private int getCurrentExpandedTextColor() {
        if (this.mExpandedTextColor == null) {
            return 0;
        }
        if (this.mState != null) {
            return this.mExpandedTextColor.getColorForState(this.mState, 0);
        }
        return this.mExpandedTextColor.getDefaultColor();
    }

    @ColorInt
    private int getCurrentCollapsedTextColor() {
        if (this.mCollapsedTextColor == null) {
            return 0;
        }
        if (this.mState != null) {
            return this.mCollapsedTextColor.getColorForState(this.mState, 0);
        }
        return this.mCollapsedTextColor.getDefaultColor();
    }

    public void calculateBaseOffsets() {
        float currentTextSize = this.mCurrentTextSize;
        this.calculateUsingTextSize(this.mCollapsedTextSize);
        this.mCollapsedTextWidth = this.mTextToDraw != null ? this.mTextPaint.measureText(this.mTextToDraw, 0, this.mTextToDraw.length()) : 0.0f;
        this.mCollapsedTextHeight = this.mTextPaint.descent() - this.mTextPaint.ascent();
        int collapsedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.mCollapsedTextGravity, (int)(this.mIsRtl ? 1 : 0));
        switch (collapsedAbsGravity & 0x70) {
            case 80: {
                this.mCollapsedDrawY = (float)this.mCollapsedBounds.bottom - this.mTextPaint.descent();
                break;
            }
            case 48: {
                this.mCollapsedDrawY = (float)this.mCollapsedBounds.top - this.mTextPaint.ascent();
                break;
            }
            default: {
                float textOffset = this.mCollapsedTextHeight / 2.0f - this.mTextPaint.descent();
                this.mCollapsedDrawY = (float)this.mCollapsedBounds.centerY() + textOffset;
            }
        }
        switch (collapsedAbsGravity & 0x800007) {
            case 1: {
                this.mCollapsedDrawX = (float)this.mCollapsedBounds.centerX() - this.mCollapsedTextWidth / 2.0f;
                break;
            }
            case 5: {
                this.mCollapsedDrawX = (float)this.mCollapsedBounds.right - this.mCollapsedTextWidth;
                break;
            }
            default: {
                this.mCollapsedDrawX = this.mCollapsedBounds.left;
            }
        }
        this.calculateUsingTextSize(this.mExpandedTextSize);
        this.mExpandedTextWidth = this.mTextToDraw != null ? this.mTextPaint.measureText(this.mTextToDraw, 0, this.mTextToDraw.length()) : 0.0f;
        this.mExpandedTextHeight = this.mTextPaint.descent() - this.mTextPaint.ascent();
        int expandedAbsGravity = GravityCompat.getAbsoluteGravity((int)this.mExpandedTextGravity, (int)(this.mIsRtl ? 1 : 0));
        switch (expandedAbsGravity & 0x70) {
            case 80: {
                this.mExpandedDrawY = (float)this.mExpandedBounds.bottom - this.mTextPaint.descent();
                break;
            }
            case 48: {
                this.mExpandedDrawY = (float)this.mExpandedBounds.top - this.mTextPaint.ascent();
                break;
            }
            default: {
                float textOffset = this.mExpandedTextHeight / 2.0f - this.mTextPaint.descent();
                this.mExpandedDrawY = (float)this.mExpandedBounds.centerY() + textOffset;
            }
        }
        switch (expandedAbsGravity & 0x800007) {
            case 1: {
                this.mExpandedDrawX = (float)this.mExpandedBounds.centerX() - this.mExpandedTextWidth / 2.0f;
                break;
            }
            case 5: {
                this.mExpandedDrawX = (float)this.mExpandedBounds.right - this.mExpandedTextWidth;
                break;
            }
            default: {
                this.mExpandedDrawX = this.mExpandedBounds.left;
            }
        }
        this.clearTexture();
        this.setInterpolatedTextSize(currentTextSize);
    }

    private void interpolateBounds(float fraction) {
        this.mCurrentBounds.left = QMUICollapsingTextHelper.lerp(this.mExpandedBounds.left, this.mCollapsedBounds.left, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.top = QMUICollapsingTextHelper.lerp(this.mExpandedDrawY, this.mCollapsedDrawY, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.right = QMUICollapsingTextHelper.lerp(this.mExpandedBounds.right, this.mCollapsedBounds.right, fraction, this.mPositionInterpolator);
        this.mCurrentBounds.bottom = QMUICollapsingTextHelper.lerp(this.mExpandedBounds.bottom, this.mCollapsedBounds.bottom, fraction, this.mPositionInterpolator);
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        if (this.mTextToDraw != null && this.mDrawTitle) {
            float ascent;
            boolean drawTexture;
            float x = this.mCurrentDrawX;
            float y = this.mCurrentDrawY;
            boolean bl = drawTexture = this.mUseTexture && this.mExpandedTitleTexture != null;
            if (drawTexture) {
                ascent = this.mTextureAscent * this.mScale;
                float descent = this.mTextureDescent * this.mScale;
            } else {
                ascent = this.mTextPaint.ascent() * this.mScale;
                float descent = this.mTextPaint.descent() * this.mScale;
            }
            if (drawTexture) {
                y += ascent;
            }
            if (this.mScale != 1.0f) {
                canvas.scale(this.mScale, this.mScale, x, y);
            }
            if (drawTexture) {
                canvas.drawBitmap(this.mExpandedTitleTexture, x, y, this.mTexturePaint);
            } else {
                canvas.drawText(this.mTextToDraw, 0, this.mTextToDraw.length(), x, y, (Paint)this.mTextPaint);
            }
        }
        canvas.restoreToCount(saveCount);
    }

    private boolean calculateIsRtl(CharSequence text) {
        boolean defaultIsRtl = ViewCompat.getLayoutDirection((View)this.mView) == 1;
        return (defaultIsRtl ? TextDirectionHeuristicsCompat.FIRSTSTRONG_RTL : TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR).isRtl(text, 0, text.length());
    }

    private void setInterpolatedTextSize(float textSize) {
        this.calculateUsingTextSize(textSize);
        boolean bl = this.mUseTexture = USE_SCALING_TEXTURE && this.mScale != 1.0f;
        if (this.mUseTexture) {
            this.ensureExpandedTexture();
        }
        ViewCompat.postInvalidateOnAnimation((View)this.mView);
    }

    private void calculateUsingTextSize(float textSize) {
        float availableWidth;
        float newTextSize;
        if (this.mText == null) {
            return;
        }
        float collapsedWidth = this.mCollapsedBounds.width();
        float expandedWidth = this.mExpandedBounds.width();
        boolean updateDrawText = false;
        if (this.mExpandedFraction >= 1.0f - this.mTypefaceUpdateAreaPercent) {
            if (this.mCurrentTypeface != this.mCollapsedTypeface) {
                this.mCurrentTypeface = this.mCollapsedTypeface;
                updateDrawText = true;
            }
        } else if (this.mExpandedFraction <= this.mTypefaceUpdateAreaPercent && this.mCurrentTypeface != this.mExpandedTypeface) {
            this.mCurrentTypeface = this.mExpandedTypeface;
            updateDrawText = true;
        }
        if (QMUICollapsingTextHelper.isClose(textSize, this.mCollapsedTextSize)) {
            newTextSize = this.mCollapsedTextSize;
            this.mScale = 1.0f;
            availableWidth = collapsedWidth;
        } else {
            newTextSize = this.mExpandedTextSize;
            this.mScale = QMUICollapsingTextHelper.isClose(textSize, this.mExpandedTextSize) ? 1.0f : textSize / this.mExpandedTextSize;
            float textSizeRatio = this.mCollapsedTextSize / this.mExpandedTextSize;
            float scaledDownWidth = expandedWidth * textSizeRatio;
            availableWidth = scaledDownWidth > collapsedWidth ? Math.min(collapsedWidth / textSizeRatio, expandedWidth) : expandedWidth;
        }
        if (availableWidth > 0.0f) {
            updateDrawText = this.mCurrentTextSize != newTextSize || this.mBoundsChanged || updateDrawText;
            this.mCurrentTextSize = newTextSize;
            this.mBoundsChanged = false;
        }
        if (this.mTextToDraw == null || updateDrawText) {
            this.mTextPaint.setTextSize(this.mCurrentTextSize);
            this.mTextPaint.setTypeface(this.mCurrentTypeface);
            this.mTextPaint.setLinearText(this.mScale != 1.0f);
            CharSequence title = TextUtils.ellipsize((CharSequence)this.mText, (TextPaint)this.mTextPaint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
            if (!TextUtils.equals((CharSequence)title, (CharSequence)this.mTextToDraw)) {
                this.mTextToDraw = title;
                this.mIsRtl = this.calculateIsRtl(this.mTextToDraw);
            }
        }
    }

    private void ensureExpandedTexture() {
        if (this.mExpandedTitleTexture != null || this.mExpandedBounds.isEmpty() || TextUtils.isEmpty((CharSequence)this.mTextToDraw)) {
            return;
        }
        this.calculateOffsets(0.0f);
        this.mTextureAscent = this.mTextPaint.ascent();
        this.mTextureDescent = this.mTextPaint.descent();
        int w = Math.round(this.mTextPaint.measureText(this.mTextToDraw, 0, this.mTextToDraw.length()));
        int h = Math.round(this.mTextureDescent - this.mTextureAscent);
        if (w <= 0 || h <= 0) {
            return;
        }
        this.mExpandedTitleTexture = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(this.mExpandedTitleTexture);
        c.drawText(this.mTextToDraw, 0, this.mTextToDraw.length(), 0.0f, (float)h - this.mTextPaint.descent(), (Paint)this.mTextPaint);
        if (this.mTexturePaint == null) {
            this.mTexturePaint = new Paint(3);
        }
    }

    public void recalculate() {
        if (this.mView.getHeight() > 0 && this.mView.getWidth() > 0) {
            this.calculateBaseOffsets();
            this.calculateCurrentOffsets();
        }
    }

    public void setText(CharSequence text) {
        if (text == null || !text.equals(this.mText)) {
            this.mText = text;
            this.mTextToDraw = null;
            this.clearTexture();
            this.recalculate();
        }
    }

    public CharSequence getText() {
        return this.mText;
    }

    private void clearTexture() {
        if (this.mExpandedTitleTexture != null) {
            this.mExpandedTitleTexture.recycle();
            this.mExpandedTitleTexture = null;
        }
    }

    public float getExpandedTextWidth() {
        return this.mExpandedTextWidth;
    }

    public float getCollapsedTextWidth() {
        return this.mCollapsedTextWidth;
    }

    public float getExpandedTextHeight() {
        return this.mExpandedTextHeight;
    }

    public float getCollapsedTextHeight() {
        return this.mCollapsedTextHeight;
    }

    public float getExpandedDrawX() {
        return this.mExpandedDrawX;
    }

    public float getCollapsedDrawX() {
        return this.mCollapsedDrawX;
    }

    private static boolean isClose(float value, float targetValue) {
        return Math.abs(value - targetValue) < 0.001f;
    }

    ColorStateList getExpandedTextColor() {
        return this.mExpandedTextColor;
    }

    ColorStateList getCollapsedTextColor() {
        return this.mCollapsedTextColor;
    }

    public static float lerp(float startValue, float endValue, float fraction, Interpolator interpolator) {
        if (interpolator != null) {
            fraction = interpolator.getInterpolation(fraction);
        }
        return startValue + (float)Math.round(fraction * (endValue - startValue));
    }

    private static boolean rectEquals(Rect r, int left, int top, int right, int bottom) {
        return r.left == left && r.top == top && r.right == right && r.bottom == bottom;
    }

    static {
        if (DEBUG_DRAW_PAINT != null) {
            DEBUG_DRAW_PAINT.setAntiAlias(true);
            DEBUG_DRAW_PAINT.setColor(-65281);
        }
    }
}

