/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.ColorInt;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.qmuiteam.qmui.util.QMUIDeviceHelper;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUINotchHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class QMUIStatusBarHelper {
    private static final int STATUS_BAR_DEFAULT_HEIGHT_DP = 25;
    public static float sVirtualDensity = -1.0f;
    public static float sVirtualDensityDpi = -1.0f;
    private static int sStatusBarHeight = -1;
    private static StatusBarType mStatusBarType = StatusBarType.Default;
    private static Integer sTransparentValue;

    public static void translucent(Activity activity) {
        QMUIStatusBarHelper.translucent(activity.getWindow());
    }

    public static void translucent(Window window) {
        QMUIStatusBarHelper.translucent(window, 0x40000000);
    }

    private static boolean supportTranslucent() {
        return !QMUIDeviceHelper.isEssentialPhone() || Build.VERSION.SDK_INT >= 26;
    }

    public static void translucent(Activity activity, @ColorInt int colorOn5x) {
        Window window = activity.getWindow();
        QMUIStatusBarHelper.translucent(window, colorOn5x);
    }

    @TargetApi(value=19)
    public static void translucent(Window window, @ColorInt int colorOn5x) {
        if (!QMUIStatusBarHelper.supportTranslucent()) {
            return;
        }
        if (QMUINotchHelper.isNotchOfficialSupport()) {
            QMUIStatusBarHelper.handleDisplayCutoutMode(window);
        }
        if (Build.VERSION.SDK_INT < 24 && (QMUIDeviceHelper.isFlymeLowerThan(8) || QMUIDeviceHelper.isMIUI() && Build.VERSION.SDK_INT < 23)) {
            window.setFlags(0x4000000, 0x4000000);
            return;
        }
        int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
        window.getDecorView().setSystemUiVisibility(systemUiVisibility |= 0x500);
        if (Build.VERSION.SDK_INT >= 23) {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(colorOn5x);
        }
    }

    public static int retainSystemUiFlag(Window window, int out, int type) {
        int now = window.getDecorView().getSystemUiVisibility();
        if ((now & type) == type) {
            out |= type;
        }
        return out;
    }

    @TargetApi(value=28)
    private static void handleDisplayCutoutMode(final Window window) {
        View decorView = window.getDecorView();
        if (decorView != null) {
            if (ViewCompat.isAttachedToWindow((View)decorView)) {
                QMUIStatusBarHelper.realHandleDisplayCutoutMode(window, decorView);
            } else {
                decorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                        v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        QMUIStatusBarHelper.realHandleDisplayCutoutMode(window, v);
                    }

                    public void onViewDetachedFromWindow(View v) {
                    }
                });
            }
        }
    }

    @TargetApi(value=28)
    private static void realHandleDisplayCutoutMode(Window window, View decorView) {
        if (decorView.getRootWindowInsets() != null && decorView.getRootWindowInsets().getDisplayCutout() != null) {
            WindowManager.LayoutParams params = window.getAttributes();
            params.layoutInDisplayCutoutMode = 1;
            window.setAttributes(params);
        }
    }

    public static boolean setStatusBarLightMode(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (mStatusBarType != StatusBarType.Default) {
            return QMUIStatusBarHelper.setStatusBarLightMode(activity, mStatusBarType);
        }
        if (QMUIStatusBarHelper.isMIUICustomStatusBarLightModeImpl() && QMUIStatusBarHelper.MIUISetStatusBarLightMode(activity.getWindow(), true)) {
            mStatusBarType = StatusBarType.Miui;
            return true;
        }
        if (QMUIStatusBarHelper.FlymeSetStatusBarLightMode(activity.getWindow(), true)) {
            mStatusBarType = StatusBarType.Flyme;
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            QMUIStatusBarHelper.Android6SetStatusBarLightMode(activity.getWindow(), true);
            mStatusBarType = StatusBarType.Android6;
            return true;
        }
        return false;
    }

    private static boolean setStatusBarLightMode(Activity activity, StatusBarType type) {
        if (type == StatusBarType.Miui) {
            return QMUIStatusBarHelper.MIUISetStatusBarLightMode(activity.getWindow(), true);
        }
        if (type == StatusBarType.Flyme) {
            return QMUIStatusBarHelper.FlymeSetStatusBarLightMode(activity.getWindow(), true);
        }
        if (type == StatusBarType.Android6) {
            return QMUIStatusBarHelper.Android6SetStatusBarLightMode(activity.getWindow(), true);
        }
        return false;
    }

    public static boolean setStatusBarDarkMode(Activity activity) {
        if (activity == null) {
            return false;
        }
        if (mStatusBarType == StatusBarType.Default) {
            return true;
        }
        if (mStatusBarType == StatusBarType.Miui) {
            return QMUIStatusBarHelper.MIUISetStatusBarLightMode(activity.getWindow(), false);
        }
        if (mStatusBarType == StatusBarType.Flyme) {
            return QMUIStatusBarHelper.FlymeSetStatusBarLightMode(activity.getWindow(), false);
        }
        if (mStatusBarType == StatusBarType.Android6) {
            return QMUIStatusBarHelper.Android6SetStatusBarLightMode(activity.getWindow(), false);
        }
        return true;
    }

    @TargetApi(value=23)
    private static boolean Android6SetStatusBarLightMode(Window window, boolean light) {
        if (Build.VERSION.SDK_INT > 30) {
            WindowInsetsControllerCompat insetsController = WindowCompat.getInsetsController((Window)window, (View)window.getDecorView());
            if (insetsController != null) {
                insetsController.setAppearanceLightStatusBars(light);
            }
        } else {
            View decorView = window.getDecorView();
            int systemUi = decorView.getSystemUiVisibility();
            systemUi = light ? (systemUi |= 0x2000) : (systemUi &= 0xFFFFDFFF);
            decorView.setSystemUiVisibility(systemUi);
        }
        if (QMUIDeviceHelper.isMIUIV9()) {
            QMUIStatusBarHelper.MIUISetStatusBarLightMode(window, light);
        }
        return true;
    }

    public static boolean MIUISetStatusBarLightMode(Window window, boolean light) {
        boolean result = false;
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (light) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean isMIUICustomStatusBarLightModeImpl() {
        if (QMUIDeviceHelper.isMIUIV9() && Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return QMUIDeviceHelper.isMIUIV5() || QMUIDeviceHelper.isMIUIV6() || QMUIDeviceHelper.isMIUIV7() || QMUIDeviceHelper.isMIUIV8();
    }

    public static boolean FlymeSetStatusBarLightMode(Window window, boolean light) {
        boolean result = false;
        if (window != null) {
            QMUIStatusBarHelper.Android6SetStatusBarLightMode(window, light);
            if (QMUIDeviceHelper.isFlymeLowerThan(7)) {
                try {
                    WindowManager.LayoutParams lp = window.getAttributes();
                    Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                    Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                    darkFlag.setAccessible(true);
                    meizuFlags.setAccessible(true);
                    int bit = darkFlag.getInt(null);
                    int value = meizuFlags.getInt(lp);
                    value = light ? (value |= bit) : (value &= ~bit);
                    meizuFlags.setInt(lp, value);
                    window.setAttributes(lp);
                    result = true;
                }
                catch (Exception exception) {}
            } else if (QMUIDeviceHelper.isFlyme()) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isFullScreen(Activity activity) {
        boolean ret = false;
        try {
            WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
            ret = (attrs.flags & 0x400) != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Integer getStatusBarAPITransparentValue(Context context) {
        if (sTransparentValue != null) {
            return sTransparentValue;
        }
        String[] systemSharedLibraryNames = context.getPackageManager().getSystemSharedLibraryNames();
        String fieldName = null;
        for (String lib : systemSharedLibraryNames) {
            if ("touchwiz".equals(lib)) {
                fieldName = "SYSTEM_UI_FLAG_TRANSPARENT_BACKGROUND";
                continue;
            }
            if (!lib.startsWith("com.sonyericsson.navigationbar")) continue;
            fieldName = "SYSTEM_UI_FLAG_TRANSPARENT";
        }
        if (fieldName != null) {
            try {
                Class<?> type;
                Field field = View.class.getField(fieldName);
                if (field != null && (type = field.getType()) == Integer.TYPE) {
                    sTransparentValue = field.getInt(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sTransparentValue;
    }

    public static int getStatusbarHeight(Context context) {
        if (sStatusBarHeight == -1) {
            QMUIStatusBarHelper.initStatusBarHeight(context);
        }
        return sStatusBarHeight;
    }

    private static void initStatusBarHeight(Context context) {
        Object obj = null;
        Field field = null;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            obj = clazz.newInstance();
            if (QMUIDeviceHelper.isMeizu()) {
                try {
                    field = clazz.getField("status_bar_height_large");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            if (field == null) {
                field = clazz.getField("status_bar_height");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (field != null && obj != null) {
            try {
                int id2 = Integer.parseInt(field.get(obj).toString());
                sStatusBarHeight = context.getResources().getDimensionPixelSize(id2);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (sStatusBarHeight <= 0) {
            sStatusBarHeight = sVirtualDensity == -1.0f ? QMUIDisplayHelper.dp2px(context, 25) : (int)(25.0f * sVirtualDensity + 0.5f);
        }
    }

    public static void setVirtualDensity(float density) {
        sVirtualDensity = density;
    }

    public static void setVirtualDensityDpi(float densityDpi) {
        sVirtualDensityDpi = densityDpi;
    }

    private static enum StatusBarType {
        Default,
        Miui,
        Flyme,
        Android6;

    }
}

