/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

public class QMUIProgressBar
extends View {
    public static final int TYPE_RECT = 0;
    public static final int TYPE_ROUND_RECT = 1;
    public static final int TYPE_CIRCLE = 2;
    public static final int TYPE_FILL_CIRCLE = 3;
    public static final int TOTAL_DURATION = 1000;
    public static final int DEFAULT_PROGRESS_COLOR = -16776961;
    public static final int DEFAULT_BACKGROUND_COLOR = -7829368;
    public static final int DEFAULT_TEXT_SIZE = 20;
    public static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final int PENDING_VALUE_NOT_SET = -1;
    public static int DEFAULT_STROKE_WIDTH = QMUIDisplayHelper.dpToPx(40);
    QMUIProgressBarTextGenerator mQMUIProgressBarTextGenerator;
    RectF mBgRect;
    RectF mProgressRect;
    private int mWidth;
    private int mHeight;
    private int mType;
    private int mProgressColor;
    private int mBackgroundColor;
    private int mMaxValue;
    private int mValue;
    private int mPendingValue;
    private long mAnimationStartTime;
    private int mAnimationDistance;
    private int mAnimationDuration;
    private int mTextSize;
    private int mTextColor;
    private boolean mRoundCap;
    private Paint mBackgroundPaint = new Paint();
    private Paint mPaint = new Paint();
    private Paint mTextPaint = new Paint(1);
    private RectF mArcOval = new RectF();
    private String mText = "";
    private int mStrokeWidth;
    private float mCircleRadius;
    private Point mCenterPoint;
    private OnProgressChangeListener mOnProgressChangeListener;
    private Runnable mNotifyProgressChangeAction = new Runnable(){

        @Override
        public void run() {
            if (QMUIProgressBar.this.mOnProgressChangeListener != null) {
                QMUIProgressBar.this.mOnProgressChangeListener.onProgressChange(QMUIProgressBar.this, QMUIProgressBar.this.mValue, QMUIProgressBar.this.mMaxValue);
            }
        }
    };

    public QMUIProgressBar(Context context) {
        super(context);
        this.setup(context, null);
    }

    public QMUIProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    public QMUIProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    public void setup(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIProgressBar);
        this.mType = array.getInt(R.styleable.QMUIProgressBar_qmui_type, 0);
        this.mProgressColor = array.getColor(R.styleable.QMUIProgressBar_qmui_progress_color, -16776961);
        this.mBackgroundColor = array.getColor(R.styleable.QMUIProgressBar_qmui_background_color, -7829368);
        this.mMaxValue = array.getInt(R.styleable.QMUIProgressBar_qmui_max_value, 100);
        this.mValue = array.getInt(R.styleable.QMUIProgressBar_qmui_value, 0);
        this.mRoundCap = array.getBoolean(R.styleable.QMUIProgressBar_qmui_stroke_round_cap, false);
        this.mTextSize = 20;
        if (array.hasValue(R.styleable.QMUIProgressBar_android_textSize)) {
            this.mTextSize = array.getDimensionPixelSize(R.styleable.QMUIProgressBar_android_textSize, 20);
        }
        this.mTextColor = -16777216;
        if (array.hasValue(R.styleable.QMUIProgressBar_android_textColor)) {
            this.mTextColor = array.getColor(R.styleable.QMUIProgressBar_android_textColor, -16777216);
        }
        if (this.mType == 2 || this.mType == 3) {
            this.mStrokeWidth = array.getDimensionPixelSize(R.styleable.QMUIProgressBar_qmui_stroke_width, DEFAULT_STROKE_WIDTH);
        }
        array.recycle();
        this.configPaint(this.mTextColor, this.mTextSize, this.mRoundCap, this.mStrokeWidth);
        this.setProgress(this.mValue);
    }

    public void setOnProgressChangeListener(OnProgressChangeListener onProgressChangeListener) {
        this.mOnProgressChangeListener = onProgressChangeListener;
    }

    public void setStrokeWidth(int strokeWidth) {
        if (this.mStrokeWidth != strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            if (this.mWidth > 0) {
                this.configShape();
            }
            this.configPaint(this.mTextColor, this.mTextSize, this.mRoundCap, this.mStrokeWidth);
            this.invalidate();
        }
    }

    private void configShape() {
        if (this.mType == 0 || this.mType == 1) {
            this.mBgRect = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.mWidth + this.getPaddingLeft()), (float)(this.mHeight + this.getPaddingTop()));
            this.mProgressRect = new RectF();
        } else {
            this.mCircleRadius = (float)(Math.min(this.mWidth, this.mHeight) - this.mStrokeWidth) / 2.0f - 0.5f;
            this.mCenterPoint = new Point(this.mWidth / 2, this.mHeight / 2);
        }
    }

    private void configPaint(int textColor, int textSize, boolean isRoundCap, int strokeWidth) {
        this.mPaint.setColor(this.mProgressColor);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        if (this.mType == 0 || this.mType == 1) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setStrokeCap(Paint.Cap.BUTT);
            this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        } else if (this.mType == 3) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStrokeCap(Paint.Cap.BUTT);
            this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
            this.mBackgroundPaint.setStrokeWidth((float)strokeWidth);
            this.mBackgroundPaint.setAntiAlias(true);
        } else {
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)strokeWidth);
            this.mPaint.setAntiAlias(true);
            if (isRoundCap) {
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            } else {
                this.mPaint.setStrokeCap(Paint.Cap.BUTT);
            }
            this.mBackgroundPaint.setStyle(Paint.Style.STROKE);
            this.mBackgroundPaint.setStrokeWidth((float)strokeWidth);
            this.mBackgroundPaint.setAntiAlias(true);
        }
        this.mTextPaint.setColor(textColor);
        this.mTextPaint.setTextSize((float)textSize);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
    }

    public void setType(int type) {
        this.mType = type;
        this.configPaint(this.mTextColor, this.mTextSize, this.mRoundCap, this.mStrokeWidth);
        this.invalidate();
    }

    public void setBarColor(int backgroundColor, int progressColor) {
        this.mBackgroundColor = backgroundColor;
        this.mProgressColor = progressColor;
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mPaint.setColor(this.mProgressColor);
        this.invalidate();
    }

    public void setBackgroundColor(int backgroundColor) {
        this.mBackgroundColor = backgroundColor;
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.invalidate();
    }

    public void setProgressColor(int progressColor) {
        this.mProgressColor = progressColor;
        this.mPaint.setColor(this.mProgressColor);
        this.invalidate();
    }

    public void setTextSize(int textSize) {
        this.mTextPaint.setTextSize((float)textSize);
        this.invalidate();
    }

    public void setTextColor(int textColor) {
        this.mTextPaint.setColor(textColor);
        this.invalidate();
    }

    public void setStrokeRoundCap(boolean isRoundCap) {
        this.mPaint.setStrokeCap(isRoundCap ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.invalidate();
    }

    public void setQMUIProgressBarTextGenerator(QMUIProgressBarTextGenerator QMUIProgressBarTextGenerator2) {
        this.mQMUIProgressBarTextGenerator = QMUIProgressBarTextGenerator2;
    }

    public QMUIProgressBarTextGenerator getQMUIProgressBarTextGenerator() {
        return this.mQMUIProgressBarTextGenerator;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mPendingValue != -1) {
            long elapsed = System.currentTimeMillis() - this.mAnimationStartTime;
            if (elapsed >= (long)this.mAnimationDuration) {
                this.mValue = this.mPendingValue;
                this.post(this.mNotifyProgressChangeAction);
                this.mPendingValue = -1;
            } else {
                this.mValue = (int)((float)this.mPendingValue - (1.0f - (float)elapsed / (float)this.mAnimationDuration) * (float)this.mAnimationDistance);
                this.post(this.mNotifyProgressChangeAction);
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }
        if (this.mQMUIProgressBarTextGenerator != null) {
            this.mText = this.mQMUIProgressBarTextGenerator.generateText(this, this.mValue, this.mMaxValue);
        }
        if ((this.mType == 0 || this.mType == 1) && this.mBgRect == null || (this.mType == 2 || this.mType == 3) && this.mCenterPoint == null) {
            this.configShape();
        }
        if (this.mType == 0) {
            this.drawRect(canvas);
        } else if (this.mType == 1) {
            this.drawRoundRect(canvas);
        } else {
            this.drawCircle(canvas, this.mType == 3);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        this.mHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        this.configShape();
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    private void drawRect(Canvas canvas) {
        canvas.drawRect(this.mBgRect, this.mBackgroundPaint);
        this.mProgressRect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getPaddingLeft() + this.parseValueToWidth()), (float)(this.getPaddingTop() + this.mHeight));
        canvas.drawRect(this.mProgressRect, this.mPaint);
        if (this.mText != null && this.mText.length() > 0) {
            Paint.FontMetricsInt fontMetrics = this.mTextPaint.getFontMetricsInt();
            float baseline = this.mBgRect.top + (this.mBgRect.height() - (float)fontMetrics.bottom + (float)fontMetrics.top) / 2.0f - (float)fontMetrics.top;
            canvas.drawText(this.mText, this.mBgRect.centerX(), baseline, this.mTextPaint);
        }
    }

    private void drawRoundRect(Canvas canvas) {
        float round = (float)this.mHeight / 2.0f;
        canvas.drawRoundRect(this.mBgRect, round, round, this.mBackgroundPaint);
        this.mProgressRect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getPaddingLeft() + this.parseValueToWidth()), (float)(this.getPaddingTop() + this.mHeight));
        canvas.drawRoundRect(this.mProgressRect, round, round, this.mPaint);
        if (this.mText != null && this.mText.length() > 0) {
            Paint.FontMetricsInt fontMetrics = this.mTextPaint.getFontMetricsInt();
            float baseline = this.mBgRect.top + (this.mBgRect.height() - (float)fontMetrics.bottom + (float)fontMetrics.top) / 2.0f - (float)fontMetrics.top;
            canvas.drawText(this.mText, this.mBgRect.centerX(), baseline, this.mTextPaint);
        }
    }

    private void drawCircle(Canvas canvas, boolean useCenter) {
        canvas.drawCircle((float)this.mCenterPoint.x, (float)this.mCenterPoint.y, this.mCircleRadius, this.mBackgroundPaint);
        this.mArcOval.left = (float)this.mCenterPoint.x - this.mCircleRadius;
        this.mArcOval.right = (float)this.mCenterPoint.x + this.mCircleRadius;
        this.mArcOval.top = (float)this.mCenterPoint.y - this.mCircleRadius;
        this.mArcOval.bottom = (float)this.mCenterPoint.y + this.mCircleRadius;
        if (this.mValue > 0) {
            canvas.drawArc(this.mArcOval, 270.0f, 360.0f * (float)this.mValue / (float)this.mMaxValue, useCenter, this.mPaint);
        }
        if (this.mText != null && this.mText.length() > 0) {
            Paint.FontMetricsInt fontMetrics = this.mTextPaint.getFontMetricsInt();
            float baseline = this.mArcOval.top + (this.mArcOval.height() - (float)fontMetrics.bottom + (float)fontMetrics.top) / 2.0f - (float)fontMetrics.top;
            canvas.drawText(this.mText, (float)this.mCenterPoint.x, baseline, this.mTextPaint);
        }
    }

    private int parseValueToWidth() {
        return this.mWidth * this.mValue / this.mMaxValue;
    }

    public int getProgress() {
        return this.mValue;
    }

    public void setProgress(int progress) {
        this.setProgress(progress, true);
    }

    public void setProgress(int progress, boolean animated) {
        if (progress > this.mMaxValue || progress < 0) {
            return;
        }
        if (this.mPendingValue == -1 && this.mValue == progress || this.mPendingValue != -1 && this.mPendingValue == progress) {
            return;
        }
        if (!animated) {
            this.mPendingValue = -1;
            this.mValue = progress;
            this.mNotifyProgressChangeAction.run();
            this.invalidate();
        } else {
            this.mAnimationDuration = Math.abs((int)((float)(1000 * (this.mValue - progress)) / (float)this.mMaxValue));
            this.mAnimationStartTime = System.currentTimeMillis();
            this.mAnimationDistance = progress - this.mValue;
            this.mPendingValue = progress;
            this.invalidate();
        }
    }

    public int getMaxValue() {
        return this.mMaxValue;
    }

    public void setMaxValue(int maxValue) {
        this.mMaxValue = maxValue;
    }

    public static interface OnProgressChangeListener {
        public void onProgressChange(QMUIProgressBar var1, int var2, int var3);
    }

    public static interface QMUIProgressBarTextGenerator {
        public String generateText(QMUIProgressBar var1, int var2, int var3);
    }
}

