/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.view.LayoutInflater;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDialog;
import androidx.core.view.LayoutInflaterCompat;
import com.qmuiteam.qmui.skin.QMUISkinLayoutInflaterFactory;
import com.qmuiteam.qmui.skin.QMUISkinManager;

public class QMUIBaseDialog
extends AppCompatDialog {
    boolean cancelable = true;
    private boolean canceledOnTouchOutside = true;
    private boolean canceledOnTouchOutsideSet;
    private QMUISkinManager mSkinManager = null;

    public QMUIBaseDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        this.supportRequestWindowFeature(1);
    }

    public void setSkinManager(@Nullable QMUISkinManager skinManager) {
        if (this.mSkinManager != null) {
            this.mSkinManager.unRegister((Dialog)this);
        }
        this.mSkinManager = skinManager;
        if (this.isShowing() && skinManager != null) {
            this.mSkinManager.register((Dialog)this);
        }
    }

    protected void onStart() {
        super.onStart();
        if (this.mSkinManager != null) {
            this.mSkinManager.register((Dialog)this);
        }
    }

    @NonNull
    public LayoutInflater getLayoutInflater() {
        LayoutInflater layoutInflater = super.getLayoutInflater();
        LayoutInflater.Factory2 factory2 = layoutInflater.getFactory2();
        if (factory2 instanceof QMUISkinLayoutInflaterFactory) {
            LayoutInflaterCompat.setFactory2((LayoutInflater)layoutInflater, (LayoutInflater.Factory2)((QMUISkinLayoutInflaterFactory)factory2).cloneForLayoutInflaterIfNeeded(layoutInflater));
        }
        return layoutInflater;
    }

    protected void onStop() {
        super.onStop();
        if (this.mSkinManager != null) {
            this.mSkinManager.unRegister((Dialog)this);
        }
    }

    public void setCancelable(boolean cancelable) {
        super.setCancelable(cancelable);
        if (this.cancelable != cancelable) {
            this.cancelable = cancelable;
            this.onSetCancelable(cancelable);
        }
    }

    protected void onSetCancelable(boolean cancelable) {
    }

    public void setCanceledOnTouchOutside(boolean cancel) {
        super.setCanceledOnTouchOutside(cancel);
        if (cancel && !this.cancelable) {
            this.cancelable = true;
        }
        this.canceledOnTouchOutside = cancel;
        this.canceledOnTouchOutsideSet = true;
    }

    protected boolean shouldWindowCloseOnTouchOutside() {
        if (!this.canceledOnTouchOutsideSet) {
            TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16843611});
            this.canceledOnTouchOutside = a.getBoolean(0, true);
            a.recycle();
            this.canceledOnTouchOutsideSet = true;
        }
        return this.canceledOnTouchOutside;
    }

    public void dismiss() {
        Context context = this.getContext();
        if (context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            if (activity.isDestroyed() || activity.isFinishing()) {
                return;
            }
            super.dismiss();
        } else {
            try {
                super.dismiss();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

