/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIPriorityLinearLayout;
import com.qmuiteam.qmui.util.QMUIWindowInsetHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBaseDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetBaseBuilder;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetBehavior;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetGridItemModel;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetGridItemView;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetGridLineLayout;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetListAdapter;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetListItemDecoration;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetListItemModel;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetRootLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class QMUIBottomSheet
extends QMUIBaseDialog {
    private static final String TAG = "QMUIBottomSheet";
    private QMUIBottomSheetRootLayout mRootView;
    private OnBottomSheetShowListener mOnBottomSheetShowListener;
    private QMUIBottomSheetBehavior<QMUIBottomSheetRootLayout> mBehavior;
    private boolean mAnimateToCancel = false;
    private boolean mAnimateToDismiss = false;

    public QMUIBottomSheet(Context context) {
        this(context, R.style.QMUI_BottomSheet);
    }

    public QMUIBottomSheet(Context context, int style2) {
        super(context, style2);
        ViewGroup container = (ViewGroup)this.getLayoutInflater().inflate(R.layout.qmui_bottom_sheet_dialog, null);
        this.mRootView = (QMUIBottomSheetRootLayout)container.findViewById(R.id.bottom_sheet);
        this.mBehavior = new QMUIBottomSheetBehavior();
        this.mBehavior.setHideable(this.cancelable);
        this.mBehavior.addBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

            public void onStateChanged(@NonNull View bottomSheet, int newState) {
                if (newState == 5) {
                    if (QMUIBottomSheet.this.mAnimateToCancel) {
                        QMUIBottomSheet.this.cancel();
                    } else if (QMUIBottomSheet.this.mAnimateToDismiss) {
                        QMUIBottomSheet.this.dismiss();
                    } else {
                        QMUIBottomSheet.this.cancel();
                    }
                }
            }

            public void onSlide(@NonNull View bottomSheet, float slideOffset) {
            }
        });
        this.mBehavior.setPeekHeight(0);
        this.mBehavior.setAllowDrag(false);
        this.mBehavior.setSkipCollapsed(true);
        CoordinatorLayout.LayoutParams rootViewLp = (CoordinatorLayout.LayoutParams)this.mRootView.getLayoutParams();
        rootViewLp.setBehavior(this.mBehavior);
        container.findViewById(R.id.touch_outside).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (QMUIBottomSheet.this.mBehavior.getState() == 2) {
                    return;
                }
                if (QMUIBottomSheet.this.cancelable && QMUIBottomSheet.this.isShowing() && QMUIBottomSheet.this.shouldWindowCloseOnTouchOutside()) {
                    QMUIBottomSheet.this.cancel();
                }
            }
        });
        this.mRootView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                return true;
            }
        });
        super.setContentView((View)container, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    protected void onSetCancelable(boolean cancelable) {
        super.onSetCancelable(cancelable);
        this.mBehavior.setHideable(cancelable);
    }

    public void setFitNav(boolean fitNav) {
        if (fitNav) {
            this.mRootView.setFitsSystemWindows(true);
            QMUIWindowInsetHelper.handleWindowInsets((View)this.mRootView, WindowInsetsCompat.Type.navigationBars(), this.getInsetHandler(), true, true, false);
        } else {
            this.mRootView.setFitsSystemWindows(false);
            QMUIWindowInsetHelper.setOnApplyWindowInsetsListener((View)this.mRootView, null, true);
        }
        this.mRootView.requestApplyInsets();
    }

    protected QMUIWindowInsetHelper.InsetHandler getInsetHandler() {
        return QMUIWindowInsetHelper.consumeInsetWithPaddingHandler;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        if (window != null) {
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setLayout(-1, -1);
        }
        ViewCompat.requestApplyInsets((View)this.mRootView);
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.mBehavior.getState() == 5) {
            this.mBehavior.setState(4);
        }
    }

    public void cancel() {
        if (this.mBehavior.getState() == 5) {
            this.mAnimateToCancel = false;
            super.cancel();
        } else {
            this.mAnimateToCancel = true;
            this.mBehavior.setState(5);
        }
    }

    @Override
    public void dismiss() {
        if (this.mBehavior.getState() == 5) {
            this.mAnimateToDismiss = false;
            super.dismiss();
        } else {
            this.mAnimateToDismiss = true;
            this.mBehavior.setState(5);
        }
    }

    public void setOnBottomSheetShowListener(OnBottomSheetShowListener onBottomSheetShowListener) {
        this.mOnBottomSheetShowListener = onBottomSheetShowListener;
    }

    public void setRadius(int radius) {
        this.mRootView.setRadius(radius, 3);
    }

    public QMUIBottomSheetRootLayout getRootView() {
        return this.mRootView;
    }

    public QMUIBottomSheetBehavior<QMUIBottomSheetRootLayout> getBehavior() {
        return this.mBehavior;
    }

    public void show() {
        super.show();
        if (this.mOnBottomSheetShowListener != null) {
            this.mOnBottomSheetShowListener.onShow();
        }
        if (this.mBehavior.getState() != 3) {
            this.setToExpandWhenShow();
        }
        this.mAnimateToCancel = false;
        this.mAnimateToDismiss = false;
    }

    protected void setToExpandWhenShow() {
        this.mRootView.postOnAnimation(new Runnable(){

            @Override
            public void run() {
                QMUIBottomSheet.this.mBehavior.setState(3);
            }
        });
    }

    public void setContentView(View view) {
        throw new IllegalStateException("Use addContentView(View, ConstraintLayout.LayoutParams) for replacement");
    }

    public void setContentView(int layoutResId) {
        throw new IllegalStateException("Use addContentView(int) for replacement");
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        throw new IllegalStateException("Use addContentView(View, QMUIPriorityLinearLayout.LayoutParams) for replacement");
    }

    public void addContentView(View view, ViewGroup.LayoutParams params) {
        throw new IllegalStateException("Use addContentView(View, QMUIPriorityLinearLayout.LayoutParams) for replacement");
    }

    public void addContentView(View view, QMUIPriorityLinearLayout.LayoutParams layoutParams) {
        this.mRootView.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public void addContentView(View view) {
        QMUIPriorityLinearLayout.LayoutParams lp = new QMUIPriorityLinearLayout.LayoutParams(-1, -2);
        lp.setPriority(1);
        this.mRootView.addView(view, (ViewGroup.LayoutParams)lp);
    }

    public void addContentView(int layoutResId) {
        LayoutInflater.from((Context)this.mRootView.getContext()).inflate(layoutResId, (ViewGroup)this.mRootView, true);
    }

    public static class BottomGridSheetBuilder
    extends QMUIBottomSheetBaseBuilder<BottomGridSheetBuilder>
    implements View.OnClickListener {
        public static final int FIRST_LINE = 0;
        public static final int SECOND_LINE = 1;
        public static final ItemViewFactory DEFAULT_ITEM_VIEW_FACTORY = new DefaultItemViewFactory();
        private ArrayList<QMUIBottomSheetGridItemModel> mFirstLineItems;
        private ArrayList<QMUIBottomSheetGridItemModel> mSecondLineItems;
        private ItemViewFactory mItemViewFactory = DEFAULT_ITEM_VIEW_FACTORY;
        private OnSheetItemClickListener mOnSheetItemClickListener;
        private QMUIBottomSheetGridLineLayout.ItemWidthCalculator mItemWidthCalculator = null;
        private int mLineGravity = 16;

        public BottomGridSheetBuilder(Context context) {
            super(context);
            this.mFirstLineItems = new ArrayList();
            this.mSecondLineItems = new ArrayList();
        }

        public BottomGridSheetBuilder setLineGravity(int gravity) {
            this.mLineGravity = gravity;
            return this;
        }

        public BottomGridSheetBuilder addItem(@NonNull QMUIBottomSheetGridItemModel model, int style2) {
            switch (style2) {
                case 0: {
                    this.mFirstLineItems.add(model);
                    break;
                }
                case 1: {
                    this.mSecondLineItems.add(model);
                }
            }
            return this;
        }

        public BottomGridSheetBuilder addItem(int imageRes, CharSequence textAndTag, int style2) {
            return this.addItem(imageRes, textAndTag, textAndTag, style2, 0);
        }

        public BottomGridSheetBuilder addItem(int imageRes, CharSequence text, Object tag, int style2) {
            return this.addItem(imageRes, text, tag, style2, 0);
        }

        public BottomGridSheetBuilder addItem(int imageRes, CharSequence text, Object tag, int style2, int subscriptRes) {
            return this.addItem(imageRes, text, tag, style2, subscriptRes, null);
        }

        public BottomGridSheetBuilder addItem(int imageRes, CharSequence text, Object tag, int style2, int subscriptRes, Typeface typeface) {
            return this.addItem(new QMUIBottomSheetGridItemModel(text, tag).image(imageRes).subscript(subscriptRes).typeface(typeface), style2);
        }

        public void setItemViewFactory(ItemViewFactory itemViewFactory) {
            this.mItemViewFactory = itemViewFactory;
        }

        public BottomGridSheetBuilder setOnSheetItemClickListener(OnSheetItemClickListener onSheetItemClickListener) {
            this.mOnSheetItemClickListener = onSheetItemClickListener;
            return this;
        }

        public BottomGridSheetBuilder setItemWidthCalculator(QMUIBottomSheetGridLineLayout.ItemWidthCalculator itemWidthCalculator) {
            this.mItemWidthCalculator = itemWidthCalculator;
            return this;
        }

        public void onClick(View v) {
            if (this.mOnSheetItemClickListener != null) {
                this.mOnSheetItemClickListener.onClick(this.mDialog, v);
            }
        }

        @Override
        @Nullable
        protected View onCreateContentView(@NonNull QMUIBottomSheet bottomSheet, @NonNull QMUIBottomSheetRootLayout rootLayout, @NonNull Context context) {
            QMUIBottomSheetGridItemView itemView;
            if (this.mFirstLineItems.isEmpty() && this.mSecondLineItems.isEmpty()) {
                return null;
            }
            ArrayList<Pair<View, LinearLayout.LayoutParams>> firstLines = null;
            ArrayList<Pair<View, LinearLayout.LayoutParams>> secondLines = null;
            int wrapContent = -2;
            if (!this.mFirstLineItems.isEmpty()) {
                firstLines = new ArrayList<Pair<View, LinearLayout.LayoutParams>>();
                for (QMUIBottomSheetGridItemModel model : this.mFirstLineItems) {
                    itemView = this.mItemViewFactory.create(bottomSheet, model);
                    itemView.setOnClickListener(this);
                    firstLines.add((Pair<View, LinearLayout.LayoutParams>)new Pair((Object)itemView, (Object)new LinearLayout.LayoutParams(wrapContent, wrapContent)));
                }
            }
            if (!this.mSecondLineItems.isEmpty()) {
                secondLines = new ArrayList<Pair<View, LinearLayout.LayoutParams>>();
                for (QMUIBottomSheetGridItemModel model : this.mSecondLineItems) {
                    itemView = this.mItemViewFactory.create(bottomSheet, model);
                    itemView.setOnClickListener(this);
                    secondLines.add((Pair<View, LinearLayout.LayoutParams>)new Pair((Object)itemView, (Object)new LinearLayout.LayoutParams(wrapContent, wrapContent)));
                }
            }
            return new QMUIBottomSheetGridLineLayout(this.mDialog, this.mItemWidthCalculator, this.mLineGravity, firstLines, secondLines);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Style {
        }

        public static interface OnSheetItemClickListener {
            public void onClick(QMUIBottomSheet var1, View var2);
        }

        public static class DefaultItemViewFactory
        implements ItemViewFactory {
            @Override
            public QMUIBottomSheetGridItemView create(@NonNull QMUIBottomSheet bottomSheet, @NonNull QMUIBottomSheetGridItemModel model) {
                QMUIBottomSheetGridItemView itemView = new QMUIBottomSheetGridItemView(bottomSheet.getContext());
                itemView.render(model);
                return itemView;
            }
        }

        public static interface ItemViewFactory {
            public QMUIBottomSheetGridItemView create(QMUIBottomSheet var1, QMUIBottomSheetGridItemModel var2);
        }
    }

    public static class BottomListSheetBuilder
    extends QMUIBottomSheetBaseBuilder<BottomListSheetBuilder> {
        private List<QMUIBottomSheetListItemModel> mItems = new ArrayList<QMUIBottomSheetListItemModel>();
        private List<View> mContentHeaderViews;
        private List<View> mContentFooterViews;
        private boolean mNeedRightMark;
        private int mCheckedIndex;
        private boolean mGravityCenter = false;
        private OnSheetItemClickListener mOnSheetItemClickListener;

        public BottomListSheetBuilder(Context context) {
            this(context, false);
        }

        public BottomListSheetBuilder(Context context, boolean needRightMark) {
            super(context);
            this.mNeedRightMark = needRightMark;
        }

        public BottomListSheetBuilder setCheckedIndex(int checkedIndex) {
            this.mCheckedIndex = checkedIndex;
            return this;
        }

        public BottomListSheetBuilder setNeedRightMark(boolean needRightMark) {
            this.mNeedRightMark = needRightMark;
            return this;
        }

        public BottomListSheetBuilder setGravityCenter(boolean gravityCenter) {
            this.mGravityCenter = gravityCenter;
            return this;
        }

        public BottomListSheetBuilder setOnSheetItemClickListener(OnSheetItemClickListener onSheetItemClickListener) {
            this.mOnSheetItemClickListener = onSheetItemClickListener;
            return this;
        }

        public BottomListSheetBuilder addItem(QMUIBottomSheetListItemModel itemModel) {
            this.mItems.add(itemModel);
            return this;
        }

        public BottomListSheetBuilder addItem(String textAndTag) {
            this.mItems.add(new QMUIBottomSheetListItemModel(textAndTag, textAndTag));
            return this;
        }

        public BottomListSheetBuilder addItem(Drawable image, String textAndTag) {
            this.mItems.add(new QMUIBottomSheetListItemModel(textAndTag, textAndTag).image(image));
            return this;
        }

        public BottomListSheetBuilder addItem(String text, String tag) {
            this.mItems.add(new QMUIBottomSheetListItemModel(text, tag));
            return this;
        }

        public BottomListSheetBuilder addItem(int imageRes, String text, String tag) {
            this.mItems.add(new QMUIBottomSheetListItemModel(text, tag).image(imageRes));
            return this;
        }

        public BottomListSheetBuilder addItem(int imageRes, String text, String tag, boolean hasRedPoint) {
            this.mItems.add(new QMUIBottomSheetListItemModel(text, tag).image(imageRes).redPoint(hasRedPoint));
            return this;
        }

        public BottomListSheetBuilder addItem(int imageRes, CharSequence text, String tag, boolean hasRedPoint, boolean disabled) {
            this.mItems.add(new QMUIBottomSheetListItemModel(text, tag).image(imageRes).redPoint(hasRedPoint).disabled(disabled));
            return this;
        }

        @Deprecated
        public BottomListSheetBuilder addHeaderView(@NonNull View view) {
            return this.addContentHeaderView(view);
        }

        public BottomListSheetBuilder addContentHeaderView(@NonNull View view) {
            if (this.mContentHeaderViews == null) {
                this.mContentHeaderViews = new ArrayList<View>();
            }
            this.mContentHeaderViews.add(view);
            return this;
        }

        public BottomListSheetBuilder addContentFooterView(@NonNull View view) {
            if (this.mContentFooterViews == null) {
                this.mContentFooterViews = new ArrayList<View>();
            }
            this.mContentFooterViews.add(view);
            return this;
        }

        @Override
        @Nullable
        protected View onCreateContentView(final @NonNull QMUIBottomSheet bottomSheet, @NonNull QMUIBottomSheetRootLayout rootLayout, @NonNull Context context) {
            RecyclerView recyclerView = new RecyclerView(context);
            recyclerView.setOverScrollMode(2);
            QMUIBottomSheetListAdapter adapter = new QMUIBottomSheetListAdapter(this.mNeedRightMark, this.mGravityCenter);
            recyclerView.setAdapter((RecyclerView.Adapter)adapter);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context){

                public RecyclerView.LayoutParams generateDefaultLayoutParams() {
                    return new RecyclerView.LayoutParams(-1, -2);
                }
            });
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new QMUIBottomSheetListItemDecoration(context));
            LinearLayout headerView = null;
            if (this.mContentHeaderViews != null && this.mContentHeaderViews.size() > 0) {
                headerView = new LinearLayout(context);
                headerView.setOrientation(1);
                for (View view : this.mContentHeaderViews) {
                    if (view.getParent() != null) {
                        ((ViewGroup)view.getParent()).removeView(view);
                    }
                    headerView.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                }
            }
            LinearLayout footerView = null;
            if (this.mContentFooterViews != null && this.mContentFooterViews.size() > 0) {
                footerView = new LinearLayout(context);
                footerView.setOrientation(1);
                for (View view : this.mContentFooterViews) {
                    if (view.getParent() != null) {
                        ((ViewGroup)view.getParent()).removeView(view);
                    }
                    footerView.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                }
            }
            adapter.setData((View)headerView, (View)footerView, this.mItems);
            adapter.setOnItemClickListener(new QMUIBottomSheetListAdapter.OnItemClickListener(){

                @Override
                public void onClick(QMUIBottomSheetListAdapter.VH vh, int dataPos, QMUIBottomSheetListItemModel model) {
                    if (mOnSheetItemClickListener != null) {
                        mOnSheetItemClickListener.onClick(bottomSheet, vh.itemView, dataPos, model.tag);
                    }
                }
            });
            adapter.setCheckedIndex(this.mCheckedIndex);
            recyclerView.scrollToPosition(this.mCheckedIndex + (headerView == null ? 0 : 1));
            return recyclerView;
        }

        public static interface OnSheetItemClickListener {
            public void onClick(QMUIBottomSheet var1, View var2, int var3, String var4);
        }
    }

    public static interface OnBottomSheetShowListener {
        public void onShow();
    }
}

