/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIButton;
import com.qmuiteam.qmui.layout.QMUIPriorityLinearLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheet;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetBehavior;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetRootLayout;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

public abstract class QMUIBottomSheetBaseBuilder<T extends QMUIBottomSheetBaseBuilder> {
    private Context mContext;
    protected QMUIBottomSheet mDialog;
    private CharSequence mTitle;
    private boolean mAddCancelBtn;
    private String mCancelText;
    private DialogInterface.OnDismissListener mOnBottomDialogDismissListener;
    private int mRadius = -1;
    private boolean mAllowDrag = false;
    private QMUISkinManager mSkinManager;
    private QMUIBottomSheetBehavior.DownDragDecisionMaker mDownDragDecisionMaker = null;
    private boolean fitNav = true;

    public QMUIBottomSheetBaseBuilder(Context context) {
        this.mContext = context;
    }

    public T setTitle(CharSequence title) {
        this.mTitle = title;
        return (T)this;
    }

    protected boolean hasTitle() {
        return this.mTitle != null && this.mTitle.length() != 0;
    }

    public T setAllowDrag(boolean allowDrag) {
        this.mAllowDrag = allowDrag;
        return (T)this;
    }

    public T setSkinManager(@Nullable QMUISkinManager skinManager) {
        this.mSkinManager = skinManager;
        return (T)this;
    }

    public T setFitNav(boolean fitNav) {
        this.fitNav = fitNav;
        return (T)this;
    }

    public T setDownDragDecisionMaker(QMUIBottomSheetBehavior.DownDragDecisionMaker downDragDecisionMaker) {
        this.mDownDragDecisionMaker = downDragDecisionMaker;
        return (T)this;
    }

    public T setAddCancelBtn(boolean addCancelBtn) {
        this.mAddCancelBtn = addCancelBtn;
        return (T)this;
    }

    public T setCancelText(String cancelText) {
        this.mCancelText = cancelText;
        return (T)this;
    }

    public T setRadius(int radius) {
        this.mRadius = radius;
        return (T)this;
    }

    public T setOnBottomDialogDismissListener(DialogInterface.OnDismissListener listener) {
        this.mOnBottomDialogDismissListener = listener;
        return (T)this;
    }

    public QMUIBottomSheet build() {
        return this.build(R.style.QMUI_BottomSheet);
    }

    public QMUIBottomSheet build(int style2) {
        this.mDialog = new QMUIBottomSheet(this.mContext, style2);
        Context dialogContext = this.mDialog.getContext();
        QMUIBottomSheetRootLayout rootLayout = this.mDialog.getRootView();
        rootLayout.removeAllViews();
        View titleView = this.onCreateTitleView(this.mDialog, rootLayout, dialogContext);
        if (titleView != null) {
            this.mDialog.addContentView(titleView);
        }
        this.onAddCustomViewBetweenTitleAndContent(this.mDialog, rootLayout, dialogContext);
        View contentView = this.onCreateContentView(this.mDialog, rootLayout, dialogContext);
        if (contentView != null) {
            QMUIPriorityLinearLayout.LayoutParams lp = new QMUIPriorityLinearLayout.LayoutParams(-1, -2);
            lp.setPriority(1);
            this.mDialog.addContentView(contentView, lp);
        }
        this.onAddCustomViewAfterContent(this.mDialog, rootLayout, dialogContext);
        if (this.mAddCancelBtn) {
            this.mDialog.addContentView(this.onCreateCancelBtn(this.mDialog, rootLayout, dialogContext), new QMUIPriorityLinearLayout.LayoutParams(-1, QMUIResHelper.getAttrDimen(dialogContext, R.attr.qmui_bottom_sheet_cancel_btn_height)));
        }
        if (this.mOnBottomDialogDismissListener != null) {
            this.mDialog.setOnDismissListener(this.mOnBottomDialogDismissListener);
        }
        if (this.mRadius != -1) {
            this.mDialog.setRadius(this.mRadius);
        }
        this.mDialog.setSkinManager(this.mSkinManager);
        this.mDialog.setFitNav(this.fitNav);
        QMUIBottomSheetBehavior<QMUIBottomSheetRootLayout> behavior = this.mDialog.getBehavior();
        behavior.setAllowDrag(this.mAllowDrag);
        behavior.setDownDragDecisionMaker(this.mDownDragDecisionMaker);
        return this.mDialog;
    }

    @Nullable
    protected View onCreateTitleView(@NonNull QMUIBottomSheet bottomSheet, @NonNull QMUIBottomSheetRootLayout rootLayout, @NonNull Context context) {
        if (this.hasTitle()) {
            QMUISpanTouchFixTextView tv = new QMUISpanTouchFixTextView(context);
            tv.setId(R.id.qmui_bottom_sheet_title);
            tv.setText(this.mTitle);
            tv.onlyShowBottomDivider(0, 0, 1, QMUIResHelper.getAttrColor(context, R.attr.qmui_skin_support_bottom_sheet_separator_color));
            QMUIResHelper.assignTextViewWithAttr((TextView)tv, R.attr.qmui_bottom_sheet_title_style);
            QMUISkinValueBuilder valueBuilder = QMUISkinValueBuilder.acquire();
            valueBuilder.textColor(R.attr.qmui_skin_support_bottom_sheet_title_text_color);
            valueBuilder.bottomSeparator(R.attr.qmui_skin_support_bottom_sheet_separator_color);
            QMUISkinHelper.setSkinValue((View)tv, valueBuilder);
            valueBuilder.release();
            return tv;
        }
        return null;
    }

    protected void onAddCustomViewBetweenTitleAndContent(@NonNull QMUIBottomSheet bottomSheet, @NonNull QMUIBottomSheetRootLayout rootLayout, @NonNull Context context) {
    }

    @Nullable
    protected abstract View onCreateContentView(@NonNull QMUIBottomSheet var1, @NonNull QMUIBottomSheetRootLayout var2, @NonNull Context var3);

    protected void onAddCustomViewAfterContent(@NonNull QMUIBottomSheet bottomSheet, @NonNull QMUIBottomSheetRootLayout rootLayout, @NonNull Context context) {
    }

    @NonNull
    protected View onCreateCancelBtn(final @NonNull QMUIBottomSheet bottomSheet, @NonNull QMUIBottomSheetRootLayout rootLayout, @NonNull Context context) {
        QMUIButton button = new QMUIButton(context);
        button.setId(R.id.qmui_bottom_sheet_cancel);
        if (this.mCancelText == null || this.mCancelText.isEmpty()) {
            this.mCancelText = context.getString(R.string.qmui_cancel);
        }
        button.setPadding(0, 0, 0, 0);
        button.setBackground(QMUIResHelper.getAttrDrawable(context, R.attr.qmui_skin_support_bottom_sheet_cancel_bg));
        button.setText(this.mCancelText);
        QMUIResHelper.assignTextViewWithAttr((TextView)button, R.attr.qmui_bottom_sheet_cancel_style);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                bottomSheet.cancel();
            }
        });
        button.onlyShowTopDivider(0, 0, 1, QMUIResHelper.getAttrColor(context, R.attr.qmui_skin_support_bottom_sheet_separator_color));
        QMUISkinValueBuilder valueBuilder = QMUISkinValueBuilder.acquire();
        valueBuilder.textColor(R.attr.qmui_skin_support_bottom_sheet_cancel_text_color);
        valueBuilder.topSeparator(R.attr.qmui_skin_support_bottom_sheet_separator_color);
        valueBuilder.background(R.attr.qmui_skin_support_bottom_sheet_cancel_bg);
        QMUISkinHelper.setSkinValue((View)button, valueBuilder);
        valueBuilder.release();
        return button;
    }
}

