/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetListItemModel;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetListItemView;
import java.util.ArrayList;
import java.util.List;

public class QMUIBottomSheetListAdapter
extends RecyclerView.Adapter<VH> {
    public static final int ITEM_TYPE_HEADER = 1;
    public static final int ITEM_TYPE_FOOTER = 2;
    public static final int ITEM_TYPE_NORMAL = 3;
    @Nullable
    private View mHeaderView;
    @Nullable
    private View mFooterView;
    private List<QMUIBottomSheetListItemModel> mData = new ArrayList<QMUIBottomSheetListItemModel>();
    private final boolean mNeedMark;
    private final boolean mGravityCenter;
    private int mCheckedIndex = -1;
    private OnItemClickListener mOnItemClickListener;

    public QMUIBottomSheetListAdapter(boolean needMark, boolean gravityCenter) {
        this.mNeedMark = needMark;
        this.mGravityCenter = gravityCenter;
    }

    public void setCheckedIndex(int checkedIndex) {
        this.mCheckedIndex = checkedIndex;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void setData(@Nullable View headerView, @Nullable View footerView, List<QMUIBottomSheetListItemModel> data) {
        this.mHeaderView = headerView;
        this.mFooterView = footerView;
        this.mData.clear();
        if (data != null) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public int getItemViewType(int position) {
        if (this.mHeaderView != null && position == 0) {
            return 1;
        }
        if (position == this.getItemCount() - 1 && this.mFooterView != null) {
            return 2;
        }
        return 3;
    }

    @NonNull
    public VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new VH(this.mHeaderView);
        }
        if (viewType == 2) {
            return new VH(this.mFooterView);
        }
        final VH vh = new VH((View)new QMUIBottomSheetListItemView(parent.getContext(), this.mNeedMark, this.mGravityCenter));
        vh.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QMUIBottomSheetListAdapter.this.mOnItemClickListener != null) {
                    int adapterPosition = vh.getAdapterPosition();
                    int dataPos = QMUIBottomSheetListAdapter.this.mHeaderView != null ? adapterPosition - 1 : adapterPosition;
                    QMUIBottomSheetListAdapter.this.mOnItemClickListener.onClick(vh, dataPos, QMUIBottomSheetListAdapter.this.mData.get(dataPos));
                }
            }
        });
        return vh;
    }

    public void onBindViewHolder(@NonNull VH holder, int position) {
        if (holder.getItemViewType() != 3) {
            return;
        }
        if (this.mHeaderView != null) {
            --position;
        }
        QMUIBottomSheetListItemModel itemModel = this.mData.get(position);
        QMUIBottomSheetListItemView itemView = (QMUIBottomSheetListItemView)holder.itemView;
        itemView.render(itemModel, position == this.mCheckedIndex);
    }

    public int getItemCount() {
        return this.mData.size() + (this.mHeaderView != null ? 1 : 0) + (this.mFooterView != null ? 1 : 0);
    }

    public static interface OnItemClickListener {
        public void onClick(VH var1, int var2, QMUIBottomSheetListItemModel var3);
    }

    public static class VH
    extends RecyclerView.ViewHolder {
        public VH(@NonNull View itemView) {
            super(itemView);
        }
    }
}

