/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIWindowHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogView;

public class QMUIDialogRootLayout
extends ViewGroup {
    private QMUIDialogView mDialogView;
    private FrameLayout.LayoutParams mDialogViewLp;
    private int mMinWidth;
    private int mMaxWidth;
    private int mInsetHor;
    private int mInsetVer;
    private boolean mCheckKeyboardOverlay = false;
    private float mMaxPercent = 0.75f;
    private boolean isOverlayOccurEventNotified = false;
    private OverlayOccurInMeasureCallback mOverlayOccurInMeasureCallback;
    private int mLastContentInsetTop = 0;

    public QMUIDialogRootLayout(@NonNull Context context, @NonNull QMUIDialogView dialogView, @Nullable FrameLayout.LayoutParams dialogViewLp) {
        super(context);
        this.mDialogView = dialogView;
        if (dialogViewLp == null) {
            dialogViewLp = new FrameLayout.LayoutParams(-2, -2);
        }
        this.mDialogViewLp = dialogViewLp;
        this.addView((View)this.mDialogView, (ViewGroup.LayoutParams)dialogViewLp);
        this.mMinWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_min_width);
        this.mMaxWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_max_width);
        this.mInsetHor = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_inset_hor);
        this.mInsetVer = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_inset_ver);
        this.setId(R.id.qmui_dialog_root_layout);
    }

    public void setMinWidth(int minWidth) {
        this.mMinWidth = minWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxWidth = maxWidth;
    }

    public void setInsetHor(int insetHor) {
        this.mInsetHor = insetHor;
    }

    public void setInsetVer(int insetVer) {
        this.mInsetVer = insetVer;
    }

    public void setOverlayOccurInMeasureCallback(OverlayOccurInMeasureCallback overlayOccurInMeasureCallback) {
        this.mOverlayOccurInMeasureCallback = overlayOccurInMeasureCallback;
    }

    public void setCheckKeyboardOverlay(boolean checkKeyboardOverlay) {
        this.mCheckKeyboardOverlay = checkKeyboardOverlay;
    }

    public void setMaxPercent(float maxPercent) {
        this.mMaxPercent = maxPercent;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childHeightMeasureSpec;
        int childMaxWidth;
        int keyboardOverlayHeight = 0;
        int contentInsetVer = 0;
        if (this.mCheckKeyboardOverlay) {
            Rect visibleInsetRect = QMUIWindowHelper.unSafeGetWindowVisibleInsets((View)this);
            Rect contentInsetRect = QMUIWindowHelper.unSafeGetContentInsets((View)this);
            if (visibleInsetRect != null) {
                keyboardOverlayHeight = visibleInsetRect.bottom;
            }
            if (contentInsetRect != null) {
                this.mLastContentInsetTop = contentInsetRect.top;
                contentInsetVer = contentInsetRect.top + contentInsetRect.bottom;
            }
        }
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidthMeasureSpec = this.mDialogViewLp.width > 0 ? View.MeasureSpec.makeMeasureSpec((int)this.mDialogViewLp.width, (int)0x40000000) : ((childMaxWidth = Math.min(this.mMaxWidth, widthSize - 2 * this.mInsetHor)) <= this.mMinWidth ? View.MeasureSpec.makeMeasureSpec((int)this.mMinWidth, (int)0x40000000) : (this.mDialogViewLp.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)childMaxWidth, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)childMaxWidth, (int)Integer.MIN_VALUE)));
        if (this.mDialogViewLp.height > 0) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mDialogViewLp.height, (int)0x40000000);
        } else {
            int childMaxHeight;
            if (keyboardOverlayHeight > 0) {
                if (this.getRootView() != null && this.getRootView().getHeight() > 0) {
                    heightSize = this.getRootView().getHeight();
                    if (!this.isOverlayOccurEventNotified) {
                        this.isOverlayOccurEventNotified = true;
                        if (this.mOverlayOccurInMeasureCallback != null) {
                            this.mOverlayOccurInMeasureCallback.call();
                        }
                    }
                }
                childMaxHeight = Math.max(heightSize - 2 * this.mInsetVer - keyboardOverlayHeight - contentInsetVer, 0);
            } else {
                this.isOverlayOccurEventNotified = false;
                childMaxHeight = Math.min(heightSize - 2 * this.mInsetVer - contentInsetVer, (int)((float)QMUIDisplayHelper.getScreenHeight(this.getContext()) * this.mMaxPercent - (float)(2 * this.mInsetVer)));
            }
            childHeightMeasureSpec = this.mDialogViewLp.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)childMaxHeight, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)childMaxHeight, (int)Integer.MIN_VALUE);
        }
        this.mDialogView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        if (this.mDialogView.getMeasuredWidth() < this.mMinWidth) {
            childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMinWidth, (int)0x40000000);
            this.mDialogView.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
        this.setMeasuredDimension(this.mDialogView.getMeasuredWidth(), this.mDialogView.getMeasuredHeight() + 2 * this.mInsetVer + keyboardOverlayHeight + contentInsetVer);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int w = r - l;
        int childLeft = (w - this.mDialogView.getMeasuredWidth()) / 2;
        this.mDialogView.layout(childLeft, this.mInsetVer, childLeft + this.mDialogView.getMeasuredWidth(), this.mInsetVer + this.mDialogView.getMeasuredHeight());
    }

    public QMUIDialogView getDialogView() {
        return this.mDialogView;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mLastContentInsetTop > 0) {
            ev.offsetLocation(0.0f, (float)(-this.mLastContentInsetTop));
        }
        return super.dispatchTouchEvent(ev);
    }

    static interface OverlayOccurInMeasureCallback {
        public void call();
    }
}

