/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.popup;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIConstraintLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.QMUIRadiusImageView2;
import com.qmuiteam.qmui.widget.popup.QMUINormalPopup;
import java.util.ArrayList;
import java.util.Objects;

public class QMUIQuickAction
extends QMUINormalPopup<QMUIQuickAction> {
    private ArrayList<Action> mActions = new ArrayList();
    private int mActionWidth = -2;
    private int mActionHeight;
    private boolean mShowMoreArrowIfNeeded = true;
    private int mMoreArrowWidth;
    private int mPaddingHor;

    public QMUIQuickAction(Context context, int width, int height) {
        this(context, width, height, true);
    }

    public QMUIQuickAction(Context context, int width, int height, boolean forceMeasureIfNeeded) {
        super(context, width, height, forceMeasureIfNeeded);
        this.mActionHeight = height;
        this.mMoreArrowWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_quick_action_more_arrow_width);
        this.mPaddingHor = QMUIResHelper.getAttrDimen(context, R.attr.qmui_quick_action_padding_hor);
    }

    public QMUIQuickAction moreArrowWidth(int moreArrowWidth) {
        this.mMoreArrowWidth = moreArrowWidth;
        return this;
    }

    public QMUIQuickAction paddingHor(int paddingHor) {
        this.mPaddingHor = paddingHor;
        return this;
    }

    public QMUIQuickAction actionWidth(int actionWidth) {
        this.mActionWidth = actionWidth;
        return this;
    }

    public QMUIQuickAction actionHeight(int actionHeight) {
        this.mActionHeight = actionHeight;
        return this;
    }

    public QMUIQuickAction addAction(Action action) {
        this.mActions.add(action);
        return this;
    }

    public QMUIQuickAction showMoreArrowIfNeeded(boolean showMoreArrowIfNeeded) {
        this.mShowMoreArrowIfNeeded = showMoreArrowIfNeeded;
        return this;
    }

    @Override
    protected int proxyWidth(int width) {
        if (width > 0 && this.mActionWidth > 0) {
            if (width >= this.mActionWidth * this.mActions.size() + 2 * this.mPaddingHor) {
                return super.proxyWidth(width);
            }
            width = width - this.mPaddingHor - this.mMoreArrowWidth;
            return this.mActionWidth * (width / this.mActionWidth) + this.mPaddingHor + this.mMoreArrowWidth;
        }
        return super.proxyWidth(width);
    }

    @Override
    public QMUIQuickAction show(@NonNull View anchor) {
        return (QMUIQuickAction)super.show(anchor);
    }

    @Override
    public QMUIQuickAction show(@NonNull View anchor, int anchorAreaLeft, int anchorAreaTop, int anchorAreaRight, int anchorAreaBottom) {
        this.view((View)this.createContentView());
        return (QMUIQuickAction)super.show(anchor, anchorAreaLeft, anchorAreaTop, anchorAreaRight, anchorAreaBottom);
    }

    private ConstraintLayout createContentView() {
        ConstraintLayout wrapper = new ConstraintLayout(this.mContext);
        final RecyclerView recyclerView = new RecyclerView(this.mContext);
        LayoutManager layoutManager = new LayoutManager(this.mContext);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        recyclerView.setId(View.generateViewId());
        recyclerView.setPadding(this.mPaddingHor, 0, this.mPaddingHor, 0);
        recyclerView.setClipToPadding(false);
        final Adapter adapter = new Adapter();
        adapter.submitList(this.mActions);
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
        wrapper.addView((View)recyclerView);
        if (this.mShowMoreArrowIfNeeded) {
            AppCompatImageView leftMoreArrow = this.createMoreArrowView(true);
            AppCompatImageView rightMoreArrow = this.createMoreArrowView(false);
            leftMoreArrow.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    recyclerView.smoothScrollToPosition(0);
                }
            });
            rightMoreArrow.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    recyclerView.smoothScrollToPosition(adapter.getItemCount() - 1);
                }
            });
            ConstraintLayout.LayoutParams leftLp = new ConstraintLayout.LayoutParams(this.mMoreArrowWidth, 0);
            leftLp.leftToLeft = recyclerView.getId();
            leftLp.topToTop = recyclerView.getId();
            leftLp.bottomToBottom = recyclerView.getId();
            wrapper.addView((View)leftMoreArrow, (ViewGroup.LayoutParams)leftLp);
            ConstraintLayout.LayoutParams rightLp = new ConstraintLayout.LayoutParams(this.mMoreArrowWidth, 0);
            rightLp.rightToRight = recyclerView.getId();
            rightLp.topToTop = recyclerView.getId();
            rightLp.bottomToBottom = recyclerView.getId();
            wrapper.addView((View)rightMoreArrow, (ViewGroup.LayoutParams)rightLp);
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new ItemDecoration(leftMoreArrow, rightMoreArrow));
        }
        return wrapper;
    }

    protected AppCompatImageView createMoreArrowView(boolean isLeft) {
        QMUIRadiusImageView2 arrowView = new QMUIRadiusImageView2(this.mContext);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        if (isLeft) {
            arrowView.setPadding(this.mPaddingHor, 0, 0, 0);
            builder.src(R.attr.qmui_skin_support_quick_action_more_left_arrow);
        } else {
            arrowView.setPadding(0, 0, this.mPaddingHor, 0);
            builder.src(R.attr.qmui_skin_support_quick_action_more_right_arrow);
        }
        builder.tintColor(R.attr.qmui_skin_support_quick_action_more_tint_color);
        int bgColor = this.getBgColor();
        int bgColorAttr = this.getBgColorAttr();
        if (bgColorAttr != 0) {
            builder.background(bgColorAttr);
        } else if (bgColor != 0) {
            arrowView.setBackgroundColor(bgColor);
        }
        QMUISkinHelper.setSkinValue((View)arrowView, builder);
        arrowView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        arrowView.setVisibility(8);
        arrowView.setAlpha(0.0f);
        builder.release();
        return arrowView;
    }

    protected ItemView createItemView() {
        return new DefaultItemView(this.mContext);
    }

    public static class DefaultItemView
    extends ItemView {
        private AppCompatImageView mIconView;
        private TextView mTextView;

        public DefaultItemView(Context context) {
            this(context, null);
        }

        public DefaultItemView(Context context, AttributeSet attrs) {
            super(context, attrs);
            int paddingHor = QMUIResHelper.getAttrDimen(context, R.attr.qmui_quick_action_item_padding_hor);
            int paddingVer = QMUIResHelper.getAttrDimen(context, R.attr.qmui_quick_action_item_padding_ver);
            this.setPadding(paddingHor, paddingVer, paddingHor, paddingVer);
            this.mIconView = new AppCompatImageView(context);
            this.mIconView.setId(QMUIViewHelper.generateViewId());
            this.mTextView = new TextView(context);
            this.mTextView.setId(QMUIViewHelper.generateViewId());
            this.mTextView.setTextSize(10.0f);
            this.mTextView.setTypeface(Typeface.DEFAULT_BOLD);
            this.setChangeAlphaWhenPress(true);
            this.setChangeAlphaWhenDisable(true);
            int wrapContent = -2;
            ConstraintLayout.LayoutParams iconLp = new ConstraintLayout.LayoutParams(wrapContent, wrapContent);
            iconLp.leftToLeft = 0;
            iconLp.rightToRight = 0;
            iconLp.topToTop = 0;
            iconLp.bottomToTop = this.mTextView.getId();
            iconLp.verticalChainStyle = 2;
            this.addView((View)this.mIconView, (ViewGroup.LayoutParams)iconLp);
            ConstraintLayout.LayoutParams textLp = new ConstraintLayout.LayoutParams(wrapContent, wrapContent);
            textLp.leftToLeft = 0;
            textLp.rightToRight = 0;
            textLp.topToBottom = this.mIconView.getId();
            textLp.bottomToBottom = 0;
            textLp.topMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_quick_action_item_middle_space);
            textLp.verticalChainStyle = 2;
            textLp.goneTopMargin = 0;
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)textLp);
        }

        @Override
        public void render(Action action) {
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            if (action.icon != null || action.iconRes != 0) {
                if (action.icon != null) {
                    this.mIconView.setImageDrawable(action.icon.mutate());
                } else {
                    this.mIconView.setImageResource(action.iconRes);
                }
                if (action.iconTintColorAttr != 0) {
                    builder.tintColor(action.iconTintColorAttr);
                }
                this.mIconView.setVisibility(0);
                QMUISkinHelper.setSkinValue((View)this.mIconView, builder);
            } else if (action.iconAttr != 0) {
                builder.src(action.iconAttr);
                this.mIconView.setVisibility(0);
                QMUISkinHelper.setSkinValue((View)this.mIconView, builder);
            } else {
                this.mIconView.setVisibility(8);
            }
            this.mTextView.setText(action.text);
            builder.clear();
            builder.textColor(action.textColorAttr);
            QMUISkinHelper.setSkinValue((View)this.mTextView, builder);
            builder.release();
        }
    }

    public static abstract class ItemView
    extends QMUIConstraintLayout {
        public ItemView(Context context) {
            super(context);
        }

        public ItemView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public abstract void render(Action var1);
    }

    public static interface OnClickListener {
        public void onClick(QMUIQuickAction var1, Action var2, int var3);
    }

    public static class Action {
        @Nullable
        Drawable icon;
        int iconRes;
        @Nullable
        OnClickListener onClickListener;
        @Nullable
        CharSequence text;
        int iconAttr = 0;
        int textColorAttr = R.attr.qmui_skin_support_quick_action_item_tint_color;
        int iconTintColorAttr = R.attr.qmui_skin_support_quick_action_item_tint_color;

        public Action iconAttr(int iconAttr) {
            this.iconAttr = iconAttr;
            return this;
        }

        public Action icon(Drawable icon) {
            this.icon = icon;
            return this;
        }

        public Action icon(int iconRes) {
            this.iconRes = iconRes;
            return this;
        }

        public Action onClick(OnClickListener onClickListener) {
            this.onClickListener = onClickListener;
            return this;
        }

        public Action text(CharSequence text) {
            this.text = text;
            return this;
        }

        public Action textColorAttr(int textColorAttr) {
            this.textColorAttr = textColorAttr;
            return this;
        }

        public Action iconTintColorAttr(int iconTintColorAttr) {
            this.iconTintColorAttr = iconTintColorAttr;
            return this;
        }
    }

    private class Adapter
    extends ListAdapter<Action, VH>
    implements VH.Callback {
        protected Adapter() {
            super((DiffUtil.ItemCallback)new DiffCallback());
        }

        @NonNull
        public VH onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
            return new VH(QMUIQuickAction.this.createItemView(), this);
        }

        @Override
        public void onClick(View v, int adapterPosition) {
            Action action = (Action)this.getItem(adapterPosition);
            OnClickListener onClickListener = action.onClickListener;
            if (onClickListener != null) {
                onClickListener.onClick(QMUIQuickAction.this, action, adapterPosition);
            }
        }

        public void onBindViewHolder(@NonNull VH vh, int i) {
            ItemView view = (ItemView)vh.itemView;
            view.render((Action)this.getItem(i));
        }
    }

    private class DiffCallback
    extends DiffUtil.ItemCallback<Action> {
        private DiffCallback() {
        }

        public boolean areItemsTheSame(@NonNull Action action, @NonNull Action t1) {
            return Objects.equals(action.text, t1.text) && action.icon == t1.icon && action.iconAttr == t1.iconAttr && action.onClickListener == t1.onClickListener;
        }

        public boolean areContentsTheSame(@NonNull Action action, @NonNull Action t1) {
            return action.textColorAttr == t1.textColorAttr && action.iconTintColorAttr == t1.iconTintColorAttr;
        }
    }

    private static class VH
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private Callback callback;

        public VH(@NonNull ItemView itemView, @NonNull Callback callback) {
            super((View)itemView);
            itemView.setOnClickListener(this);
            this.callback = callback;
        }

        public void onClick(View v) {
            this.callback.onClick(v, this.getAdapterPosition());
        }

        static interface Callback {
            public void onClick(View var1, int var2);
        }
    }

    private class LayoutManager
    extends LinearLayoutManager {
        private static final float MILLISECONDS_PER_INCH = 0.01f;

        public LayoutManager(Context context) {
            super(context, 0, false);
        }

        public RecyclerView.LayoutParams generateDefaultLayoutParams() {
            return new RecyclerView.LayoutParams(QMUIQuickAction.this.mActionWidth, QMUIQuickAction.this.mActionHeight);
        }

        public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
            LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(recyclerView.getContext()){

                protected int calculateTimeForScrolling(int dx) {
                    return 100;
                }
            };
            linearSmoothScroller.setTargetPosition(position);
            this.startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
        }
    }

    private class ItemDecoration
    extends RecyclerView.ItemDecoration {
        private AppCompatImageView leftMoreArrowView;
        private AppCompatImageView rightMoreArrowView;
        private boolean isLeftMoreShown = false;
        private boolean isRightMoreShown = false;
        private boolean isFirstDraw = true;
        private int TOGGLE_DURATION = 60;
        private Runnable leftHideEndAction = new Runnable(){

            @Override
            public void run() {
                ItemDecoration.this.leftMoreArrowView.setVisibility(8);
            }
        };
        private Runnable rightHideEndAction = new Runnable(){

            @Override
            public void run() {
                ItemDecoration.this.rightMoreArrowView.setVisibility(8);
            }
        };

        public ItemDecoration(AppCompatImageView leftMoreArrowView, AppCompatImageView rightMoreArrowView) {
            this.leftMoreArrowView = leftMoreArrowView;
            this.rightMoreArrowView = rightMoreArrowView;
        }

        public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            if (parent.canScrollHorizontally(-1)) {
                if (!this.isLeftMoreShown) {
                    this.isLeftMoreShown = true;
                    this.leftMoreArrowView.setVisibility(0);
                    if (this.isFirstDraw) {
                        this.leftMoreArrowView.setAlpha(1.0f);
                    } else {
                        this.leftMoreArrowView.animate().alpha(1.0f).setDuration((long)this.TOGGLE_DURATION).start();
                    }
                }
            } else if (this.isLeftMoreShown) {
                this.isLeftMoreShown = false;
                this.leftMoreArrowView.animate().alpha(0.0f).setDuration((long)this.TOGGLE_DURATION).withEndAction(this.leftHideEndAction).start();
            }
            if (parent.canScrollHorizontally(1)) {
                if (!this.isRightMoreShown) {
                    this.isRightMoreShown = true;
                    this.rightMoreArrowView.setVisibility(0);
                    if (this.isFirstDraw) {
                        this.rightMoreArrowView.setAlpha(1.0f);
                    } else {
                        this.rightMoreArrowView.animate().setDuration((long)this.TOGGLE_DURATION).alpha(1.0f).start();
                    }
                }
            } else if (this.isRightMoreShown) {
                this.isRightMoreShown = false;
                this.rightMoreArrowView.animate().alpha(0.0f).setDuration((long)this.TOGGLE_DURATION).withEndAction(this.rightHideEndAction).start();
            }
            this.isFirstDraw = false;
        }
    }
}

