/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.section;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.layout.QMUIFrameLayout;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionItemDecoration;
import java.util.ArrayList;
import java.util.List;

public class QMUIStickySectionLayout
extends QMUIFrameLayout
implements QMUIStickySectionAdapter.ViewCallback {
    private RecyclerView mRecyclerView;
    private QMUIFrameLayout mStickySectionWrapView;
    private QMUIStickySectionItemDecoration mStickySectionItemDecoration;
    private int mStickySectionViewHeight = -1;
    private List<DrawDecoration> mDrawDecorations;
    private Runnable mPendingScrollAction = null;

    public QMUIStickySectionLayout(Context context) {
        this(context, null);
    }

    public QMUIStickySectionLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIStickySectionLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mStickySectionWrapView = new QMUIFrameLayout(context);
        this.mRecyclerView = new RecyclerView(context);
        this.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.mStickySectionWrapView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.mStickySectionWrapView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                QMUIStickySectionLayout.this.mStickySectionViewHeight = bottom - top;
                if (QMUIStickySectionLayout.this.mStickySectionViewHeight > 0 && QMUIStickySectionLayout.this.mPendingScrollAction != null) {
                    QMUIStickySectionLayout.this.mPendingScrollAction.run();
                    QMUIStickySectionLayout.this.mPendingScrollAction = null;
                }
            }
        });
    }

    public void addDrawDecoration(@NonNull DrawDecoration drawDecoration) {
        if (this.mDrawDecorations == null) {
            this.mDrawDecorations = new ArrayList<DrawDecoration>();
        }
        this.mDrawDecorations.add(drawDecoration);
    }

    public void removeDrawDecoration(@NonNull DrawDecoration drawDecoration) {
        if (this.mDrawDecorations == null || this.mDrawDecorations.isEmpty()) {
            return;
        }
        this.mDrawDecorations.remove(drawDecoration);
    }

    public void configStickySectionWrapView(StickySectionWrapViewConfig stickySectionWrapViewConfig) {
        if (stickySectionWrapViewConfig != null) {
            stickySectionWrapViewConfig.config(this.mStickySectionWrapView);
        }
    }

    public QMUIFrameLayout getStickySectionWrapView() {
        return this.mStickySectionWrapView;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Nullable
    public View getStickySectionView() {
        if (this.mStickySectionWrapView.getVisibility() != 0 || this.mStickySectionWrapView.getChildCount() == 0) {
            return null;
        }
        return this.mStickySectionWrapView.getChildAt(0);
    }

    public int getStickyHeaderPosition() {
        if (this.mStickySectionItemDecoration == null) {
            return -1;
        }
        return this.mStickySectionItemDecoration.getStickyHeaderViewPosition();
    }

    public void setLayoutManager(@NonNull RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.setLayoutManager(layoutManager);
    }

    public <H extends QMUISection.Model<H>, T extends QMUISection.Model<T>, VH extends QMUIStickySectionAdapter.ViewHolder> void setAdapter(QMUIStickySectionAdapter<H, T, VH> adapter) {
        this.setAdapter(adapter, true);
    }

    public <H extends QMUISection.Model<H>, T extends QMUISection.Model<T>, VH extends QMUIStickySectionAdapter.ViewHolder> void setAdapter(final QMUIStickySectionAdapter<H, T, VH> adapter, boolean sticky) {
        if (sticky) {
            QMUIStickySectionItemDecoration.Callback callback = new QMUIStickySectionItemDecoration.Callback<VH>(){

                @Override
                public int getRelativeStickyItemPosition(int pos) {
                    return adapter.getRelativeStickyPosition(pos);
                }

                @Override
                public boolean isHeaderItem(int pos) {
                    return adapter.getItemViewType(pos) == 0;
                }

                @Override
                public VH createViewHolder(ViewGroup parent, int viewType) {
                    return (Object)((QMUIStickySectionAdapter.ViewHolder)adapter.createViewHolder(parent, viewType));
                }

                @Override
                public void bindViewHolder(VH holder, int position) {
                    adapter.bindViewHolder((RecyclerView.ViewHolder)holder, position);
                }

                @Override
                public int getItemViewType(int position) {
                    return adapter.getItemViewType(position);
                }

                @Override
                public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
                    adapter.registerAdapterDataObserver(observer);
                }

                @Override
                public void onHeaderVisibilityChanged(boolean visible) {
                }

                @Override
                public void invalidate() {
                    QMUIStickySectionLayout.this.mRecyclerView.invalidate();
                }
            };
            this.mStickySectionItemDecoration = new QMUIStickySectionItemDecoration((ViewGroup)this.mStickySectionWrapView, callback);
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.mStickySectionItemDecoration);
        }
        adapter.setViewCallback(this);
        this.mRecyclerView.setAdapter(adapter);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mStickySectionItemDecoration != null) {
            this.mStickySectionWrapView.layout(this.mStickySectionWrapView.getLeft(), this.mStickySectionItemDecoration.getTargetTop(), this.mStickySectionWrapView.getRight(), this.mStickySectionItemDecoration.getTargetTop() + this.mStickySectionWrapView.getHeight());
        }
    }

    @Override
    public void scrollToPosition(final int position, boolean isSectionHeader, final boolean scrollToTop) {
        this.mPendingScrollAction = null;
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        if (adapter == null || position < 0 || position >= adapter.getItemCount()) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            int firstVPos = linearLayoutManager.findFirstCompletelyVisibleItemPosition();
            int lastVPos = linearLayoutManager.findLastCompletelyVisibleItemPosition();
            int offset = 0;
            if (!isSectionHeader) {
                if (this.mStickySectionViewHeight <= 0) {
                    this.mPendingScrollAction = new Runnable(){

                        @Override
                        public void run() {
                            QMUIStickySectionLayout.this.scrollToPosition(position, false, scrollToTop);
                        }
                    };
                }
                offset = this.mStickySectionWrapView.getHeight();
            }
            if (position < firstVPos + 1 || position > lastVPos || scrollToTop) {
                linearLayoutManager.scrollToPositionWithOffset(position, offset);
            }
        } else {
            this.mRecyclerView.scrollToPosition(position);
        }
    }

    @Override
    @Nullable
    public RecyclerView.ViewHolder findViewHolderForAdapterPosition(int position) {
        return this.mRecyclerView.findViewHolderForAdapterPosition(position);
    }

    @Override
    public void requestChildFocus(View view) {
        this.mRecyclerView.requestChildFocus(view, null);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.mDrawDecorations != null) {
            for (DrawDecoration drawDecoration : this.mDrawDecorations) {
                drawDecoration.onDraw(canvas, this);
            }
        }
        super.dispatchDraw(canvas);
        if (this.mDrawDecorations != null) {
            for (DrawDecoration drawDecoration : this.mDrawDecorations) {
                drawDecoration.onDrawOver(canvas, this);
            }
        }
    }

    public void onDescendantInvalidated(@NonNull View child, @NonNull View target) {
        super.onDescendantInvalidated(child, target);
        if (target == this.mRecyclerView && this.mDrawDecorations != null && !this.mDrawDecorations.isEmpty()) {
            this.invalidate();
        }
    }

    public static interface DrawDecoration {
        public void onDraw(@NonNull Canvas var1, @NonNull QMUIStickySectionLayout var2);

        public void onDrawOver(@NonNull Canvas var1, @NonNull QMUIStickySectionLayout var2);
    }

    public static interface StickySectionWrapViewConfig {
        public void config(QMUIFrameLayout var1);
    }
}

