/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import com.qmuiteam.qmui.util.QMUIColorHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;

public class QMUITabIcon
extends Drawable
implements Drawable.Callback {
    public static final int TAB_ICON_INTRINSIC = -1;
    @NonNull
    private Drawable mNormalIconDrawable;
    @Nullable
    private Drawable mSelectedIconDrawable;
    private float mCurrentSelectFraction = 0.0f;
    private boolean mDynamicChangeIconColor = true;

    public QMUITabIcon(@NonNull Drawable normalIconDrawable, @Nullable Drawable selectedIconDrawable) {
        this(normalIconDrawable, selectedIconDrawable, true);
    }

    public QMUITabIcon(@NonNull Drawable normalIconDrawable, @Nullable Drawable selectedIconDrawable, boolean dynamicChangeIconColor) {
        this.mNormalIconDrawable = normalIconDrawable.mutate();
        this.mNormalIconDrawable.setCallback((Drawable.Callback)this);
        if (selectedIconDrawable != null) {
            this.mSelectedIconDrawable = selectedIconDrawable.mutate();
            this.mSelectedIconDrawable.setCallback((Drawable.Callback)this);
        }
        this.mNormalIconDrawable.setAlpha(255);
        int nw = this.mNormalIconDrawable.getIntrinsicWidth();
        int nh = this.mNormalIconDrawable.getIntrinsicHeight();
        this.mNormalIconDrawable.setBounds(0, 0, nw, nh);
        if (this.mSelectedIconDrawable != null) {
            this.mSelectedIconDrawable.setAlpha(0);
            this.mSelectedIconDrawable.setBounds(0, 0, nw, nh);
        }
        this.mDynamicChangeIconColor = dynamicChangeIconColor;
    }

    public boolean hasSelectedIcon() {
        return this.mSelectedIconDrawable != null;
    }

    public void tint(int normalColor, int selectColor) {
        if (this.mSelectedIconDrawable == null) {
            DrawableCompat.setTint((Drawable)this.mNormalIconDrawable, (int)QMUIColorHelper.computeColor(normalColor, selectColor, this.mCurrentSelectFraction));
        } else {
            DrawableCompat.setTint((Drawable)this.mNormalIconDrawable, (int)normalColor);
            DrawableCompat.setTint((Drawable)this.mSelectedIconDrawable, (int)selectColor);
        }
        this.invalidateSelf();
    }

    public void tintNormal(int normalColor) {
        DrawableCompat.setTint((Drawable)this.mNormalIconDrawable, (int)normalColor);
        this.invalidateSelf();
    }

    public void tintSelected(int selectColor) {
        if (this.mSelectedIconDrawable != null) {
            DrawableCompat.setTint((Drawable)this.mSelectedIconDrawable, (int)selectColor);
            this.invalidateSelf();
        }
    }

    public void srcNormal(@NonNull Drawable normalDrawable) {
        int normalAlpha = (int)(255.0f * (1.0f - this.mCurrentSelectFraction));
        this.mNormalIconDrawable.setCallback(null);
        this.mNormalIconDrawable = normalDrawable.mutate();
        this.mNormalIconDrawable.setCallback((Drawable.Callback)this);
        this.mNormalIconDrawable.setAlpha(normalAlpha);
        this.invalidateSelf();
    }

    public void srcSelected(@NonNull Drawable selectDrawable) {
        int selectedAlpha = (int)(255.0f * this.mCurrentSelectFraction);
        if (this.mSelectedIconDrawable != null) {
            this.mSelectedIconDrawable.setCallback(null);
        }
        this.mSelectedIconDrawable = selectDrawable.mutate();
        this.mSelectedIconDrawable.setCallback((Drawable.Callback)this);
        this.mSelectedIconDrawable.setAlpha(selectedAlpha);
        this.invalidateSelf();
    }

    public void src(@NonNull Drawable normalDrawable, @NonNull Drawable selectDrawable) {
        int normalAlpha = (int)(255.0f * (1.0f - this.mCurrentSelectFraction));
        this.mNormalIconDrawable.setCallback(null);
        this.mNormalIconDrawable = normalDrawable.mutate();
        this.mNormalIconDrawable.setCallback((Drawable.Callback)this);
        this.mNormalIconDrawable.setAlpha(normalAlpha);
        if (this.mSelectedIconDrawable != null) {
            this.mSelectedIconDrawable.setCallback(null);
        }
        this.mSelectedIconDrawable = selectDrawable.mutate();
        this.mSelectedIconDrawable.setCallback((Drawable.Callback)this);
        this.mSelectedIconDrawable.setAlpha(255 - normalAlpha);
        this.invalidateSelf();
    }

    public void src(@NonNull Drawable normalDrawable, int normalColor, int selectColor) {
        this.mNormalIconDrawable.setCallback((Drawable.Callback)this);
        this.mNormalIconDrawable = normalDrawable.mutate();
        this.mNormalIconDrawable.setCallback((Drawable.Callback)this);
        if (this.mSelectedIconDrawable != null) {
            this.mSelectedIconDrawable.setCallback(null);
            this.mSelectedIconDrawable = null;
        }
        if (this.mDynamicChangeIconColor) {
            DrawableCompat.setTint((Drawable)this.mNormalIconDrawable, (int)QMUIColorHelper.computeColor(normalColor, selectColor, this.mCurrentSelectFraction));
        }
        this.invalidateSelf();
    }

    public int getIntrinsicWidth() {
        return this.mNormalIconDrawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mNormalIconDrawable.getIntrinsicHeight();
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public void setSelectFraction(float fraction, int color2) {
        this.mCurrentSelectFraction = fraction = QMUILangHelper.constrain(fraction, 0.0f, 1.0f);
        if (this.mSelectedIconDrawable == null) {
            if (this.mDynamicChangeIconColor) {
                DrawableCompat.setTint((Drawable)this.mNormalIconDrawable, (int)color2);
            }
        } else {
            int normalAlpha = (int)(255.0f * (1.0f - fraction));
            this.mNormalIconDrawable.setAlpha(normalAlpha);
            this.mSelectedIconDrawable.setAlpha(255 - normalAlpha);
        }
        this.invalidateSelf();
    }

    public void draw(@NonNull Canvas canvas) {
        this.mNormalIconDrawable.draw(canvas);
        if (this.mSelectedIconDrawable != null) {
            this.mSelectedIconDrawable.draw(canvas);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        this.mNormalIconDrawable.setBounds(bounds);
        if (this.mSelectedIconDrawable != null) {
            this.mSelectedIconDrawable.setBounds(bounds);
        }
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(who);
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(who, what, when);
        }
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(who, what);
        }
    }
}

