/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerView;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.skin.defaultAttr.QMUISkinSimpleDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUICollapsingTextHelper;
import com.qmuiteam.qmui.util.QMUIColorHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButton;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabIcon;
import org.jetbrains.annotations.NotNull;

public class QMUITabView
extends FrameLayout
implements IQMUISkinHandlerView {
    private static final String TAG = "QMUITabView";
    private QMUITab mTab;
    private QMUICollapsingTextHelper mCollapsingTextHelper;
    private Interpolator mPositionInterpolator;
    private GestureDetector mGestureDetector;
    private Callback mCallback;
    private float mCurrentIconLeft = 0.0f;
    private float mCurrentIconTop = 0.0f;
    private float mCurrentTextLeft = 0.0f;
    private float mCurrentTextTop = 0.0f;
    private float mCurrentIconWidth = 0.0f;
    private float mCurrentIconHeight = 0.0f;
    private float mCurrentTextWidth = 0.0f;
    private float mCurrentTextHeight = 0.0f;
    private float mNormalIconLeft = 0.0f;
    private float mNormalIconTop = 0.0f;
    private float mNormalTextLeft = 0.0f;
    private float mNormalTextTop = 0.0f;
    private float mSelectedIconLeft = 0.0f;
    private float mSelectedIconTop = 0.0f;
    private float mSelectedTextLeft = 0.0f;
    private float mSelectedTextTop = 0.0f;
    private float mSelectFraction = 0.0f;
    private QMUIRoundButton mSignCountView;

    public QMUITabView(@NonNull Context context) {
        super(context);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.mCollapsingTextHelper = new QMUICollapsingTextHelper((View)this, 1.0f);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                if (QMUITabView.this.mCallback != null) {
                    QMUITabView.this.mCallback.onDoubleClick(QMUITabView.this);
                    return true;
                }
                return false;
            }

            public boolean onSingleTapUp(MotionEvent e) {
                if (QMUITabView.this.mCallback != null) {
                    QMUITabView.this.mCallback.onClick(QMUITabView.this);
                    return false;
                }
                return false;
            }

            public boolean onDown(MotionEvent e) {
                return QMUITabView.this.mCallback != null;
            }

            public void onLongPress(MotionEvent e) {
                if (QMUITabView.this.mCallback != null) {
                    QMUITabView.this.mCallback.onLongClick(QMUITabView.this);
                }
            }
        });
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setPositionInterpolator(Interpolator positionInterpolator) {
        this.mPositionInterpolator = positionInterpolator;
        this.mCollapsingTextHelper.setPositionInterpolator(positionInterpolator);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public void bind(QMUITab tab) {
        boolean hasSignCount;
        this.mCollapsingTextHelper.setTextSize(tab.normalTextSize, tab.selectedTextSize, false);
        this.mCollapsingTextHelper.setTypeface(tab.normalTypeface, tab.selectedTypeface, false);
        this.mCollapsingTextHelper.setTypefaceUpdateAreaPercent(tab.typefaceUpdateAreaPercent);
        int gravity = 51;
        this.mCollapsingTextHelper.setGravity(gravity, gravity, false);
        this.mCollapsingTextHelper.setText(tab.getText());
        this.mTab = tab;
        if (tab.tabIcon != null) {
            tab.tabIcon.setCallback((Drawable.Callback)this);
        }
        boolean hasRedPoint = this.mTab.signCount == -1;
        boolean bl = hasSignCount = this.mTab.signCount > 0;
        if (hasRedPoint || hasSignCount) {
            this.ensureSignCountView(this.getContext());
            FrameLayout.LayoutParams signCountLp = (FrameLayout.LayoutParams)this.mSignCountView.getLayoutParams();
            if (hasSignCount) {
                this.mSignCountView.setText(QMUILangHelper.formatNumberToLimitedDigits(this.mTab.signCount, this.mTab.signCountDigits));
                this.mSignCountView.setMinWidth(QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_tab_sign_count_view_min_size_with_text));
                signCountLp.width = -2;
                signCountLp.height = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_tab_sign_count_view_min_size_with_text);
            } else {
                int redPointSize;
                this.mSignCountView.setText(null);
                signCountLp.width = redPointSize = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_tab_sign_count_view_min_size);
                signCountLp.height = redPointSize;
            }
            this.mSignCountView.setLayoutParams((ViewGroup.LayoutParams)signCountLp);
            this.mSignCountView.setVisibility(0);
        } else if (this.mSignCountView != null) {
            this.mSignCountView.setVisibility(8);
        }
        this.updateSkinInfo(tab);
        this.requestLayout();
    }

    public float getSelectFraction() {
        return this.mSelectFraction;
    }

    public void setSelectFraction(float fraction) {
        this.mSelectFraction = fraction = QMUILangHelper.constrain(fraction, 0.0f, 1.0f);
        QMUITabIcon tabIcon = this.mTab.getTabIcon();
        if (tabIcon != null) {
            tabIcon.setSelectFraction(fraction, QMUIColorHelper.computeColor(this.mTab.getNormalColor((View)this), this.mTab.getSelectColor((View)this), fraction));
        }
        this.updateCurrentInfo(fraction);
        this.mCollapsingTextHelper.setExpansionFraction(1.0f - fraction);
        if (this.mSignCountView != null) {
            Point point = this.calculateSignCountLayoutPosition();
            int x = point.x;
            int y = point.y;
            if (point.x + this.mSignCountView.getMeasuredWidth() > this.getMeasuredWidth()) {
                x = this.getMeasuredWidth() - this.mSignCountView.getMeasuredWidth();
            }
            if (point.y - this.mSignCountView.getMeasuredHeight() < 0) {
                y = this.mSignCountView.getMeasuredHeight();
            }
            ViewCompat.offsetLeftAndRight((View)this.mSignCountView, (int)(x - this.mSignCountView.getLeft()));
            ViewCompat.offsetTopAndBottom((View)this.mSignCountView, (int)(y - this.mSignCountView.getBottom()));
        }
    }

    private void updateCurrentInfo(float fraction) {
        this.mCurrentIconLeft = QMUICollapsingTextHelper.lerp(this.mNormalIconLeft, this.mSelectedIconLeft, fraction, this.mPositionInterpolator);
        this.mCurrentIconTop = QMUICollapsingTextHelper.lerp(this.mNormalIconTop, this.mSelectedIconTop, fraction, this.mPositionInterpolator);
        int normalIconWidth = this.mTab.getNormalTabIconWidth();
        int normalIconHeight = this.mTab.getNormalTabIconHeight();
        float selectedScale = this.mTab.getSelectedTabIconScale();
        this.mCurrentIconWidth = QMUICollapsingTextHelper.lerp(normalIconWidth, (float)normalIconWidth * selectedScale, fraction, this.mPositionInterpolator);
        this.mCurrentIconHeight = QMUICollapsingTextHelper.lerp(normalIconHeight, (float)normalIconHeight * selectedScale, fraction, this.mPositionInterpolator);
        this.mCurrentTextLeft = QMUICollapsingTextHelper.lerp(this.mNormalTextLeft, this.mSelectedTextLeft, fraction, this.mPositionInterpolator);
        this.mCurrentTextTop = QMUICollapsingTextHelper.lerp(this.mNormalTextTop, this.mSelectedTextTop, fraction, this.mPositionInterpolator);
        float normalTextWidth = this.mCollapsingTextHelper.getCollapsedTextWidth();
        float normalTextHeight = this.mCollapsingTextHelper.getCollapsedTextHeight();
        float selectedTextWidth = this.mCollapsingTextHelper.getExpandedTextWidth();
        float selectedTextHeight = this.mCollapsingTextHelper.getExpandedTextHeight();
        this.mCurrentTextWidth = QMUICollapsingTextHelper.lerp(normalTextWidth, selectedTextWidth, fraction, this.mPositionInterpolator);
        this.mCurrentTextHeight = QMUICollapsingTextHelper.lerp(normalTextHeight, selectedTextHeight, fraction, this.mPositionInterpolator);
    }

    public int getContentViewWidth() {
        if (this.mTab == null) {
            return 0;
        }
        float textWidth = this.mCollapsingTextHelper.getExpandedTextWidth();
        if (this.mTab.getTabIcon() == null) {
            return (int)((double)textWidth + 0.5);
        }
        int iconPosition = this.mTab.getIconPosition();
        float iconWidth = (float)this.mTab.getNormalTabIconWidth() * this.mTab.getSelectedTabIconScale();
        if (iconPosition == 3 || iconPosition == 1) {
            return (int)((double)Math.max(iconWidth, textWidth) + 0.5);
        }
        return (int)((double)(iconWidth + textWidth + (float)this.mTab.getIconTextGap()) + 0.5);
    }

    public int getContentViewLeft() {
        if (this.mTab == null) {
            return 0;
        }
        if (this.mTab.getTabIcon() == null) {
            return (int)((double)this.mSelectedTextLeft + 0.5);
        }
        int iconPosition = this.mTab.getIconPosition();
        if (iconPosition == 3 || iconPosition == 1) {
            return (int)Math.min((double)this.mSelectedTextLeft, (double)this.mSelectedIconLeft + 0.5);
        }
        if (iconPosition == 0) {
            return (int)((double)this.mSelectedIconLeft + 0.5);
        }
        return (int)((double)this.mSelectedTextLeft + 0.5);
    }

    private QMUIRoundButton ensureSignCountView(Context context) {
        if (this.mSignCountView == null) {
            this.mSignCountView = this.createSignCountView(context);
            FrameLayout.LayoutParams signCountLp = this.mSignCountView.getLayoutParams() != null ? new FrameLayout.LayoutParams(this.mSignCountView.getLayoutParams()) : new FrameLayout.LayoutParams(-2, -2);
            this.addView((View)this.mSignCountView, (ViewGroup.LayoutParams)signCountLp);
        }
        return this.mSignCountView;
    }

    protected QMUIRoundButton createSignCountView(Context context) {
        QMUIRoundButton btn = new QMUIRoundButton(context, null, R.attr.qmui_tab_sign_count_view);
        QMUISkinSimpleDefaultAttrProvider skinProvider = new QMUISkinSimpleDefaultAttrProvider();
        skinProvider.setDefaultSkinAttr("background", R.attr.qmui_skin_support_tab_sign_count_view_bg_color);
        skinProvider.setDefaultSkinAttr("textColor", R.attr.qmui_skin_support_tab_sign_count_view_text_color);
        btn.setTag(R.id.qmui_skin_default_attr_provider, skinProvider);
        return btn;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mTab == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.onMeasureTab(widthSize, heightSize);
        int useWidthMeasureSpec = widthMeasureSpec;
        int useHeightMeasureSpec = heightMeasureSpec;
        QMUITabIcon icon = this.mTab.getTabIcon();
        int iconPosition = this.mTab.getIconPosition();
        if (widthMode == Integer.MIN_VALUE) {
            widthSize = icon == null ? (int)this.mCollapsingTextHelper.getExpandedTextWidth() : (iconPosition == 3 || iconPosition == 1 ? (int)Math.max((float)this.mTab.getNormalTabIconWidth() * this.mTab.getSelectedTabIconScale(), this.mCollapsingTextHelper.getExpandedTextWidth()) : (int)(this.mCollapsingTextHelper.getExpandedTextWidth() + (float)this.mTab.getIconTextGap() + (float)this.mTab.getNormalTabIconWidth() * this.mTab.getSelectedTabIconScale()));
            if (this.mSignCountView != null && this.mSignCountView.getVisibility() != 8) {
                this.mSignCountView.measure(0, 0);
                widthSize = Math.max(widthSize, widthSize + this.mSignCountView.getMeasuredWidth() + this.mTab.signCountHorizontalOffset);
            }
            useWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = icon == null ? (int)this.mCollapsingTextHelper.getExpandedTextHeight() : (iconPosition == 0 || iconPosition == 2 ? (int)Math.max((float)this.mTab.getNormalTabIconHeight() * this.mTab.getSelectedTabIconScale(), this.mCollapsingTextHelper.getExpandedTextWidth()) : (int)(this.mCollapsingTextHelper.getExpandedTextHeight() + (float)this.mTab.getIconTextGap() + (float)this.mTab.getNormalTabIconHeight() * this.mTab.getSelectedTabIconScale()));
            useHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000);
        }
        super.onMeasure(useWidthMeasureSpec, useHeightMeasureSpec);
    }

    protected void onMeasureTab(int widthSize, int heightSize) {
        int textWidth = widthSize;
        int textHeight = heightSize;
        QMUITabIcon icon = this.mTab.getTabIcon();
        if (icon != null && !this.mTab.isAllowIconDrawOutside()) {
            float iconWidth = (float)this.mTab.getNormalTabIconWidth() * this.mTab.selectedTabIconScale;
            float iconHeight = (float)this.mTab.getNormalTabIconHeight() * this.mTab.selectedTabIconScale;
            int iconPosition = this.mTab.iconPosition;
            if (iconPosition == 1 || iconPosition == 3) {
                textHeight = (int)((float)textHeight - (iconHeight - (float)this.mTab.getIconTextGap()));
            } else {
                textWidth = (int)((float)textWidth - (iconWidth - (float)this.mTab.getIconTextGap()));
            }
        }
        this.mCollapsingTextHelper.setCollapsedBounds(0, 0, textWidth, textHeight);
        this.mCollapsingTextHelper.setExpandedBounds(0, 0, textWidth, textHeight);
        this.mCollapsingTextHelper.calculateBaseOffsets();
    }

    protected final void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.onLayoutTab(right - left, bottom - top);
        this.onLayoutSignCount(right - left, bottom - top);
    }

    protected void onLayoutSignCount(int width, int height) {
        if (this.mSignCountView != null && this.mTab != null) {
            Point point = this.calculateSignCountLayoutPosition();
            int x = point.x;
            int y = point.y;
            if (point.x + this.mSignCountView.getMeasuredWidth() > width) {
                x = width - this.mSignCountView.getMeasuredWidth();
            }
            if (point.y - this.mSignCountView.getMeasuredHeight() < 0) {
                y = this.mSignCountView.getMeasuredHeight();
            }
            this.mSignCountView.layout(x, y - this.mSignCountView.getMeasuredHeight(), x + this.mSignCountView.getMeasuredWidth(), y);
        }
    }

    private Point calculateSignCountLayoutPosition() {
        int anchorTop;
        int anchorLeft;
        QMUITabIcon icon = this.mTab.getTabIcon();
        int iconPosition = this.mTab.getIconPosition();
        if (icon == null || iconPosition == 3 || iconPosition == 0) {
            anchorLeft = (int)(this.mCurrentTextLeft + this.mCurrentTextWidth);
            anchorTop = (int)this.mCurrentTextTop;
        } else {
            anchorLeft = (int)(this.mCurrentIconLeft + this.mCurrentIconWidth);
            anchorTop = (int)this.mCurrentIconTop;
        }
        Point point = new Point(anchorLeft, anchorTop);
        int verticalAlign = this.mTab.signCountVerticalAlign;
        int verticalOffset = this.mTab.signCountVerticalOffset;
        if (verticalAlign == 1) {
            point.offset(this.mTab.signCountHorizontalOffset, verticalOffset + this.mSignCountView.getMeasuredHeight());
        } else if (verticalAlign == 2) {
            point.y = this.getMeasuredHeight() - (this.getMeasuredHeight() - this.mSignCountView.getMeasuredHeight()) / 2;
            point.offset(this.mTab.signCountHorizontalOffset, verticalOffset);
        } else {
            point.offset(this.mTab.signCountHorizontalOffset, verticalOffset);
        }
        return point;
    }

    protected void onLayoutTab(int width, int height) {
        if (this.mTab == null) {
            return;
        }
        this.mCollapsingTextHelper.calculateCurrentOffsets();
        QMUITabIcon icon = this.mTab.getTabIcon();
        float normalTextWidth = this.mCollapsingTextHelper.getCollapsedTextWidth();
        float normalTextHeight = this.mCollapsingTextHelper.getCollapsedTextHeight();
        float selectedTextWidth = this.mCollapsingTextHelper.getExpandedTextWidth();
        float selectedTextHeight = this.mCollapsingTextHelper.getExpandedTextHeight();
        if (icon == null) {
            this.mSelectedIconTop = 0.0f;
            this.mSelectedIconLeft = 0.0f;
            this.mNormalIconTop = 0.0f;
            this.mNormalIconLeft = 0.0f;
            switch (this.mTab.gravity & 0x70) {
                case 80: {
                    this.mNormalTextTop = (float)height - normalTextHeight;
                    this.mSelectedTextTop = (float)height - selectedTextHeight;
                    break;
                }
                case 48: {
                    this.mNormalTextTop = 0.0f;
                    this.mSelectedTextTop = 0.0f;
                    break;
                }
                default: {
                    this.mNormalTextTop = ((float)height - normalTextHeight) / 2.0f;
                    this.mSelectedTextTop = ((float)height - selectedTextHeight) / 2.0f;
                }
            }
            switch (this.mTab.gravity & 0x800007) {
                case 5: {
                    this.mNormalTextLeft = (float)width - normalTextWidth;
                    this.mSelectedTextLeft = (float)width - selectedTextWidth;
                    break;
                }
                case 3: {
                    this.mNormalTextLeft = 0.0f;
                    this.mSelectedTextLeft = 0.0f;
                    break;
                }
                default: {
                    this.mNormalTextLeft = ((float)width - normalTextWidth) / 2.0f;
                    this.mSelectedTextLeft = ((float)width - selectedTextWidth) / 2.0f;
                    break;
                }
            }
        } else {
            int gap = this.mTab.getIconTextGap();
            int iconPosition = this.mTab.iconPosition;
            float normalIconWidth = this.mTab.getNormalTabIconWidth();
            float normalIconHeight = this.mTab.getNormalTabIconHeight();
            float selectedIconWidth = normalIconWidth * this.mTab.getSelectedTabIconScale();
            float selectedIconHeight = normalIconHeight * this.mTab.getSelectedTabIconScale();
            float normalTotalWidth = normalTextWidth + (float)gap + normalIconWidth;
            float normalTotalHeight = normalTextHeight + (float)gap + normalIconHeight;
            float selectedTotalWidth = selectedTextWidth + (float)gap + selectedIconWidth;
            float selectedTotalHeight = selectedTextHeight + (float)gap + selectedIconHeight;
            if (iconPosition == 1 || iconPosition == 3) {
                switch (this.mTab.gravity & 0x800007) {
                    case 5: {
                        this.mNormalIconLeft = (float)width - normalIconWidth;
                        this.mNormalTextLeft = (float)width - normalTextWidth;
                        this.mSelectedIconLeft = (float)width - selectedIconWidth;
                        this.mSelectedTextLeft = (float)width - selectedTextWidth;
                        break;
                    }
                    case 3: {
                        this.mNormalIconLeft = 0.0f;
                        this.mNormalTextLeft = 0.0f;
                        this.mSelectedIconLeft = 0.0f;
                        this.mSelectedTextLeft = 0.0f;
                        break;
                    }
                    default: {
                        this.mNormalIconLeft = ((float)width - normalIconWidth) / 2.0f;
                        this.mNormalTextLeft = ((float)width - normalTextWidth) / 2.0f;
                        this.mSelectedIconLeft = ((float)width - selectedIconWidth) / 2.0f;
                        this.mSelectedTextLeft = ((float)width - selectedTextWidth) / 2.0f;
                    }
                }
                switch (this.mTab.gravity & 0x70) {
                    case 80: {
                        if (iconPosition == 1) {
                            this.mNormalTextTop = (float)height - normalTextHeight;
                            this.mSelectedTextTop = (float)height - selectedTextHeight;
                            this.mNormalIconTop = this.mNormalTextTop - (float)gap - normalIconHeight;
                            this.mSelectedIconTop = this.mSelectedTextTop - (float)gap - selectedIconHeight;
                            break;
                        }
                        this.mNormalIconTop = (float)height - normalIconHeight;
                        this.mSelectedIconTop = (float)height - selectedIconHeight;
                        this.mNormalTextTop = this.mNormalIconTop - (float)gap - normalTextHeight;
                        this.mSelectedTextTop = this.mSelectedIconTop - (float)gap - selectedTextHeight;
                        break;
                    }
                    case 48: {
                        if (iconPosition == 1) {
                            this.mNormalIconTop = 0.0f;
                            this.mSelectedIconTop = 0.0f;
                            this.mNormalTextTop = normalIconHeight + (float)gap;
                            this.mSelectedTextTop = selectedIconHeight + (float)gap;
                            break;
                        }
                        this.mNormalTextTop = 0.0f;
                        this.mSelectedTextTop = 0.0f;
                        this.mNormalIconTop = normalTextHeight + (float)gap;
                        this.mSelectedIconTop = selectedTextHeight + (float)gap;
                        break;
                    }
                    default: {
                        if (iconPosition == 1) {
                            this.mNormalIconTop = normalTotalHeight >= (float)height ? (float)height - normalTotalHeight : ((float)height - normalTotalHeight) / 2.0f;
                            this.mNormalTextTop = this.mNormalIconTop + (float)gap + normalIconHeight;
                            this.mSelectedIconTop = selectedTotalHeight >= (float)height ? (float)height - selectedTotalHeight : ((float)height - selectedTotalHeight) / 2.0f;
                            this.mSelectedTextTop = this.mSelectedIconTop + (float)gap + selectedIconHeight;
                            break;
                        }
                        this.mNormalTextTop = normalTotalHeight >= (float)height ? 0.0f : ((float)height - normalTotalHeight) / 2.0f;
                        this.mNormalIconTop = this.mNormalTextTop + (float)gap + normalTextHeight;
                        this.mNormalTextTop = selectedTotalHeight >= (float)height ? 0.0f : ((float)height - selectedTotalHeight) / 2.0f;
                        this.mNormalIconTop = this.mNormalTextTop + (float)gap + selectedTextHeight;
                        break;
                    }
                }
            } else {
                switch (this.mTab.gravity & 0x70) {
                    case 80: {
                        this.mNormalIconTop = (float)height - normalIconHeight;
                        this.mNormalTextTop = (float)height - normalTextHeight;
                        this.mSelectedIconTop = (float)height - selectedIconHeight;
                        this.mSelectedTextTop = (float)height - selectedTextHeight;
                        break;
                    }
                    case 48: {
                        this.mNormalIconTop = 0.0f;
                        this.mNormalTextTop = 0.0f;
                        this.mSelectedIconTop = 0.0f;
                        this.mSelectedTextTop = 0.0f;
                        break;
                    }
                    default: {
                        this.mNormalIconTop = ((float)height - normalIconHeight) / 2.0f;
                        this.mNormalTextTop = ((float)height - normalTextHeight) / 2.0f;
                        this.mSelectedIconTop = ((float)height - selectedIconHeight) / 2.0f;
                        this.mSelectedTextTop = ((float)height - selectedTextHeight) / 2.0f;
                    }
                }
                switch (this.mTab.gravity & 0x800007) {
                    case 5: {
                        if (iconPosition == 2) {
                            this.mNormalTextLeft = (float)width - normalTotalWidth;
                            this.mSelectedTextLeft = (float)width - selectedTotalWidth;
                            this.mNormalIconLeft = (float)width - normalIconWidth;
                            this.mSelectedIconLeft = (float)width - selectedIconWidth;
                            break;
                        }
                        this.mNormalIconLeft = (float)width - normalTotalWidth;
                        this.mSelectedIconLeft = (float)width - selectedTotalWidth;
                        this.mNormalTextLeft = (float)width - normalTextWidth;
                        this.mSelectedTextLeft = (float)width - selectedTextWidth;
                        break;
                    }
                    case 3: {
                        if (iconPosition == 2) {
                            this.mNormalTextLeft = 0.0f;
                            this.mSelectedTextLeft = 0.0f;
                            this.mNormalIconLeft = normalTextWidth + (float)gap;
                            this.mSelectedIconLeft = selectedTextWidth + (float)gap;
                            break;
                        }
                        this.mNormalIconLeft = 0.0f;
                        this.mSelectedIconLeft = 0.0f;
                        this.mNormalTextLeft = normalIconWidth + (float)gap;
                        this.mSelectedTextLeft = selectedIconWidth + (float)gap;
                        break;
                    }
                    default: {
                        if (iconPosition == 2) {
                            this.mNormalTextLeft = ((float)width - normalTotalWidth) / 2.0f;
                            this.mSelectedTextLeft = ((float)width - selectedTotalWidth) / 2.0f;
                            this.mNormalIconLeft = this.mNormalTextLeft + normalTextWidth + (float)gap;
                            this.mSelectedIconLeft = this.mSelectedTextLeft + selectedTextWidth + (float)gap;
                            break;
                        }
                        this.mNormalIconLeft = ((float)width - normalTotalWidth) / 2.0f;
                        this.mSelectedIconLeft = ((float)width - selectedTotalWidth) / 2.0f;
                        this.mNormalTextLeft = this.mNormalIconLeft + normalIconWidth + (float)gap;
                        this.mSelectedTextLeft = this.mSelectedIconLeft + selectedIconWidth + (float)gap;
                    }
                }
                if (iconPosition == 0) {
                    this.mNormalIconLeft = normalTotalWidth >= (float)width ? (float)width - normalTotalWidth : ((float)width - normalTotalWidth) / 2.0f;
                    this.mNormalTextLeft = this.mNormalIconLeft + normalIconWidth + (float)gap;
                    this.mSelectedIconLeft = selectedTotalWidth >= (float)width ? (float)width - selectedTotalWidth : ((float)width - selectedTotalWidth) / 2.0f;
                    this.mSelectedTextLeft = this.mSelectedIconLeft + selectedIconWidth + (float)gap;
                } else {
                    this.mNormalTextLeft = normalTotalWidth >= (float)width ? 0.0f : ((float)width - normalTotalWidth) / 2.0f;
                    this.mNormalIconLeft = this.mNormalTextLeft + normalTextWidth + (float)gap;
                    this.mSelectedTextLeft = selectedTotalWidth >= (float)width ? 0.0f : ((float)width - selectedTotalWidth) / 2.0f;
                    this.mSelectedIconLeft = this.mSelectedTextLeft + selectedTextWidth + (float)gap;
                }
            }
        }
        this.updateCurrentInfo(1.0f - this.mCollapsingTextHelper.getExpansionFraction());
    }

    public void invalidateDrawable(@NonNull Drawable drawable2) {
        this.invalidate();
    }

    public final void draw(Canvas canvas) {
        this.onDrawTab(canvas);
        super.draw(canvas);
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setContentDescription(this.mTab.getText());
    }

    protected void onDrawTab(Canvas canvas) {
        if (this.mTab == null) {
            return;
        }
        QMUITabIcon icon = this.mTab.getTabIcon();
        if (icon != null) {
            canvas.save();
            canvas.translate(this.mCurrentIconLeft, this.mCurrentIconTop);
            icon.setBounds(0, 0, (int)this.mCurrentIconWidth, (int)this.mCurrentIconHeight);
            icon.draw(canvas);
            canvas.restore();
        }
        canvas.save();
        canvas.translate(this.mCurrentTextLeft, this.mCurrentTextTop);
        this.mCollapsingTextHelper.draw(canvas);
        canvas.restore();
    }

    @Override
    public void handle(@NotNull QMUISkinManager manager, int skinIndex, @NotNull Resources.Theme theme, @Nullable SimpleArrayMap<String, Integer> attrs) {
        if (this.mTab != null) {
            this.updateSkinInfo(this.mTab);
            this.invalidate();
        }
    }

    private void updateSkinInfo(QMUITab tab) {
        int normalColor = tab.getNormalColor((View)this);
        int selectedColor = tab.getSelectColor((View)this);
        this.mCollapsingTextHelper.setTextColor(ColorStateList.valueOf((int)normalColor), ColorStateList.valueOf((int)selectedColor), true);
        if (tab.tabIcon != null) {
            Drawable normalIcon;
            if (tab.skinChangeWithTintColor || tab.skinChangeNormalWithTintColor && tab.skinChangeSelectedWithTintColor) {
                tab.tabIcon.tint(normalColor, selectedColor);
            } else if (tab.tabIcon.hasSelectedIcon()) {
                Drawable selectedIcon;
                Drawable normalIcon2;
                if (tab.skinChangeNormalWithTintColor) {
                    tab.tabIcon.tintNormal(normalColor);
                } else if (tab.normalIconAttr != 0 && (normalIcon2 = QMUISkinHelper.getSkinDrawable((View)this, tab.normalIconAttr)) != null) {
                    tab.tabIcon.srcNormal(normalIcon2);
                }
                if (tab.skinChangeSelectedWithTintColor) {
                    tab.tabIcon.tintSelected(normalColor);
                } else if (tab.selectedIconAttr != 0 && (selectedIcon = QMUISkinHelper.getSkinDrawable((View)this, tab.selectedIconAttr)) != null) {
                    tab.tabIcon.srcSelected(selectedIcon);
                }
            } else if (tab.skinChangeNormalWithTintColor) {
                tab.tabIcon.tint(normalColor, selectedColor);
            } else if (tab.normalIconAttr != 0 && (normalIcon = QMUISkinHelper.getSkinDrawable((View)this, tab.normalIconAttr)) != null) {
                tab.tabIcon.src(normalIcon, normalColor, selectedColor);
            }
        }
    }

    public static interface Callback {
        public void onClick(QMUITabView var1);

        public void onDoubleClick(QMUITabView var1);

        public void onLongClick(QMUITabView var1);
    }
}

