/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.webview;

import android.util.Pair;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class QMUIWebViewBridgeHandler {
    private static final String MESSAGE_JS_FETCH_SCRIPT = "QMUIBridge._fetchQueueFromNative()";
    private static final String MESSAGE_JS_RESPONSE_SCRIPT = "QMUIBridge._handleResponseFromNative($data$)";
    private static final String MESSAGE_PARAM_HOLDER = "$data$";
    private static final String MESSAGE_CALLBACK_ID = "callbackId";
    private static final String MESSAGE_DATA = "data";
    private static final String MESSAGE_INNER_CMD_NAME = "__cmd__";
    private static final String MESSAGE_CMD_GET_SUPPORTED_CMD_LIST = "getSupportedCmdList";
    private List<Pair<String, ValueCallback<String>>> mStartupMessageList = new ArrayList<Pair<String, ValueCallback<String>>>();
    private WebView mWebView;

    public QMUIWebViewBridgeHandler(@NonNull WebView webView) {
        this.mWebView = webView;
    }

    public final void evaluateBridgeScript(String script, ValueCallback<String> resultCallback) {
        if (this.mStartupMessageList != null) {
            this.mStartupMessageList.add((Pair<String, ValueCallback<String>>)new Pair((Object)script, resultCallback));
        } else {
            this.mWebView.evaluateJavascript(script, resultCallback);
        }
    }

    void onBridgeLoaded() {
        if (this.mStartupMessageList != null) {
            for (Pair<String, ValueCallback<String>> message : this.mStartupMessageList) {
                this.mWebView.evaluateJavascript((String)message.first, (ValueCallback)message.second);
            }
            this.mStartupMessageList = null;
        }
    }

    void fetchAndMessageFromJs() {
        this.mWebView.evaluateJavascript(MESSAGE_JS_FETCH_SCRIPT, (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String value) {
                String unescaped = QMUIWebViewBridgeHandler.unescape(value);
                if (unescaped != null) {
                    try {
                        JSONArray array = new JSONArray(unescaped);
                        for (int i = 0; i < array.length(); ++i) {
                            JSONObject message = array.getJSONObject(i);
                            String callbackId = message.getString(QMUIWebViewBridgeHandler.MESSAGE_CALLBACK_ID);
                            String msgDataOrigin = message.getString(QMUIWebViewBridgeHandler.MESSAGE_DATA);
                            MessageFinishCallback callback = new MessageFinishCallback(callbackId){

                                @Override
                                public void finish(Object data) {
                                    try {
                                        JSONObject response = new JSONObject();
                                        response.put(QMUIWebViewBridgeHandler.MESSAGE_CALLBACK_ID, (Object)this.getCallbackId());
                                        response.put(QMUIWebViewBridgeHandler.MESSAGE_DATA, data);
                                        String script = QMUIWebViewBridgeHandler.MESSAGE_JS_RESPONSE_SCRIPT.replace(QMUIWebViewBridgeHandler.MESSAGE_PARAM_HOLDER, response.toString());
                                        QMUIWebViewBridgeHandler.this.mWebView.evaluateJavascript(script, null);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                            };
                            try {
                                JSONObject msgData = new JSONObject(msgDataOrigin);
                                String cmdName = msgData.getString(QMUIWebViewBridgeHandler.MESSAGE_INNER_CMD_NAME);
                                QMUIWebViewBridgeHandler.this.handleInnerMessage(cmdName, msgData, callback);
                                continue;
                            }
                            catch (Throwable e) {
                                QMUIWebViewBridgeHandler.this.handleMessage(msgDataOrigin, callback);
                            }
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void handleInnerMessage(String cmdName, JSONObject jsonObject, MessageFinishCallback callback) {
        if (!MESSAGE_CMD_GET_SUPPORTED_CMD_LIST.equals(cmdName)) {
            throw new RuntimeException("not a inner api message. fallback to custom message");
        }
        callback.finish(new JSONArray(this.getSupportedCmdList()));
    }

    protected abstract List<String> getSupportedCmdList();

    protected abstract void handleMessage(String var1, MessageFinishCallback var2);

    @Nullable
    public static String unescape(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        String ret = value.substring(1, value.length() - 1).replace("\\\\", "\\").replace("\\\"", "\"");
        if ("null".equals(ret)) {
            return null;
        }
        return ret;
    }

    @NonNull
    public static String escape(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return "\"null\"";
        }
        String ret = value.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + ret + "\"";
    }

    public abstract class MessageFinishCallback {
        private final String mCallbackId;

        public MessageFinishCallback(String callbackId) {
            this.mCallbackId = callbackId;
        }

        public String getCallbackId() {
            return this.mCallbackId;
        }

        public abstract void finish(Object var1);
    }
}

